/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.connection.ui;

import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.tizen.common.connection.ConnectionPlugin;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.service.FileEntry;

public class TizenRemoteFileLabelProvider
implements ITableLabelProvider {
    private Image mFileImage = ConnectionPlugin.getImageDescriptorFromPlugin("icons/connection/obj16/file.png").createImage();
    private Image mFolderImage = ConnectionPlugin.getImageDescriptorFromPlugin("icons/connection/obj16/directory.png").createImage();
    private Image mFileLinkImage = ConnectionPlugin.getImageDescriptorFromPlugin("icons/connection/obj16/file_link.png").createImage();
    private Image mFolderLinkImage = ConnectionPlugin.getImageDescriptorFromPlugin("icons/connection/obj16/directory_link.png").createImage();
    private Image mOtherImage = ConnectionPlugin.getImageDescriptorFromPlugin("icons/connection/obj16/file.png").createImage();
    private Image mEmulatorImage = ConnectionPlugin.getImageDescriptorFromPlugin("icons/connection/obj16/emulator.png").createImage();
    private Image mDeviceImage = ConnectionPlugin.getImageDescriptorFromPlugin("icons/connection/obj16/device.png").createImage();
    public static int index;

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            if (element instanceof FileEntry) {
                FileEntry entry = (FileEntry)element;
                switch (entry.getType()) {
                    case File: {
                        return this.mFileImage;
                    }
                    case Link: {
                        return this.mFileLinkImage;
                    }
                    case Directory: {
                        return this.mFolderImage;
                    }
                    case DirectoryLink: {
                        return this.mFolderLinkImage;
                    }
                    case RootEmulator: {
                        return this.mEmulatorImage;
                    }
                    case RootDevice: {
                        return this.mDeviceImage;
                    }
                }
                return this.mOtherImage;
            }
            return this.mOtherImage;
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof FileEntry) {
            FileEntry entry = (FileEntry)element;
            switch (columnIndex) {
                case 0: {
                    return entry.getName();
                }
                case 1: {
                    switch (index) {
                        case 0: {
                            return entry.getSize();
                        }
                        case 1: {
                            return entry.getDate();
                        }
                        case 2: {
                            return entry.getTime();
                        }
                        case 3: {
                            return entry.getPermissions();
                        }
                        case 4: {
                            return entry.getInfo();
                        }
                    }
                    break;
                }
            }
        } else if (element instanceof IDevice) {
            IDevice device = (IDevice)element;
            return device.getSerialNumber();
        }
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

