/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.sdblib;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.tizen.sdblib.DeviceMonitor;
import org.tizen.sdblib.IDebugBridgeChangeListener;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.IDeviceChangeListener;
import org.tizen.sdblib.app.ApplicationMonitor;
import org.tizen.sdblib.app.IApplication;
import org.tizen.sdblib.exception.ServerException;
import org.tizen.sdblib.util.DeviceUtil;
import org.tizen.sdblib.util.IOUtil;
import org.tizen.sdblib.util.Log;
import org.tizen.sdblib.util.ParsingUtil;
import org.tizen.sdblib.util.StreamGobbler;
import org.tizen.sdblib.util.StringUtil;

public final class SmartDevelopmentBridge {
    private static final String TAG_SDB = "sdb";
    private static final String TAG_SDBLIB = "sdblib";
    private static InetSocketAddress socketAddr;
    private static SmartDevelopmentBridge instance;
    private String mSdbOsLocation = null;
    private String mSdbLogLocation;
    protected Lock lock = new ReentrantLock();
    private boolean mStarted = false;
    private DeviceMonitor deviceMonitor;
    private ApplicationMonitor applicationMonitor;
    private static final ArrayList<IDebugBridgeChangeListener> sBridgeListeners;
    private static final ArrayList<IDeviceChangeListener> sDeviceListeners;
    private static List<IApplication> sInterestingApplications;
    private static final Object sLock;
    private boolean allowDetectAndroidDevices = false;

    static {
        sBridgeListeners = new ArrayList();
        sDeviceListeners = new ArrayList();
        sInterestingApplications = new ArrayList<IApplication>();
        sLock = sBridgeListeners;
    }

    protected static void init() {
        try {
            int sdbPort = ParsingUtil.parseInt(System.getenv("SDB_SERVER_PORT"), 26099);
            if (sdbPort <= 0) {
                throw new IllegalArgumentException("env var SDB_SERVER_PORT: must be >=0, got " + System.getenv("SDB_SERVER_PORT"));
            }
            socketAddr = new InetSocketAddress(InetAddress.getByName("127.0.0.1"), sdbPort);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("env var SDB_SERVER_PORT: illegal value '" + System.getenv("SDB_SERVER_PORT") + "'");
        }
        catch (SecurityException securityException) {
            Log.w(TAG_SDBLIB, "No access to env variables allowed by current security manager. If you've set SDB_SERVER_PORT: it's being ignored.");
        }
        catch (UnknownHostException e) {
            Log.e(TAG_SDB, "init socket failed:" + e);
        }
    }

    public static void terminate() {
        if (instance != null && SmartDevelopmentBridge.instance.deviceMonitor != null) {
            SmartDevelopmentBridge.instance.deviceMonitor.down();
            SmartDevelopmentBridge.instance.deviceMonitor = null;
        }
    }

    public SocketChannel openChannel() throws IOException {
        SocketChannel channel = null;
        try {
            channel = SocketChannel.open(socketAddr);
            channel.configureBlocking(false);
        }
        catch (IOException ie) {
            IOUtil.tryClose(channel);
            throw ie;
        }
        return channel;
    }

    public static SmartDevelopmentBridge createBridge(String location) {
        if (instance == null) {
            instance = new SmartDevelopmentBridge(location);
        } else {
            if (SmartDevelopmentBridge.instance.mSdbOsLocation != null && SmartDevelopmentBridge.instance.mSdbOsLocation.equals(location)) {
                return instance;
            }
            instance = new SmartDevelopmentBridge(location);
        }
        return instance;
    }

    public void startBridge() {
        this.startBridge(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startBridge(boolean allowDetectAndroidDevices) {
        Object object = sLock;
        synchronized (object) {
            if (instance != null && !instance.getStarted()) {
                instance.start(allowDetectAndroidDevices);
                SmartDevelopmentBridge.fireBridgetChanged(instance);
            }
        }
    }

    public static SmartDevelopmentBridge getBridge() {
        return instance;
    }

    public String getSdbOsLocation() {
        return this.mSdbOsLocation;
    }

    public void setSdbLogLocation(String sdbLogLocation) {
        this.mSdbLogLocation = sdbLogLocation;
    }

    public String getSdbLogLocation() {
        return this.mSdbLogLocation;
    }

    protected static void fireBridgetChanged(SmartDevelopmentBridge instance) {
        IDebugBridgeChangeListener[] iDebugBridgeChangeListenerArray = sBridgeListeners.toArray(new IDebugBridgeChangeListener[0]);
        int n = iDebugBridgeChangeListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDebugBridgeChangeListener listener = iDebugBridgeChangeListenerArray[n2];
            try {
                listener.bridgeChanged(instance);
            }
            catch (Exception e) {
                Log.e(TAG_SDBLIB, e);
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disconnectBridge() {
        Object object = sLock;
        synchronized (object) {
            if (instance != null) {
                instance.stop();
                instance = null;
                SmartDevelopmentBridge.fireBridgetChanged(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDebugBridgeChangeListener(IDebugBridgeChangeListener listener) {
        Object object = sLock;
        synchronized (object) {
            if (!sBridgeListeners.contains(listener)) {
                sBridgeListeners.add(listener);
                if (instance != null) {
                    try {
                        listener.bridgeChanged(instance);
                    }
                    catch (Exception e) {
                        Log.e(TAG_SDBLIB, e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeDebugBridgeChangeListener(IDebugBridgeChangeListener listener) {
        Object object = sLock;
        synchronized (object) {
            sBridgeListeners.remove(listener);
        }
    }

    public static void addDeviceChangeListener(IDeviceChangeListener listener) {
        SmartDevelopmentBridge.addDeviceChangeListener(listener, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDeviceChangeListener(IDeviceChangeListener listener, boolean bNotification) {
        IDevice[] devices = SmartDevelopmentBridge.getBridge().getDevices();
        Object object = sLock;
        synchronized (object) {
            if (!sDeviceListeners.contains(listener)) {
                sDeviceListeners.add(listener);
                if (bNotification) {
                    IDevice[] iDeviceArray = devices;
                    int n = devices.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IDevice device = iDeviceArray[n2];
                        if (DeviceUtil.isOnline(device)) {
                            listener.onConnected(device);
                        }
                        ++n2;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addInterestingApplication(IApplication app) {
        Object object = sLock;
        synchronized (object) {
            if (!sInterestingApplications.contains(app)) {
                sInterestingApplications.add(app);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeInterestingApplication(IApplication app) {
        Object object = sLock;
        synchronized (object) {
            sInterestingApplications.remove(app);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeDeviceChangeListener(IDeviceChangeListener listener) {
        Object object = sLock;
        synchronized (object) {
            sDeviceListeners.remove(listener);
        }
    }

    public IDevice[] getDevices() {
        if (this.deviceMonitor != null) {
            return this.deviceMonitor.getDevices();
        }
        return new IDevice[0];
    }

    public boolean isConnected() {
        if (this.deviceMonitor != null) {
            return this.deviceMonitor.isMonitoring();
        }
        return false;
    }

    public int getRestartAttemptCount() {
        if (this.deviceMonitor != null) {
            return this.deviceMonitor.getRestartAttemptCount();
        }
        return -1;
    }

    public boolean isDeviceListInitialized() {
        return this.deviceMonitor != null ? this.deviceMonitor.isDeviceListInitialized() : false;
    }

    private SmartDevelopmentBridge(String osLocation) throws InvalidParameterException {
        if (osLocation == null || osLocation.length() == 0) {
            throw new InvalidParameterException();
        }
        SmartDevelopmentBridge.init();
        this.mSdbOsLocation = osLocation;
    }

    private SmartDevelopmentBridge() {
    }

    boolean start() {
        return this.start(false);
    }

    boolean start(boolean allowDetectAndroidDevices) {
        try {
            this.allowDetectAndroidDevices = allowDetectAndroidDevices;
            this.deviceMonitor = new DeviceMonitor(this);
            this.deviceMonitor.boot();
            this.applicationMonitor = new ApplicationMonitor(this);
            this.applicationMonitor.boot();
            return true;
        }
        catch (ServerException e) {
            e.printStackTrace();
            return false;
        }
    }

    boolean stop() {
        if (!this.mStarted) {
            return false;
        }
        int numberDevice = this.deviceMonitor.getDevices().length;
        this.deviceMonitor.down();
        this.deviceMonitor = null;
        if (numberDevice == 0 && !this.stopSdb()) {
            return false;
        }
        this.setStarted(false);
        return true;
    }

    public void stopBridge() {
        this.deviceMonitor.down();
        this.deviceMonitor = null;
        this.stopSdb();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean restart() {
        if (this.mSdbOsLocation == null) {
            Log.e(TAG_SDB, "Cannot restart sdb when SmartDevelopmentBridge is created without the location of sdb.");
            return false;
        }
        SmartDevelopmentBridge smartDevelopmentBridge = this;
        synchronized (smartDevelopmentBridge) {
            this.stopSdb();
            boolean restart = this.startSdb();
            if (restart && this.deviceMonitor == null) {
                this.start();
            }
            return restart;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDeviceChangeListener[] getDeviceChangeListeners() {
        IDeviceChangeListener[] ret = new IDeviceChangeListener[sDeviceListeners.size()];
        Object object = sLock;
        synchronized (object) {
            return sDeviceListeners.toArray(ret);
        }
    }

    void deviceConnected(IDevice device) {
        IDeviceChangeListener[] iDeviceChangeListenerArray = this.getDeviceChangeListeners();
        int n = iDeviceChangeListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDeviceChangeListener listener = iDeviceChangeListenerArray[n2];
            try {
                listener.onConnected(device);
            }
            catch (Exception e) {
                Log.e(TAG_SDBLIB, e);
            }
            ++n2;
        }
    }

    void deviceDisconnected(IDevice device) {
        IDeviceChangeListener[] iDeviceChangeListenerArray = this.getDeviceChangeListeners();
        int n = iDeviceChangeListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDeviceChangeListener listener = iDeviceChangeListenerArray[n2];
            try {
                listener.onDisconnected(device);
            }
            catch (Exception e) {
                Log.e(TAG_SDBLIB, e);
            }
            ++n2;
        }
    }

    void deviceChanged(IDevice device, int changeMask) {
        IDeviceChangeListener[] iDeviceChangeListenerArray = this.getDeviceChangeListeners();
        int n = iDeviceChangeListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDeviceChangeListener listener = iDeviceChangeListenerArray[n2];
            try {
                listener.onChanged(device, changeMask);
            }
            catch (Exception e) {
                Log.e(TAG_SDBLIB, e);
            }
            ++n2;
        }
    }

    DeviceMonitor getDeviceMonitor() {
        return this.deviceMonitor;
    }

    synchronized boolean startSdb() {
        block5: {
            if (this.mSdbOsLocation == null) {
                Log.e(TAG_SDB, "Cannot start sdb when SmartDevelopmentBridge is created without the location of sdb.");
                return false;
            }
            String[] command = new String[]{this.mSdbOsLocation, "start-server"};
            Log.d(TAG_SDBLIB, String.format("launching '%1$s %2$s' to ensure SDB is running.", this.mSdbOsLocation, command[1]));
            Process proc = Runtime.getRuntime().exec(command);
            String error = this.grabProcessError(proc);
            if (error == null) break block5;
            Log.e(TAG_SDBLIB, "'sdb start-server' failed -- run manually if necessary");
            Log.e(TAG_SDBLIB, "Cause: " + error);
            return false;
        }
        try {
            Log.d(TAG_SDBLIB, "'sdb start-server' succeeded");
            this.setStarted(true);
            return true;
        }
        catch (IOException ioe) {
            Log.d(TAG_SDBLIB, "unable to run 'sdb': " + ioe.getMessage());
        }
        catch (InterruptedException ie) {
            Log.d(TAG_SDBLIB, "unable to run 'sdb': " + ie.getMessage());
        }
        return false;
    }

    private synchronized boolean stopSdb() {
        if (this.mSdbOsLocation == null) {
            Log.e(TAG_SDB, "Cannot stop sdb when SmartDevelopmentBridge is created without the location of sdb.");
            return false;
        }
        int status = -1;
        try {
            String[] command = new String[]{this.mSdbOsLocation, "kill-server"};
            Process proc = Runtime.getRuntime().exec(command);
            status = proc.waitFor();
            if (status == 0) {
                Log.d(TAG_SDBLIB, "'sdb kill-server' succeeded");
                this.setStarted(false);
                return true;
            }
        }
        catch (IOException ioe) {
            Log.e(TAG_SDB, "stop sdb failed:" + ioe);
        }
        catch (InterruptedException interruptedException) {}
        Log.w(TAG_SDBLIB, "'sdb kill-server' failed -- run manually if necessary");
        return false;
    }

    private String grabProcessError(Process process) throws InterruptedException {
        StreamGobbler errorGobbler = new StreamGobbler(process.getErrorStream());
        StreamGobbler inGobbler = new StreamGobbler(process.getInputStream());
        try {
            errorGobbler.boot();
            inGobbler.boot();
        }
        catch (ServerException serverException) {
            return "Fail to read from stream";
        }
        int status = process.waitFor();
        String error = errorGobbler.getResult();
        if (StringUtil.isEmpty(error)) {
            if (status == 0) {
                return null;
            }
            return "The sdb fail to execute start-server";
        }
        return error;
    }

    static Object getLock() {
        return sLock;
    }

    public void waitforStart() {
        this.waitforStart(-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitforStart(long timeout) {
        SmartDevelopmentBridge smartDevelopmentBridge = this;
        synchronized (smartDevelopmentBridge) {
            long startTime = System.currentTimeMillis();
            while (!this.isDeviceListInitialized()) {
                if (0L < timeout && timeout < System.currentTimeMillis() - startTime) {
                    return;
                }
                try {
                    Log.d(TAG_SDBLIB, "waiting for device list is initialized");
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public boolean getStarted() {
        this.lock.lock();
        try {
            boolean bl = this.mStarted;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    void setStarted(boolean isStarted) {
        this.lock.lock();
        try {
            this.mStarted = isStarted;
        }
        finally {
            this.lock.unlock();
        }
    }

    public IApplication[] getInterestingApplications() {
        return sInterestingApplications.toArray(new IApplication[0]);
    }

    public boolean isAllowDetectAndroidDevices() {
        return this.allowDetectAndroidDevices;
    }
}

