/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.sdblib.app.process;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.IShellOutputReceiver;
import org.tizen.sdblib.app.process.ProcessInfo;
import org.tizen.sdblib.receiver.MultiLineReceiver;
import org.tizen.sdblib.util.StringUtil;

public class DeviceProcessList {
    IDevice device = null;
    List<ProcessInfo> processInfoList;
    ProcessInfo[] processInfo = null;
    String[] cmdFilterPrefixes = null;
    Pattern numberPattern = Pattern.compile("[0-9]+");

    public DeviceProcessList(IDevice device) {
        this(device, (String)null);
    }

    public DeviceProcessList(IDevice device, String cmdFilterPrefix) {
        this(device, new String[]{cmdFilterPrefix});
    }

    public DeviceProcessList(IDevice device, String ... cmdFilterPrefixes) {
        this.device = device;
        this.processInfoList = new ArrayList<ProcessInfo>();
        this.cmdFilterPrefixes = cmdFilterPrefixes;
    }

    public ProcessInfo[] getProcessList() {
        try {
            String cmdQuery = "profile process";
            MultiLineReceiver receiver = new MultiLineReceiver(){

                @Override
                public void processNewLines(String[] lines) {
                    String[] stringArray = lines;
                    int n = lines.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Matcher m;
                        String line = stringArray[n2];
                        String[] token = StringUtil.split(line = line.trim(), " ");
                        if (token.length >= 2 && (m = DeviceProcessList.this.numberPattern.matcher(token[0])).matches()) {
                            String procId = token[0];
                            String cmd = "";
                            int i = 1;
                            while (i < token.length) {
                                cmd = cmd.concat(token[i]).concat(" ");
                                ++i;
                            }
                            if (DeviceProcessList.this.cmdFilterPrefixes == null || DeviceProcessList.this.cmdFilterPrefixes[0] == null) {
                                ProcessInfo info = new ProcessInfo(procId, token[1]);
                                info.setCmd(cmd);
                                DeviceProcessList.this.processInfoList.add(info);
                            } else {
                                String[] stringArray2 = DeviceProcessList.this.cmdFilterPrefixes;
                                int n3 = DeviceProcessList.this.cmdFilterPrefixes.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    String cmdFilterPrefix = stringArray2[n4];
                                    if (cmd.startsWith(cmdFilterPrefix)) {
                                        ProcessInfo info = new ProcessInfo(procId, token[1]);
                                        info.setCmd(cmd);
                                        DeviceProcessList.this.processInfoList.add(info);
                                    }
                                    ++n4;
                                }
                            }
                        }
                        ++n2;
                    }
                }
            };
            this.device.executeHostCommand(cmdQuery, (IShellOutputReceiver)receiver);
        }
        catch (IOException iOException) {}
        this.processInfo = new ProcessInfo[this.processInfoList.size()];
        return this.processInfoList.toArray(this.processInfo);
    }
}

