/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.sdblib.receiver;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.tizen.sdblib.service.FileEntry;
import org.tizen.sdblib.service.FileEntryType;
import org.tizen.sdblib.util.CollectionUtil;
import org.tizen.sdblib.util.StringUtil;

public class FileEntryFactory {
    static final String P_PERMISSIONS = "([bcdlsp-][-r][-w][-xsS][-r][-w][-xsS][-r][-w][-xstST])";
    static final String P_FILECOUNT = "(\\d{1,})";
    static final String P_OWNER = "(\\S+)";
    static final String P_GROUP = "(\\S+)";
    static final String P_SIZE = "([\\d\\s,]*)";
    static final String P_DATE = "(\\d{4}-\\d{2}-\\d{2}|[a-zA-Z]{3}\\s+\\d{1,2})";
    static final String P_TIME = "(\\d{1,2}:\\d{1,2}|[0-9]{4})";
    static final String P_NAME = "(.*)";
    static final String PATTERN_STRING = "^" + CollectionUtil.concatenate(new String[]{"([bcdlsp-][-r][-w][-xsS][-r][-w][-xsS][-r][-w][-xstST])", "(\\d{1,})", "(\\S+)", "(\\S+)", "([\\d\\s,]*)", "(\\d{4}-\\d{2}-\\d{2}|[a-zA-Z]{3}\\s+\\d{1,2})", "(\\d{1,2}:\\d{1,2}|[0-9]{4})", "(.*)"}, "\\s+") + "$";
    protected static final Pattern PATTERN = Pattern.compile(PATTERN_STRING);

    public static FileEntry create(FileEntry parent, String line) {
        Matcher m = PATTERN.matcher(line);
        if (!m.matches()) {
            return null;
        }
        String permissions = m.group(1);
        String owner = m.group(3);
        String group = m.group(4);
        String size = m.group(5);
        String date = m.group(6);
        String time = m.group(7);
        String name = m.group(8);
        String info = null;
        String linkTo = null;
        FileEntryType objectType = FileEntryType.from(permissions.charAt(0));
        if (objectType == FileEntryType.Link) {
            String[] segments = name.split("\\s->\\s");
            if (segments.length == 2) {
                name = segments[0];
                linkTo = segments[1];
                info = "-> " + linkTo;
                if (linkTo.endsWith("/")) {
                    objectType = FileEntryType.DirectoryLink;
                    name = StringUtil.trimTrailingCharacter(name, '/');
                }
            }
        } else if (objectType == FileEntryType.Directory) {
            name = StringUtil.trimTrailingCharacter(name, '/');
        } else if (objectType == FileEntryType.Socket) {
            name = StringUtil.trimTrailingCharacter(name, '=');
        } else if (objectType == FileEntryType.FIFO) {
            name = StringUtil.trimTrailingCharacter(name, '|');
        } else if (permissions.contains("x")) {
            name = StringUtil.trimTrailingCharacter(name, '*');
        }
        return new FileEntry(null, parent, name, objectType, permissions, owner, group, size, date, time, info, linkTo);
    }
}

