/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.sdblib.service;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.tizen.sdblib.Device;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.IShellOutputReceiver;
import org.tizen.sdblib.command.CommandFactory;
import org.tizen.sdblib.exception.SdbCommandRejectedException;
import org.tizen.sdblib.exception.ShellCommandUnresponsiveException;
import org.tizen.sdblib.exception.TimeoutException;
import org.tizen.sdblib.receiver.AppCmdReceiver;
import org.tizen.sdblib.receiver.AppInfo;
import org.tizen.sdblib.receiver.PackageInfo;
import org.tizen.sdblib.service.IAppCmdProgressMonitor;
import org.tizen.sdblib.service.SyncResult;
import org.tizen.sdblib.service.SyncService;
import org.tizen.sdblib.util.Assert;
import org.tizen.sdblib.util.Log;
import org.tizen.sdblib.util.StringUtil;

public class ApplicationCmdService {
    protected Device device;
    protected String appPackagePath;
    private static final String LOG_TAG = "ApplicationCmdService";

    public ApplicationCmdService(Device device) {
        Assert.notNull(device);
        this.device = device;
    }

    public boolean installPackage(PackageType type, String pkgfilePath, String pkgID, String tepPath) throws TimeoutException, SdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        return this.installPackage(type, pkgfilePath, pkgID, tepPath, null, null);
    }

    public boolean installPackage(PackageType type, String pkgfilePath, String pkgID, String tepPath, IShellOutputReceiver receiver) throws TimeoutException, SdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        return this.installPackage(type, pkgfilePath, pkgID, tepPath, receiver, null);
    }

    public boolean installPackage(PackageType type, String pkgfilePath, String pkgID, String tepPath, IAppCmdProgressMonitor monitor) throws TimeoutException, SdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        return this.installPackage(type, pkgfilePath, pkgID, tepPath, null, monitor);
    }

    public boolean installPackage(PackageType type, String pkgfilePath, String pkgID, String tepPath, IShellOutputReceiver receiver, IAppCmdProgressMonitor monitor) throws TimeoutException, SdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        String remotePkgfilePath = null;
        String remoteTepfilePath = null;
        String command = null;
        AppCmdReceiver.AppCmdReturn appCmdReturn = null;
        boolean result = false;
        if (pkgID == null) {
            remotePkgfilePath = this.transferPackage(pkgfilePath, monitor);
            if (remotePkgfilePath == null) {
                Log.e(LOG_TAG, "Fail to transfer package file.");
                return false;
            }
            if (tepPath != null && (remoteTepfilePath = this.transferPackage(pkgfilePath, monitor)) == null) {
                Log.e(LOG_TAG, "Fail to transfer package file.");
                return false;
            }
        }
        command = "install:" + type.getStringName() + ":" + remotePkgfilePath + ":" + pkgID + ":" + remoteTepfilePath;
        this.setSubTask(monitor, "Sending the install command to the device");
        appCmdReturn = this.runAppCmd(command, receiver);
        if (appCmdReturn.getAppCmdExitcode() == 0) {
            result = true;
        } else {
            Log.e(LOG_TAG, "Install service in the device has failed.");
        }
        return result;
    }

    public boolean uninstallPackage(String pkgID) throws TimeoutException, SdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        return this.uninstallPackage(pkgID, null);
    }

    public boolean uninstallPackage(String pkgID, IShellOutputReceiver receiver) throws TimeoutException, SdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        boolean result = false;
        AppCmdReceiver.AppCmdReturn appCmdReturn = null;
        String command = "uninstall:" + pkgID;
        appCmdReturn = this.runAppCmd(command, receiver);
        if (appCmdReturn.getAppCmdExitcode() == 0) {
            result = true;
        } else {
            Log.e(LOG_TAG, "Uninstall service in the device has failed.");
        }
        return result;
    }

    public PackageInfo queryPackageInfo(String pkgID) throws TimeoutException, SdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        PackageInfo pkgInfo = null;
        pkgInfo = this.getPackageInfoInternal(pkgID);
        return pkgInfo;
    }

    public PackageInfo[] queryPackageInfo(PackageType type, String pkgID) throws TimeoutException, SdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        PackageInfo[] pkgInfoArray = null;
        String[] pkgIDs = null;
        int itemCnt = 1;
        if (pkgID == null) {
            pkgIDs = this.getPackageListInternal(type);
            if (pkgIDs == null) {
                return null;
            }
            itemCnt = pkgIDs.length;
        } else {
            pkgIDs = new String[itemCnt];
            pkgIDs[0] = pkgID;
        }
        pkgInfoArray = new PackageInfo[itemCnt];
        int i = 0;
        while (i < pkgIDs.length) {
            pkgInfoArray[i] = this.getPackageInfoInternal(pkgIDs[i]);
            ++i;
        }
        return pkgInfoArray;
    }

    private String[] getPackageListInternal(PackageType type) throws TimeoutException, SdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        String command = "packagelist:" + type.getStringName();
        AppCmdReceiver.AppCmdReturn appCmdReturn = null;
        String pkgListRawString = null;
        String[] pkgIDs = null;
        appCmdReturn = this.runAppCmd(command, null);
        if (appCmdReturn.getAppCmdExitcode() == 0 && appCmdReturn.getAppCmdReturnStr() != null) {
            pkgListRawString = appCmdReturn.getAppCmdReturnStr();
            pkgIDs = StringUtil.split(pkgListRawString, ":");
        } else {
            Log.e(LOG_TAG, "Package list service in the device has failed.");
        }
        return pkgIDs;
    }

    private PackageInfo getPackageInfoInternal(String pkgID) throws TimeoutException, SdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        String command = "packageinfo:" + pkgID;
        AppCmdReceiver.AppCmdReturn appCmdReturn = null;
        String pkgInfoRawString = null;
        PackageInfo pkgInfo = null;
        AppInfo[] appInfoArray = null;
        appInfoArray = this.getAppInfoArrayInternal(pkgID);
        if (appInfoArray == null) {
            Log.e(LOG_TAG, "failed to get application info.");
            return null;
        }
        appCmdReturn = this.runAppCmd(command, null);
        if (appCmdReturn.getAppCmdExitcode() == 0 && appCmdReturn.getAppCmdReturnStr() != null) {
            pkgInfoRawString = appCmdReturn.getAppCmdReturnStr();
            String[] splittedWord = StringUtil.split(pkgInfoRawString, ":");
            if (splittedWord != null && splittedWord.length == 4) {
                String mainAppID = splittedWord[0];
                PackageType pkgType = PackageType.getType(splittedWord[1]);
                boolean isRemovable = Integer.parseInt(splittedWord[2]) == 1;
                boolean isRunning = Integer.parseInt(splittedWord[3]) == 1;
                pkgInfo = new PackageInfo(pkgID, mainAppID, pkgType, isRemovable, isRunning, appInfoArray);
            } else {
                Log.e(LOG_TAG, "Fail to parse package info.");
            }
        } else {
            Log.e(LOG_TAG, "Package info service in the device has failed.");
        }
        return pkgInfo;
    }

    private AppInfo[] getAppInfoArrayInternal(String pkgID) throws TimeoutException, SdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        String command = "appinfo:" + pkgID;
        AppCmdReceiver.AppCmdReturn appCmdReturn = null;
        String appInfoRawString = null;
        AppInfo[] appInfoArray = null;
        int itemCnt = 1;
        appCmdReturn = this.runAppCmd(command, null);
        if (appCmdReturn.getAppCmdExitcode() == 0 && appCmdReturn.getAppCmdReturnStr() != null) {
            appInfoRawString = appCmdReturn.getAppCmdReturnStr();
            String[] splittedWord = StringUtil.split(appInfoRawString, ":");
            itemCnt = splittedWord.length / 2;
            if (splittedWord.length % 2 != 0 || itemCnt <= 0) {
                Log.e(LOG_TAG, "Fail to parse application info.");
                return null;
            }
            appInfoArray = new AppInfo[itemCnt];
            int i = 0;
            while (i < itemCnt) {
                String appID = splittedWord[i * 2];
                ApplicationType appType = ApplicationType.getType(splittedWord[i * 2 + 1]);
                appInfoArray[i] = new AppInfo(appID, pkgID, appType);
                ++i;
            }
        } else {
            Log.e(LOG_TAG, "App info service in the device has failed.");
        }
        return appInfoArray;
    }

    public String queryAppInstallPath() throws TimeoutException, SdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        AppCmdReceiver.AppCmdReturn appCmdReturn = null;
        String appInstallPath = null;
        String command = "appinstallpath:";
        appCmdReturn = this.runAppCmd(command, null);
        if (appCmdReturn.getAppCmdExitcode() == 0 && appCmdReturn.getAppCmdReturnStr() != null) {
            appInstallPath = appCmdReturn.getAppCmdReturnStr();
        } else {
            Log.e(LOG_TAG, "App install path service in the device has failed.");
        }
        return appInstallPath;
    }

    public boolean runApplication(String appID) throws TimeoutException, SdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        return this.runApplication(appID, null);
    }

    public boolean runApplication(String appID, IShellOutputReceiver receiver) throws TimeoutException, SdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        boolean result = false;
        AppCmdReceiver.AppCmdReturn appCmdReturn = null;
        String command = "runapp:" + appID;
        appCmdReturn = this.runAppCmd(command, receiver);
        if (appCmdReturn.getAppCmdExitcode() == 0) {
            result = true;
        } else {
            Log.e(LOG_TAG, "Run app service in the device has failed.");
        }
        return result;
    }

    public boolean runUnitTestApplication(String appID, String usrArgs, IShellOutputReceiver receiver) throws TimeoutException, SdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        boolean result = false;
        AppCmdReceiver.AppCmdReturn appCmdReturn = null;
        String command = "rununittestapp:" + appID + ":" + usrArgs;
        appCmdReturn = this.runAppCmd(command, receiver);
        if (appCmdReturn.getAppCmdExitcode() == 0) {
            result = true;
        } else {
            Log.e(LOG_TAG, "Run unit test service in the device has failed.");
        }
        return result;
    }

    public boolean killApplication(String appID) throws TimeoutException, SdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        return this.killApplication(appID, null);
    }

    public boolean killApplication(String appID, IShellOutputReceiver receiver) throws TimeoutException, SdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        boolean result = false;
        AppCmdReceiver.AppCmdReturn appCmdReturn = null;
        String command = "killapp:" + appID;
        appCmdReturn = this.runAppCmd(command, receiver);
        if (appCmdReturn.getAppCmdExitcode() == 0) {
            result = true;
        } else {
            Log.e(LOG_TAG, "kill app service in the device has failed.");
        }
        return result;
    }

    public boolean debugNativeApplication(int debugPort, String appID, int pID, String gdbServerPath) throws TimeoutException, SdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        boolean result = false;
        AppCmdReceiver.AppCmdReturn appCmdReturn = null;
        int success_exit_code = 0;
        String command = "debugnativeapp:" + debugPort + ":" + appID + ":" + pID + ":" + gdbServerPath;
        appCmdReturn = this.runAppCmd(command, null);
        if (pID != -1) {
            success_exit_code = pID & 0xFF;
        }
        if (appCmdReturn.getAppCmdExitcode() == success_exit_code) {
            result = true;
        } else {
            Log.e(LOG_TAG, "debug native app service in the device has failed.");
        }
        return result;
    }

    public int debugWebApplication(String appID) throws TimeoutException, SdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        int port = -1;
        AppCmdReceiver.AppCmdReturn appCmdReturn = null;
        String command = "debugwebapp:" + appID;
        appCmdReturn = this.runAppCmd(command, null);
        if (appCmdReturn.getAppCmdExitcode() == 0 && appCmdReturn.getAppCmdReturnStr() != null) {
            port = Integer.parseInt(appCmdReturn.getAppCmdReturnStr());
        } else {
            Log.e(LOG_TAG, "debug web app service in the device has failed.");
        }
        return port;
    }

    private AppCmdReceiver.AppCmdReturn runAppCmd(String command, IShellOutputReceiver receiver) throws TimeoutException, SdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        AppCmdReceiver appCmdReceiver = new AppCmdReceiver(receiver);
        CommandFactory.execute(command, "appcmd:").in((IDevice)this.device, appCmdReceiver);
        return appCmdReceiver.getAppCmdReturn();
    }

    private String transferPackage(String pkgfilePath, IAppCmdProgressMonitor monitor) throws IOException {
        SyncService sync = null;
        String remotePackageFilePath = null;
        this.setSubTask(monitor, "Querying the location where you want to copy the package file.");
        String destDir = this.getAppPackagePath();
        if (destDir == null) {
            Log.e(LOG_TAG, "Fail to get destination directory path for package install.");
            return null;
        }
        this.setSubTask(monitor, "Pushing the package file to the device.");
        sync = this.device.getSyncService();
        SyncResult syncResult = sync.push(new String[]{pkgfilePath}, this.device.getFileEntry(destDir), monitor);
        if (!syncResult.isOk()) {
            Log.e(LOG_TAG, "Fail to push package.");
            return null;
        }
        Log.d(LOG_TAG, "Success to push package.");
        Path pkgFilePathName = Paths.get(pkgfilePath, new String[0]).getFileName();
        if (pkgFilePathName != null) {
            remotePackageFilePath = String.valueOf(destDir) + pkgFilePathName.toString();
        } else {
            Log.e(LOG_TAG, "Fail to get package file name from package");
        }
        return remotePackageFilePath;
    }

    private String getAppPackagePath() throws TimeoutException, SdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        if (this.appPackagePath == null) {
            String appInstallPath = this.queryAppInstallPath();
            if (appInstallPath != null) {
                this.appPackagePath = String.valueOf(appInstallPath) + "/tmp/";
            } else {
                Log.e(LOG_TAG, "fail to get app install path.");
            }
        }
        return this.appPackagePath;
    }

    private void setSubTask(IAppCmdProgressMonitor monitor, String name) {
        if (monitor != null) {
            monitor.startAppCmdSubTask(name);
        }
    }

    public static enum ApplicationType {
        WebApp{

            @Override
            protected String getStringName() {
                return ApplicationType.WEBAPP_TYPE_STR;
            }
        }
        ,
        CApp{

            @Override
            protected String getStringName() {
                return ApplicationType.CAPP_TYPE_STR;
            }
        }
        ,
        UnknownApp{

            @Override
            protected String getStringName() {
                return ApplicationType.UNKNOWNAPP_TYPE_STR;
            }
        };

        private static final String WEBAPP_TYPE_STR = "webapp";
        private static final String CAPP_TYPE_STR = "capp";
        private static final String UNKNOWNAPP_TYPE_STR = "unknown";

        protected abstract String getStringName();

        protected static ApplicationType getType(String strName) {
            if (strName.equals(WebApp.getStringName())) {
                return WebApp;
            }
            if (strName.equals(CApp.getStringName())) {
                return CApp;
            }
            return UnknownApp;
        }
    }

    public static enum PackageType {
        WebPkg{

            @Override
            protected String getStringName() {
                return PackageType.WEBAPP_TYPE_STR;
            }
        }
        ,
        NativePkg{

            @Override
            protected String getStringName() {
                return PackageType.NATIVEAPP_TYPE_STR;
            }
        }
        ,
        RPMPkg{

            @Override
            protected String getStringName() {
                return PackageType.RPM_TYPE_STR;
            }
        }
        ,
        UnknownPkg{

            @Override
            protected String getStringName() {
                return PackageType.UNKNOWNPKG_TYPE_STR;
            }
        };

        private static final String WEBAPP_TYPE_STR = "wgt";
        private static final String NATIVEAPP_TYPE_STR = "tpk";
        private static final String RPM_TYPE_STR = "rpm";
        private static final String UNKNOWNPKG_TYPE_STR = "unknown";

        protected abstract String getStringName();

        protected static PackageType getType(String strName) {
            if (strName.equals(WebPkg.getStringName())) {
                return WebPkg;
            }
            if (strName.equals(NativePkg.getStringName())) {
                return NativePkg;
            }
            if (strName.equals(RPMPkg.getStringName())) {
                return RPMPkg;
            }
            return UnknownPkg;
        }
    }
}

