/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.sdblib.service;

import java.util.Map;
import org.tizen.sdblib.util.MapUtil;

public enum SyncServiceReturnCode {
    RESULT_OK(0),
    RESULT_CANCELED(1),
    RESULT_UNKNOWN_ERROR(2),
    RESULT_CONNECTION_ERROR(3),
    RESULT_NO_REMOTE_OBJECT(4),
    RESULT_TARGET_IS_FILE(5),
    RESULT_NO_DIR_TARGET(6),
    RESULT_REMOTE_PATH_ENCODING(7),
    RESULT_REMOTE_PATH_LENGTH(8),
    RESULT_FILE_WRITE_ERROR(9),
    RESULT_FILE_READ_ERROR(10),
    RESULT_NO_LOCAL_FILE(11),
    RESULT_LOCAL_IS_DIRECTORY(12),
    RESULT_REMOTE_IS_FILE(13),
    RESULT_BUFFER_OVERRUN(14),
    RESULT_CONNECTION_TIMEOUT(15),
    RESULT_FILE_EXIST(16),
    RESULT_FAIL_DELETE_FILE(17),
    RESULT_FAIL_CREATE_FILE(18),
    RESULT_FAIL_GET_FOLDER_SIZE(19);

    private int value;
    protected static final Map<Integer, String> CODE2MESSAGE;

    static {
        CODE2MESSAGE = MapUtil.asMap(new Object[][]{{RESULT_OK.value(), "Success."}, {RESULT_CANCELED.value(), "Transfer canceled by the user."}, {RESULT_UNKNOWN_ERROR.value(), "Unknown Error."}, {RESULT_CONNECTION_ERROR.value(), "sdb Connection Error."}, {RESULT_NO_REMOTE_OBJECT.value(), "Remote object doesn't exist!"}, {RESULT_TARGET_IS_FILE.value(), "Target object is a file."}, {RESULT_NO_DIR_TARGET.value(), "Target directory doesn't exist."}, {RESULT_REMOTE_PATH_ENCODING.value(), "Remote Path encoding is not supported."}, {RESULT_REMOTE_PATH_LENGTH.value(), "Remove path is too long."}, {RESULT_FILE_WRITE_ERROR.value(), "Writing local file failed!"}, {RESULT_FILE_READ_ERROR.value(), "Reading local file failed!"}, {RESULT_NO_LOCAL_FILE.value(), "Local file doesn't exist."}, {RESULT_LOCAL_IS_DIRECTORY.value(), "Local path is a directory."}, {RESULT_REMOTE_IS_FILE.value(), "Remote path is a file."}, {RESULT_BUFFER_OVERRUN.value(), "Receiving too much data."}, {RESULT_CONNECTION_TIMEOUT.value(), "timeout"}, {RESULT_FILE_EXIST.value(), "File exists."}, {RESULT_FAIL_DELETE_FILE.value(), "Fail delete file."}, {RESULT_FAIL_CREATE_FILE.value(), "Fail create file."}, {RESULT_FAIL_GET_FOLDER_SIZE.value(), "Failed to get folder size"}});
    }

    private SyncServiceReturnCode(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    public static String getMessage(int val) {
        return CODE2MESSAGE.get(val);
    }
}

