/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.sdblib.util;

public final class ByteUtil {
    protected ByteUtil() {
    }

    public static void toBytes(int src, byte[] dest, int offset, int length) {
        int i = 0;
        while (i < length) {
            dest[offset + i] = (byte)(src >> 8 * i & 0xFF);
            ++i;
        }
    }

    public static void toBytes(int src, byte[] dest, int offset) {
        ByteUtil.toBytes(src, dest, offset, 4);
    }

    public static long fromBytes(byte[] value, int offset, int length) {
        long result = 0L;
        int i = 0;
        int n = length;
        while (i < n) {
            result |= (long)((value[offset + i] & 0xFF) << 8 * i);
            ++i;
        }
        return result;
    }

    public static int fromBytes(byte[] value, int offset) {
        return (int)ByteUtil.fromBytes(value, offset, 4);
    }
}

