/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.sdblib.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.tizen.sdblib.SmartDevelopmentBridge;
import org.tizen.sdblib.util.LogLevel;
import org.tizen.sdblib.util.Preferences;

public class Log {
    protected static PrintStream out;

    private Log() {
    }

    public static void v(String tag, String message) {
        Log.println(LogLevel.VERBOSE, tag, message);
    }

    public static void d(String tag, String message) {
        Log.println(LogLevel.DEBUG, tag, message);
    }

    public static void i(String tag, String message) {
        Log.println(LogLevel.INFO, tag, message);
    }

    public static void w(String tag, String message) {
        Log.println(LogLevel.WARN, tag, message);
    }

    public static void e(String tag, String message) {
        Log.println(LogLevel.ERROR, tag, message);
    }

    public static void e(String tag, Throwable throwable) {
        if (throwable != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            throwable.printStackTrace(pw);
            Log.println(LogLevel.ERROR, tag, String.valueOf(throwable.getMessage()) + '\n' + sw.toString());
        }
    }

    private static void println(LogLevel logLevel, String tag, String message) {
        if (logLevel.getPriority() >= Preferences.getLogLevel().getPriority()) {
            Log.printLog(logLevel, tag, message);
        }
    }

    public static void printLog(LogLevel logLevel, String tag, String message) {
        SimpleDateFormat formatter;
        if (out == null) {
            try {
                formatter = new SimpleDateFormat("yyyyMMdd_HHmmss");
                String logPath = SmartDevelopmentBridge.getBridge().getSdbLogLocation();
                if (logPath != null) {
                    File logPathFile = new File(logPath);
                    if (!logPathFile.exists() && !logPathFile.mkdirs()) {
                        System.out.println("Failed to make logPathFile");
                    }
                    String fileName = String.valueOf(logPath) + File.separatorChar + "sdblib-" + formatter.format(new Date()) + ".log";
                    File logFile = new File(fileName);
                    try {
                        out = new PrintStream(new FileOutputStream(logFile, true));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        System.out.println("Failed to write in log file:" + fileName);
                    }
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                System.out.println("Failed to make log file");
            }
            if (out == null) {
                out = new PrintStream(new OutputStream(){

                    @Override
                    public void write(int b) {
                    }
                });
            }
        }
        formatter = new SimpleDateFormat("hh:mm:ss");
        String formatted = String.format("%s %c/%s: %s", formatter.format(new Date()), Character.valueOf(logLevel.getLetter()), tag, message);
        out.println(formatted);
    }
}

