/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sign.command;

import java.io.IOException;
import org.apache.commons.lang3.time.StopWatch;
import org.tizen.common.core.command.ExecutionContext;
import org.tizen.common.core.command.Executor;
import org.tizen.common.core.command.Policy;
import org.tizen.common.core.command.file.FileHandlingCommand;
import org.tizen.common.core.command.policy.MessagePolicy;
import org.tizen.common.file.FileHandler;
import org.tizen.common.file.Filter;
import org.tizen.common.sign.exception.CertificationException;
import org.tizen.common.sign.preferences.SigningProfile;
import org.tizen.common.sign.preferences.SigningProfileItem;
import org.tizen.common.sign.signer.TizenIncrementalSigner;
import org.tizen.common.sign.util.SignatureUtility;
import org.tizen.common.util.Assert;

public class SignCommand
extends FileHandlingCommand<Object> {
    protected SigningProfile profile;
    protected boolean bSlice = false;
    protected boolean bRDS;

    public SignCommand(String root, SigningProfile profile) {
        this(root, profile, false);
    }

    public SignCommand(String root, SigningProfile profile, boolean bRDS) {
        this.path = root;
        this.profile = profile;
        this.bRDS = bRDS;
        this.bSlice = false;
    }

    public void setSlicingMode(boolean slice) {
        this.bSlice = slice;
    }

    public void run(Executor executor, ExecutionContext context) throws IOException, CertificationException {
        FileHandler handler = context.getFileHandler();
        Assert.notNull((Object)handler);
        if (!handler.is(this.path, FileHandler.Attribute.EXISTS)) {
            MessagePolicy messagePolicy;
            Policy policy = context.getPolicy("nonexist.dir.in.project");
            if (policy != null && (messagePolicy = (MessagePolicy)policy.adapt(MessagePolicy.class)) != null) {
                messagePolicy.print(context.getPrompter(), "{0} doesn't exist", new Object[]{this.path});
            }
            return;
        }
        String appDirPath = (String)handler.get(this.path, FileHandler.Attribute.PATH);
        for (String child : handler.list(appDirPath)) {
            String name;
            Object type = handler.get(child, FileHandler.Attribute.TYPE);
            Object nameObj = handler.get(child, FileHandler.Attribute.NAME);
            if (!FileHandler.Type.FILE.equals(type) || !(nameObj instanceof String) || !SignatureUtility.isSignatureFile(name = (String)nameObj)) continue;
            try {
                handler.removeFile(child);
            }
            catch (IOException iOException) {
                this.logger.warn("Cannot remove a file. Path : {}", (Object)child);
            }
        }
        StopWatch stopWatch = new StopWatch();
        try {
            try {
                stopWatch.start();
                SigningProfileItem authorItem = this.profile.getProfileItem(0);
                SigningProfileItem dist1Item = this.profile.getProfileItem(1);
                if (authorItem != null && dist1Item != null) {
                    TizenIncrementalSigner signer = new TizenIncrementalSigner(this.profile, appDirPath, (Filter)this.filter);
                    if (this.bSlice) {
                        signer.signWithSlicing();
                    } else {
                        signer.sign(this.bRDS);
                    }
                } else {
                    this.logger.error("Profiles is not set. Author : {}, Dist1 : {}", (Object)authorItem, (Object)dist1Item);
                }
            }
            catch (Exception e) {
                context.getPrompter().error(e.getMessage());
                throw new CertificationException("Can't create XML Signature file", e);
            }
        }
        finally {
            this.logger.debug("Elapsed time for sign: {}ms", (Object)stopWatch.getTime());
        }
    }
}

