/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sign.model;

import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.sign.util.SignatureUtility;
import org.tizen.common.util.Assert;

public class DeltaListResource {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String FILENAME = ".delta.lst";
    public static final String DELIMETER = "__DEL__";
    protected IProject project;
    protected IContainer cwd;
    protected File listFile;

    public DeltaListResource(IProject project, IContainer workgingFolder) {
        Assert.notNull((Object)project);
        Assert.notNull((Object)workgingFolder);
        this.project = project;
        this.cwd = workgingFolder;
        this.listFile = this.cwd.getLocation().append(FILENAME).toFile();
    }

    protected boolean checkValidPath(IPath path) {
        Assert.notNull((Object)path);
        String firstSegment = path.segment(0);
        String name = path.lastSegment();
        if (name.startsWith(".")) {
            return false;
        }
        return !SignatureUtility.isSignatureFile(firstSegment);
    }

    public File getListResource() {
        return this.listFile;
    }

    public IContainer getCurrentWorkingFolder() {
        return this.cwd;
    }

    public boolean removeListResource() {
        Assert.notNull((Object)this.listFile);
        this.logger.debug("remove {}", (Object)this.listFile.getAbsolutePath());
        return this.listFile.exists() && this.listFile.isFile() ? this.listFile.delete() : true;
    }
}

