/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sign.preferences;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColorCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.sign.model.Certification;
import org.tizen.common.sign.preferences.ControlListenerImpl;
import org.tizen.common.sign.preferences.FileBrowserCellEditor;
import org.tizen.common.sign.preferences.InputValidator;
import org.tizen.common.sign.preferences.ListViewerContentProvider;
import org.tizen.common.sign.preferences.Messages;
import org.tizen.common.sign.preferences.ProfileCellModifier;
import org.tizen.common.sign.preferences.ProfileItemContentProvider;
import org.tizen.common.sign.preferences.ProfileItemLabelProvider;
import org.tizen.common.sign.preferences.SigningProfile;
import org.tizen.common.sign.preferences.SigningProfileContainer;
import org.tizen.common.sign.preferences.SigningProfileItem;
import org.tizen.common.sign.preferences.UIMessages;
import org.tizen.common.sign.ui.CertGenerationDialog;
import org.tizen.common.sign.ui.ProfileItemDialog;
import org.tizen.common.sign.util.SigningPathUtil;
import org.tizen.common.sign.util.SigningProfileUtil;
import org.tizen.common.ui.dialog.FileDialogUtils;
import org.tizen.common.util.DialogUtil;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.IOUtil;
import org.tizen.common.util.ObjectUtil;
import org.tizen.common.util.StringUtil;
import org.tizen.library.sdkutils.api.impl.SDKUtils;

public class SigningPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static final String PREFERENCE_PAGE_ID = "org.tizen.common.sign.preferences.SigningPreferencePage";
    private static final int GROUP_VINDENT = 5;
    private static final String EXE_PATH = Paths.get(InstallPathConfig.getToolsPath(), "certificate-generator", "KeyCertGeneratorApi.jar").toString();
    private static final String JAVA = SDKUtils.getInstance().getJavaPath();
    private static final String FLAG = "-jar";
    private static final String SUCCESS_CONDITION = "Certificate generated successfully";
    private static final String COUNTRY = "--country";
    private static final String STATE = "--state";
    private static final String CITY = "--city";
    private static final String COMMONNAME = "--commonname";
    private static final String ORGANIZATION = "--organization";
    private static final String UNIT = "--unit";
    private static final String EMAIL = "--email";
    private static final String CERTGEN = "--certgen";
    private static final String PASSWORD = "--password";
    private static final String ALIAS = "--alias";
    private static final String KEYSTORE = "--keystore";
    protected TableViewer listViewer;
    protected TableViewer authorTableViewer;
    protected TableViewer distributorTableViewer;
    protected List<Button> profileDependsButtons = new ArrayList<Button>();
    protected List<Button> profilesEnableButton = new ArrayList<Button>();
    protected SigningProfileContainer container;
    protected SigningProfileContainer loadedContainer;

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.container = SigningProfileUtil.getProfileContainerFromFile();
        this.loadedContainer = SigningProfileUtil.getProfileContainerFromFile();
        Composite composite = this.createComposite(parent, 0, (Layout)this.createGridLayout(1), new GridData(1808));
        this.createProfilesControl(composite);
        this.createAuthorControl(composite);
        this.createDistributorControl(composite);
        SigningProfile activeProfile = this.container.getActiveProfile();
        if (activeProfile != null) {
            this.enableButtons(true);
            this.enableTableViewer(true, activeProfile);
        }
        this.validatePreferencePage();
        return parent;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        Button defaultButton = this.getDefaultsButton();
        if (defaultButton != null) {
            defaultButton.setVisible(false);
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.tizen.ide.common.certificate_generator_context");
    }

    protected void contributeButtons(Composite parent) {
        parent.setLayout((Layout)this.createGridLayout(3));
        GridData parentData = new GridData(1808);
        parentData.grabExcessVerticalSpace = false;
        parent.setLayoutData((Object)parentData);
        this.createComposite(parent, 0, (Layout)new GridLayout(2, false), new GridData(768));
    }

    protected void createProfilesControl(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(UIMessages.getString("org.tizen.common.sign.profilegrouptitle"));
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(1808));
        Composite profileListComposite = this.createProfileListViewerControl((Composite)group);
        Composite profileButtonComposite = this.createProfilesButtonControl((Composite)group);
        group.addControlListener((ControlListener)new ControlListenerImpl((Composite)group, profileListComposite, profileButtonComposite));
    }

    protected Composite createProfileListViewerControl(Composite parent) {
        Composite profileListComposite = this.createComposite(parent, 0, (Layout)this.createGridLayout(1, 0, 3), new GridData(1808));
        this.listViewer = new TableViewer(profileListComposite);
        this.listViewer.getTable().setLayoutData((Object)new GridData(1808));
        this.listViewer.setContentProvider((IContentProvider)new ListViewerContentProvider(this.container));
        class ListLabelProvider
        extends LabelProvider
        implements IFontProvider {
            ListLabelProvider() {
            }

            public Font getFont(Object element) {
                if (element instanceof SigningProfile) {
                    SigningProfile profile = (SigningProfile)element;
                    String activeProfileName = SigningPreferencePage.this.container.getActiveProfileName();
                    if (profile.getProfileName().equals(activeProfileName)) {
                        return new Font((Device)Display.getDefault(), SigningPreferencePage.this.boldFont(SigningPreferencePage.this.listViewer.getTable().getFont()));
                    }
                }
                return null;
            }

            public String getText(Object element) {
                if (element instanceof SigningProfile) {
                    String profileName = ((SigningProfile)element).getProfileName();
                    if (profileName.equals(SigningPreferencePage.this.container.getActiveProfileName())) {
                        return String.valueOf(profileName) + " (Active)";
                    }
                    return profileName;
                }
                return null;
            }

            public Image getImage(Object element) {
                return super.getImage(element);
            }
        }
        this.listViewer.setLabelProvider((IBaseLabelProvider)new ListLabelProvider());
        this.listViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SigningProfile selectedProfile = SigningPreferencePage.this.getSelectedProfile(event.getSelection());
                if (selectedProfile != null) {
                    SigningPreferencePage.this.enableButtons(true);
                    SigningPreferencePage.this.enableTableViewer(true, selectedProfile);
                    SigningPreferencePage.this.validatePreferencePage();
                }
            }
        });
        String activeProfileName = SigningProfileUtil.getActiveProfileName();
        SigningProfile activeProfile = this.container.getProfileByName(activeProfileName);
        this.container.setActiveProfile(activeProfile);
        this.loadedContainer.setActiveProfile(activeProfile);
        this.listViewer.setInput((Object)"profile");
        if (activeProfile != null) {
            this.listViewer.setSelection((ISelection)new StructuredSelection((Object)activeProfile));
        }
        return profileListComposite;
    }

    protected void syncEnableButtons() {
        for (Button button : this.profileDependsButtons) {
            if (button == null || "Generate".equals(button.getText())) continue;
            this.enableButtons(button.getEnabled());
            return;
        }
    }

    protected void enableButtons(boolean isEnable) {
        for (Button button : this.profileDependsButtons) {
            if (button == null) continue;
            button.setEnabled(isEnable);
        }
    }

    protected void enableTableViewer(boolean isEnable, SigningProfile profile) {
        if (this.authorTableViewer != null) {
            this.authorTableViewer.getTable().setEnabled(isEnable);
            if (isEnable && profile != null) {
                SigningProfileItem item = profile.getAuthorProfileItem();
                if (item == null) {
                    item = profile.createEmptyProfileItem(0);
                }
                this.authorTableViewer.setInput((Object)new SigningProfileItem[]{item});
            } else {
                this.authorTableViewer.setInput(null);
            }
            this.authorTableViewer.refresh(true);
        }
        if (this.distributorTableViewer != null) {
            this.distributorTableViewer.getTable().setEnabled(isEnable);
            if (isEnable && profile != null) {
                List<SigningProfileItem> items = profile.getDistributorProfileItems();
                int i = 0;
                int length = items.size();
                while (i < length) {
                    if (items.get(i) == null) {
                        items.set(i, profile.createEmptyProfileItem(i + 1));
                    }
                    ++i;
                }
                this.distributorTableViewer.setInput((Object)items.toArray(new SigningProfileItem[0]));
            } else {
                this.distributorTableViewer.setInput(null);
            }
            this.distributorTableViewer.refresh(true);
        }
    }

    protected Composite createProfilesButtonControl(Composite parent) {
        GridData data = new GridData();
        data.verticalAlignment = 128;
        Composite profileButtonComposite = this.createComposite(parent, 0, (Layout)this.createGridLayout(1, 0, 3), data);
        Button addProfileButton = new Button(profileButtonComposite, 0);
        addProfileButton.setText(Messages.PROFILES_ADD_BTN);
        addProfileButton.setLayoutData((Object)new GridData(1808));
        addProfileButton.setToolTipText(Messages.PROFILES_ADD_TOOLTIP);
        addProfileButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                InputValidator validator = new InputValidator(SigningPreferencePage.this.container);
                InputDialog dialog = new InputDialog(Display.getDefault().getActiveShell(), UIMessages.getString("org.tizen.common.sign.profilename"), UIMessages.getString("org.tizen.common.sign.entername"), "", (IInputValidator)validator);
                dialog.open();
                if (dialog.getReturnCode() == 0) {
                    String profileName = dialog.getValue().trim();
                    SigningProfile profile = new SigningProfile(profileName);
                    profile.createEmptyProfileItem(0);
                    profile.createProfileItemForDeveloper();
                    profile.createEmptyProfileItem(2);
                    if (SigningPreferencePage.this.container.getActiveProfile() == null && SigningPreferencePage.this.container.getProfiles().isEmpty()) {
                        SigningPreferencePage.this.container.setActiveProfile(profile);
                    } else {
                        SigningPreferencePage.this.container.addProfile(profile);
                    }
                    SigningPreferencePage.this.listViewer.add((Object)profile);
                    SigningPreferencePage.this.listViewer.setSelection((ISelection)new StructuredSelection((Object)profile));
                    SigningPreferencePage.this.validatePreferencePage();
                    for (Button button : SigningPreferencePage.this.profilesEnableButton) {
                        button.setEnabled(true);
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button modifyProfilesButton = new Button(profileButtonComposite, 0);
        modifyProfilesButton.setText(UIMessages.getString("org.tizen.common.sign.profile.modify"));
        modifyProfilesButton.setLayoutData((Object)new GridData(1808));
        modifyProfilesButton.setToolTipText(UIMessages.getString("org.tizen.common.sign.modifytooltip"));
        modifyProfilesButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SigningProfile selectedProfile = SigningPreferencePage.this.getSelectedProfile(SigningPreferencePage.this.listViewer.getSelection());
                if (selectedProfile != null) {
                    String profileName = selectedProfile.getProfileName();
                    InputValidator validator = new InputValidator(SigningPreferencePage.this.container, profileName);
                    InputDialog dialog = new InputDialog(Display.getDefault().getActiveShell(), UIMessages.getString("org.tizen.common.sign.profilename"), UIMessages.getString("org.tizen.common.sign.entername"), profileName, (IInputValidator)validator);
                    dialog.open();
                    if (dialog.getReturnCode() == 0) {
                        SigningPreferencePage.this.container.renameProfile(profileName, dialog.getValue().trim());
                        SigningPreferencePage.this.listViewer.update((Object)selectedProfile, null);
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.profilesEnableButton.add(modifyProfilesButton);
        Button defaultProfileButton = new Button(profileButtonComposite, 0);
        defaultProfileButton.setText(Messages.PROFILES_SETACTIVE_BTN);
        defaultProfileButton.setLayoutData((Object)new GridData(1808));
        defaultProfileButton.setToolTipText(Messages.PROFILES_SETACTIVE_TOOLTIP);
        defaultProfileButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SigningProfile selectedProfile = SigningPreferencePage.this.getSelectedProfile(SigningPreferencePage.this.listViewer.getSelection());
                if (selectedProfile != null) {
                    SigningPreferencePage.this.container.setActiveProfile(selectedProfile);
                    SigningPreferencePage.this.listViewer.refresh(true);
                    SigningPreferencePage.this.validatePreferencePage();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.profilesEnableButton.add(defaultProfileButton);
        Button removeProfileButton = new Button(profileButtonComposite, 0);
        removeProfileButton.setText(Messages.PROFILES_REMOVE_BTN);
        removeProfileButton.setLayoutData((Object)new GridData(1808));
        removeProfileButton.setToolTipText(Messages.PROFILES_REMOVE_TOOLTIP);
        removeProfileButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SigningProfile selectedProfile = SigningPreferencePage.this.getSelectedProfile(SigningPreferencePage.this.listViewer.getSelection());
                if (selectedProfile != null) {
                    SigningPreferencePage.this.container.removeProfile(selectedProfile);
                    SigningPreferencePage.this.enableButtons(false);
                    SigningPreferencePage.this.enableTableViewer(false, selectedProfile);
                    SigningProfile firstProfile = SigningPreferencePage.this.container.getFirstProfile();
                    if (firstProfile != null) {
                        SigningPreferencePage.this.container.setActiveProfile(firstProfile);
                        SigningPreferencePage.this.listViewer.setSelection((ISelection)new StructuredSelection((Object)firstProfile));
                    }
                    SigningPreferencePage.this.listViewer.remove((Object)selectedProfile);
                    SigningPreferencePage.this.listViewer.refresh(true);
                    SigningPreferencePage.this.validatePreferencePage();
                    if (SigningPreferencePage.this.container.getProfiles().isEmpty()) {
                        for (Button button : SigningPreferencePage.this.profilesEnableButton) {
                            button.setEnabled(false);
                        }
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.profilesEnableButton.add(removeProfileButton);
        boolean enableRelatedButton = !this.container.getProfiles().isEmpty();
        for (Button button : this.profilesEnableButton) {
            button.setEnabled(enableRelatedButton);
        }
        return profileButtonComposite;
    }

    protected void createAuthorControl(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(UIMessages.getString("org.tizen.common.sign.authorsigtitle"));
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(1808));
        Composite authorComposite = this.createAuthorTableViewerControl((Composite)group);
        Composite authorButtonComposite = this.createAuthorButtonControl((Composite)group);
        group.addControlListener((ControlListener)new ControlListenerImpl((Composite)group, authorComposite, authorButtonComposite));
    }

    protected void createDistributorControl(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(UIMessages.getString("org.tizen.common.sign.distrisigtitle"));
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(1808));
        Composite distributorComposite = this.createDistributorTableViewerControl((Composite)group);
        Composite distributorButtonComposite = this.createDistributorButtonControl((Composite)group);
        Composite note = this.addNote((Composite)group, "The second distributor is optional and is used only for special purposes", null);
        GridData data = (GridData)note.getLayoutData();
        data.horizontalSpan = 2;
        group.addControlListener((ControlListener)new ControlListenerImpl((Composite)group, distributorComposite, distributorButtonComposite));
    }

    protected Composite createAuthorTableViewerControl(Composite parent) {
        final Composite authorComposite = this.createComposite(parent, 0, (Layout)this.createGridLayout(1, 0, 3), new GridData(1808));
        final Table table = new Table(authorComposite, 67584);
        table.setLayout((Layout)new GridLayout());
        GridData tableData = new GridData(768);
        tableData.grabExcessVerticalSpace = false;
        table.setLayoutData((Object)tableData);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        final TableColumn column0 = this.createTableColumn(table, 0, 0, Messages.PROFILES_COLUMN1);
        final TableColumn column1 = this.createTableColumn(table, 0, 1, Messages.PROFILES_COLUMN2);
        CellEditor[] editors = new CellEditor[]{new FileBrowserCellEditor((Composite)table), new PasswordTextCellEditor((Composite)table)};
        this.authorTableViewer = new TableViewer(table);
        this.authorTableViewer.setColumnProperties(new String[]{"key", "password"});
        this.authorTableViewer.setCellEditors(editors);
        this.authorTableViewer.setCellModifier((ICellModifier)new ProfileCellModifier(this.authorTableViewer, this));
        this.authorTableViewer.setContentProvider((IContentProvider)new ProfileItemContentProvider());
        this.authorTableViewer.setLabelProvider((IBaseLabelProvider)new ProfileItemLabelProvider());
        this.authorTableViewer.getTable().setEnabled(false);
        this.authorTableViewer.add((Object)new SigningProfileItem());
        authorComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle area = authorComposite.getClientArea();
                Point size = table.computeSize(-1, -1);
                int width = area.width - 15;
                if (size.y > area.height + table.getHeaderHeight()) {
                    width -= 15;
                }
                Point oldSize = table.getSize();
                if (oldSize.x > area.width) {
                    column0.setWidth((int)((double)width * 0.75));
                    column1.setWidth(width - column0.getWidth());
                    table.setSize(area.width, area.height);
                } else {
                    table.setSize(area.width, area.height);
                    column0.setWidth((int)((double)width * 0.75));
                    column1.setWidth(width - column0.getWidth());
                }
            }
        });
        return authorComposite;
    }

    protected Composite createAuthorButtonControl(Composite parent) {
        GridData data = new GridData();
        data.verticalAlignment = 128;
        Composite authorButtonComposite = this.createComposite(parent, 0, (Layout)this.createGridLayout(1, 0, 3), data);
        Button genButton = new Button(authorButtonComposite, 0);
        genButton.setText("Generate");
        genButton.setLayoutData((Object)new GridData(768));
        genButton.setEnabled(false);
        genButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SigningPreferencePage.this.generateCertificate();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.profileDependsButtons.add(genButton);
        Button editButton = new Button(authorButtonComposite, 0);
        editButton.setText("Edit");
        editButton.setLayoutData((Object)new GridData(768));
        editButton.setEnabled(false);
        editButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SigningProfile profile = SigningPreferencePage.this.getSelectedProfile(SigningPreferencePage.this.listViewer.getSelection());
                if (profile == null) {
                    return;
                }
                SigningProfileItem item = profile.getAuthorProfileItem();
                ProfileItemDialog dialog = new ProfileItemDialog(Display.getDefault().getActiveShell(), item);
                int result = dialog.open();
                if (result == 0) {
                    item.setKeyLocation(dialog.getKeyPath());
                    item.setPassword(dialog.getPassword());
                    item.setCAPath(dialog.getCaPath());
                    item.setRootCAPath(dialog.getRootPath());
                    SigningPreferencePage.this.enableTableViewer(true, profile);
                    SigningPreferencePage.this.validatePreferencePage();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.profileDependsButtons.add(editButton);
        return authorButtonComposite;
    }

    protected Composite createDistributorTableViewerControl(Composite parent) {
        final Composite distributorComposite = this.createComposite(parent, 0, (Layout)this.createGridLayout(1, 0, 3), new GridData(1808));
        final Table table = new Table(distributorComposite, 67584);
        table.setLayout((Layout)new GridLayout());
        table.setLayoutData((Object)new GridData(768));
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        final TableColumn columnNum = this.createTableColumn(table, 0, 0, "No.");
        final TableColumn column0 = this.createTableColumn(table, 0, 1, Messages.PROFILES_COLUMN1);
        final TableColumn column1 = this.createTableColumn(table, 0, 2, Messages.PROFILES_COLUMN2);
        final TableColumn column2 = this.createTableColumn(table, 0, 3, Messages.PROFILES_COLUMN3);
        final TableColumn column3 = this.createTableColumn(table, 0, 4, Messages.PROFILES_COLUMN4);
        CellEditor[] editors = new CellEditor[]{new ColorCellEditor((Composite)table), new FileBrowserCellEditor((Composite)table), new PasswordTextCellEditor((Composite)table), new FileBrowserCellEditor((Composite)table){

            @Override
            protected String[] getDialogFilter() {
                return new String[]{"*.cer"};
            }
        }, new FileBrowserCellEditor((Composite)table){

            @Override
            protected String[] getDialogFilter() {
                return new String[]{"*.cer"};
            }
        }};
        this.distributorTableViewer = new TableViewer(table);
        this.distributorTableViewer.setColumnProperties(new String[]{"distributor", "key", "password", "ca", "rootca"});
        this.distributorTableViewer.setCellEditors(editors);
        this.distributorTableViewer.setCellModifier((ICellModifier)new ProfileCellModifier(this.distributorTableViewer, this));
        this.distributorTableViewer.setContentProvider((IContentProvider)new ProfileItemContentProvider());
        this.distributorTableViewer.setLabelProvider((IBaseLabelProvider)new ProfileItemLabelProvider(){

            @Override
            public String getColumnText(Object element, int columnIndex) {
                if (columnIndex == 0) {
                    Object e;
                    int i = 0;
                    while ((e = SigningPreferencePage.this.distributorTableViewer.getElementAt(i++)) != null) {
                        if (e != element) continue;
                        return Integer.toString(i);
                    }
                }
                return super.getColumnText(element, columnIndex - 1);
            }
        });
        this.distributorTableViewer.getTable().setEnabled(false);
        this.distributorTableViewer.add((Object)new SigningProfileItem());
        this.distributorTableViewer.add((Object)new SigningProfileItem());
        distributorComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle area = distributorComposite.getClientArea();
                Point size = table.computeSize(-1, -1);
                ScrollBar vBar = table.getVerticalBar();
                int width = area.width - vBar.getSize().x;
                if (size.y > area.height + table.getHeaderHeight()) {
                    Point vBarSize = vBar.getSize();
                    width -= vBarSize.x;
                }
                Point oldSize = table.getSize();
                int locWidth = (int)((double)width * 0.25);
                int numWidth = (int)((double)width * 0.07);
                int passWidth = width - locWidth * 3 - numWidth;
                if (oldSize.x > area.width) {
                    columnNum.setWidth(numWidth);
                    column0.setWidth(locWidth);
                    column1.setWidth(passWidth);
                    column2.setWidth(locWidth);
                    column3.setWidth(locWidth);
                    table.setSize(area.width, area.height);
                } else {
                    table.setSize(area.width, area.height);
                    columnNum.setWidth(numWidth);
                    column0.setWidth(locWidth);
                    column1.setWidth(passWidth);
                    column2.setWidth(locWidth);
                    column3.setWidth(locWidth);
                }
            }
        });
        return distributorComposite;
    }

    protected Composite createDistributorButtonControl(Composite parent) {
        GridData data = new GridData();
        data.verticalAlignment = 128;
        Composite distributorButtonComposite = this.createComposite(parent, 0, (Layout)this.createGridLayout(1, 0, 3), data);
        Button dist1EditButton = new Button(distributorButtonComposite, 0);
        dist1EditButton.setText("Edit");
        dist1EditButton.setLayoutData((Object)new GridData(768));
        dist1EditButton.setEnabled(false);
        dist1EditButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SigningProfileItem item;
                ProfileItemDialog itemDialog;
                int result;
                Shell activeShell = Display.getDefault().getActiveShell();
                SigningProfileItem selectedItem = SigningPreferencePage.this.getSelectedProfileItem(SigningPreferencePage.this.distributorTableViewer.getSelection());
                if (selectedItem == null) {
                    MessageDialog.openError((Shell)activeShell, (String)"Certificate editor error", (String)"Not selected a distributor item for modification");
                    return;
                }
                SigningProfile profile = SigningPreferencePage.this.getSelectedProfile(SigningPreferencePage.this.listViewer.getSelection());
                if (profile != null && (result = (itemDialog = new ProfileItemDialog(activeShell, item = profile.getProfileItem(profile.getOrdinal(selectedItem)))).open()) == 0) {
                    item.setKeyLocation(itemDialog.getKeyPath());
                    item.setPassword(itemDialog.getPassword());
                    item.setCAPath(itemDialog.getCaPath());
                    item.setRootCAPath(itemDialog.getRootPath());
                    SigningPreferencePage.this.enableTableViewer(true, profile);
                    SigningPreferencePage.this.validatePreferencePage();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.profileDependsButtons.add(dist1EditButton);
        return distributorButtonComposite;
    }

    protected Composite createNoteComposite(Font font, Composite composite, String title, String message, SelectionListener listener) {
        Composite messageComposite = new Composite(composite, 0);
        GridLayout messageLayout = new GridLayout();
        messageLayout.numColumns = 2;
        messageLayout.marginWidth = 0;
        messageLayout.marginHeight = 0;
        messageComposite.setLayout((Layout)messageLayout);
        messageComposite.setLayoutData((Object)new GridData(256));
        messageComposite.setFont(font);
        Label noteLabel = new Label(messageComposite, 1);
        noteLabel.setText(title);
        noteLabel.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
        noteLabel.setLayoutData((Object)new GridData(2));
        Link messageLabel = new Link(messageComposite, 64);
        messageLabel.setText(message);
        messageLabel.setFont(font);
        if (listener != null) {
            messageLabel.addSelectionListener(listener);
        }
        return messageComposite;
    }

    private Composite addNote(Composite parent, String noteMessage, SelectionListener listener) {
        Composite noteControl = this.createNoteComposite(JFaceResources.getDialogFont(), parent, "Note:", noteMessage, listener);
        GridData gd = new GridData(256);
        gd.verticalIndent = 5;
        noteControl.setLayoutData((Object)gd);
        return noteControl;
    }

    protected void performDefaults() {
    }

    private void checkFile(String filePath, String validExtension) {
        if (filePath != null && filePath.trim().length() > 0) {
            File file = new File(filePath);
            boolean isValid = true;
            if (!file.exists() || !file.isFile()) {
                isValid = false;
            } else {
                String fileExtension = FileUtil.getFileExtension((String)filePath);
                isValid = validExtension.equalsIgnoreCase(fileExtension);
            }
            if (!isValid) {
                this.setValid(false);
                this.setErrorMessage(String.valueOf(filePath) + ": " + UIMessages.getString("org.tizen.common.sign.entervalidp12"));
            }
        }
    }

    protected void validatePreferencePage() {
        this.setValid(true);
        this.setMessage(null);
        this.setErrorMessage(null);
        SigningProfile activeProfile = this.container.getActiveProfile();
        if (activeProfile == null) {
            this.setMessage("Set an active profile", 2);
        } else {
            for (SigningProfileItem item : activeProfile.getProfileItems()) {
                if (item == null) continue;
                String keyLocation = item.getKeyLocation();
                this.checkFile(keyLocation, Certification.KeyExtension.p12.name());
                if (StringUtil.isEmpty((CharSequence)keyLocation)) continue;
                this.checkFile(item.getCAPath(), "cer");
                this.checkFile(item.getRootCAPath(), "cer");
            }
        }
    }

    public void init(IWorkbench workbench) {
    }

    public FontData[] boldFont(Font font) {
        FontData[] datas;
        FontData[] fontDataArray = datas = font.getFontData();
        int n = datas.length;
        int n2 = 0;
        while (n2 < n) {
            FontData data = fontDataArray[n2];
            data.setStyle(1);
            ++n2;
        }
        return datas;
    }

    public FontData[] smallFont(Font font) {
        FontData[] datas;
        FontData[] fontDataArray = datas = font.getFontData();
        int n = datas.length;
        int n2 = 0;
        while (n2 < n) {
            FontData data = fontDataArray[n2];
            data.setHeight(data.getHeight() - 1);
            ++n2;
        }
        return datas;
    }

    public boolean performOk() {
        boolean bChanged;
        boolean bActiveChanged = false;
        String newProfileName = this.container.getActiveProfileName();
        if (!StringUtil.isEmpty((CharSequence)newProfileName) && !newProfileName.equals(this.loadedContainer.getActiveProfileName())) {
            bActiveChanged = true;
        }
        ByteArrayOutputStream containerOs = new ByteArrayOutputStream();
        this.container.writeProfileXML(containerOs);
        ByteArrayOutputStream loadedContainerOs = new ByteArrayOutputStream();
        this.loadedContainer.writeProfileXML(loadedContainerOs);
        boolean bl = bChanged = !Arrays.equals(containerOs.toByteArray(), loadedContainerOs.toByteArray());
        if (bActiveChanged || bChanged) {
            SigningProfileUtil.setActiveProfileName(newProfileName);
            SigningProfileUtil.writeProfilesToFile(this.container);
            this.logger.trace("Security preferences was saved");
            if (!this.loadedContainer.getProfiles().isEmpty()) {
                DialogUtil.openMessageDialog((Shell)this.getShell(), (String)UIMessages.getString("org.tizen.common.sign.requiredclean"));
            }
            this.loadedContainer.readProfileXML(new ByteArrayInputStream(containerOs.toByteArray()));
            SigningProfile profile = null;
            if (newProfileName != null) {
                profile = this.loadedContainer.getProfileByName(newProfileName);
            }
            this.loadedContainer.setActiveProfile(profile);
        }
        return super.performOk();
    }

    private boolean checkValid(String attr) {
        return attr != null && !attr.trim().isEmpty();
    }

    private ArrayList<String> makeCommandLineArgs(String countryName, String stateName, String cityName, String commonName, String organizationName, String orgUnitName, String emailId, String certGenDirPath, String password, String alias, String pkcsKeyStorePath) {
        ArrayList<String> cmdArgs = new ArrayList<String>();
        cmdArgs.add(JAVA);
        cmdArgs.add(FLAG);
        cmdArgs.add(EXE_PATH);
        if (this.checkValid(countryName)) {
            cmdArgs.add(COUNTRY);
            cmdArgs.add(countryName.trim());
        }
        if (this.checkValid(stateName)) {
            cmdArgs.add(STATE);
            cmdArgs.add(stateName.trim());
        }
        if (this.checkValid(cityName)) {
            cmdArgs.add(CITY);
            cmdArgs.add(cityName.trim());
        }
        if (this.checkValid(commonName)) {
            cmdArgs.add(COMMONNAME);
            cmdArgs.add(commonName.trim());
        }
        if (this.checkValid(organizationName)) {
            cmdArgs.add(ORGANIZATION);
            cmdArgs.add(organizationName.trim());
        }
        if (this.checkValid(orgUnitName)) {
            cmdArgs.add(UNIT);
            cmdArgs.add(orgUnitName.trim());
        }
        if (this.checkValid(emailId)) {
            cmdArgs.add(EMAIL);
            cmdArgs.add(emailId.trim());
        }
        if (this.checkValid(certGenDirPath)) {
            cmdArgs.add(CERTGEN);
            cmdArgs.add(certGenDirPath.trim());
        }
        if (this.checkValid(password)) {
            cmdArgs.add(PASSWORD);
            cmdArgs.add(password.trim());
        }
        if (this.checkValid(alias)) {
            cmdArgs.add(ALIAS);
            cmdArgs.add(alias.trim());
        }
        if (this.checkValid(pkcsKeyStorePath)) {
            cmdArgs.add(KEYSTORE);
            cmdArgs.add(pkcsKeyStorePath.trim());
        }
        return cmdArgs;
    }

    private boolean generateSignedCertificate(String countryName, String stateName, String cityName, String commonName, String organizationName, String orgUnitName, String emailId, String certGenDirPath, String password, String alias, String pkcsKeyStorePath) throws Exception {
        ArrayList<String> command = this.makeCommandLineArgs(countryName, stateName, cityName, commonName, organizationName, orgUnitName, emailId, certGenDirPath, password, alias, pkcsKeyStorePath);
        String line = null;
        InputStream inputStream = null;
        BufferedReader bufferedReader = null;
        try {
            try {
                ProcessBuilder builder = new ProcessBuilder(command);
                Process process = builder.start();
                inputStream = process.getInputStream();
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                line = bufferedReader.readLine();
            }
            catch (IOException ioe) {
                this.logger.error(Messages.EXCEPTION_DURING_GENERATION_OF_P12, (Throwable)ioe);
                throw ioe;
            }
        }
        catch (Throwable throwable) {
            IOUtil.tryClose((Object[])new Object[]{bufferedReader});
            throw throwable;
        }
        IOUtil.tryClose((Object[])new Object[]{bufferedReader});
        return line != null && line.startsWith(SUCCESS_CONDITION);
    }

    protected void generateCertificate() {
        int ret;
        Shell activeShell = Display.getDefault().getActiveShell();
        final CertGenerationDialog dialog = new CertGenerationDialog(activeShell);
        int result = dialog.open();
        if (result != 0) {
            return;
        }
        IPath certPath = SigningProfileUtil.getAuthorCertStorePath().append(dialog.getValue(CertGenerationDialog.CertDataKey.KeyName));
        if (StringUtil.isEmpty((CharSequence)certPath.getFileExtension())) {
            certPath = certPath.addFileExtension("p12");
        }
        this.logger.debug("generate a certificate to {}", (Object)certPath);
        final String pkcsKeyStorePath = certPath.toPortableString();
        if (FileUtil.isExist((String)pkcsKeyStorePath) && (ret = FileDialogUtils.allowFileOverwrite((String)pkcsKeyStorePath)) == 1) {
            return;
        }
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                block7: {
                    if ((monitor = (IProgressMonitor)ObjectUtil.nvl((Object[])new IProgressMonitor[]{monitor, new NullProgressMonitor()})) != null) {
                        monitor.beginTask("generate a certificate", -1);
                        try {
                            try {
                                if (!SigningPreferencePage.this.generateSignedCertificate(dialog.getValue(CertGenerationDialog.CertDataKey.Country), dialog.getValue(CertGenerationDialog.CertDataKey.State), dialog.getValue(CertGenerationDialog.CertDataKey.City), dialog.getValue(CertGenerationDialog.CertDataKey.Name), dialog.getValue(CertGenerationDialog.CertDataKey.Organization), dialog.getValue(CertGenerationDialog.CertDataKey.Department), dialog.getValue(CertGenerationDialog.CertDataKey.Email), SigningPathUtil.getCertificateGeneratorPath(), dialog.getValue(CertGenerationDialog.CertDataKey.Password), dialog.getValue(CertGenerationDialog.CertDataKey.Alias), pkcsKeyStorePath)) {
                                    SigningPreferencePage.this.logger.error(Messages.FAILED_TO_CREATE_AUTHOR_CERTIFICATE);
                                    throw new Exception(Messages.FAILED_TO_CREATE_AUTHOR_CERTIFICATE);
                                }
                                break block7;
                            }
                            catch (Exception e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                        finally {
                            monitor.done();
                        }
                    }
                    SigningPreferencePage.this.logger.error("Failed to create Progress Monitor");
                }
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(runnable);
        }
        catch (InvocationTargetException e) {
            this.logger.error(e.getMessage(), e.getCause());
            ErrorDialog.openError((Shell)activeShell, (String)"Certificate generation error", (String)"Failed to generate a certificate.", (IStatus)new Status(4, "org.tizen.common.sign", e.getMessage(), e.getCause()));
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        String absolutePath = certPath.toFile().getAbsolutePath();
        String successMsg = "The certificate was generated to '" + absolutePath + "'.\n" + "Do you want to fill the author certificate information automatically?";
        boolean bAutoFill = MessageDialog.openQuestion((Shell)activeShell, (String)"Generate", (String)successMsg);
        if (bAutoFill) {
            SigningProfile profile = this.getSelectedProfile(this.listViewer.getSelection());
            if (profile != null) {
                SigningProfileItem item = profile.getAuthorProfileItem();
                item.setKeyLocation(absolutePath);
                item.setPassword(dialog.getValue(CertGenerationDialog.CertDataKey.Password).toCharArray());
            }
            this.enableTableViewer(true, profile);
            this.validatePreferencePage();
        }
    }

    private GridLayout createGridLayout(int numColumns) {
        return this.createGridLayout(numColumns, 0, 0);
    }

    private GridLayout createGridLayout(int numColumns, int marginHeight, int marginWidth) {
        GridLayout layout = new GridLayout(numColumns, false);
        layout.marginHeight = marginHeight;
        layout.marginWidth = marginWidth;
        return layout;
    }

    private Composite createComposite(Composite parent, int style, Layout layout, Object layoutData) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout(layout);
        composite.setLayoutData(layoutData);
        return composite;
    }

    private TableColumn createTableColumn(Table parent, int style, int index, String text) {
        TableColumn column = new TableColumn(parent, style, index);
        column.setText(text);
        column.pack();
        return column;
    }

    private SigningProfile getSelectedProfile(ISelection selection) {
        Object firstElement;
        if (selection instanceof IStructuredSelection && (firstElement = ((StructuredSelection)selection).getFirstElement()) instanceof SigningProfile) {
            return (SigningProfile)firstElement;
        }
        return null;
    }

    private SigningProfileItem getSelectedProfileItem(ISelection selection) {
        Object firstElement;
        if (selection instanceof IStructuredSelection && (firstElement = ((StructuredSelection)selection).getFirstElement()) instanceof SigningProfileItem) {
            return (SigningProfileItem)firstElement;
        }
        return null;
    }

    public static class PasswordTextCellEditor
    extends TextCellEditor {
        public PasswordTextCellEditor(Composite composite) {
            super(composite);
        }

        protected void doSetValue(Object value) {
            super.doSetValue((Object)(value instanceof char[] ? new String((char[])value) : ""));
        }

        public int getStyle() {
            return super.getStyle() | 0x400000;
        }
    }
}

