/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sign.preferences;

import java.io.IOException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.Factory;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.sign.Activator;
import org.tizen.common.sign.preferences.SigningProfileItem;

public class SigningProfileItemFactory
implements Factory<SigningProfileItem> {
    private static final Logger logger = LoggerFactory.getLogger(SigningProfileItemFactory.class);
    protected static final String DEVELOPER_KEY_PASSWORD = "tizenpkcs12passfordsigner";

    public Activator getActivator() {
        return Activator.getDefault();
    }

    protected String getDeveloperKeyPath() throws IOException {
        IPath sdkpath = new Path(InstallPathConfig.getSDKPath()).append("tools").append("certificate-generator").append("certificates").append("distributor").append("tizen-distributor-signer.p12");
        return sdkpath.toOSString();
    }

    public SigningProfileItem create() {
        SigningProfileItem profileItem = new SigningProfileItem();
        try {
            profileItem.setKeyLocation(this.getDeveloperKeyPath());
            profileItem.setPassword(DEVELOPER_KEY_PASSWORD.toCharArray());
        }
        catch (IOException e) {
            logger.error("Failed to set profileItem", (Throwable)e);
        }
        profileItem.setIdentifier("");
        profileItem.setAuthor(false);
        profileItem.setCAPath("");
        profileItem.setRootCAPath("");
        return profileItem;
    }
}

