/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sign.signer;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.CommonPlugin;
import org.tizen.common.TizenPlatformConstants;
import org.tizen.common.core.command.Command;
import org.tizen.common.core.command.Executor;
import org.tizen.common.file.FileHandler;
import org.tizen.common.file.StandardFileHandler;
import org.tizen.common.sign.command.SignCommand;
import org.tizen.common.sign.preferences.SigningProfile;
import org.tizen.common.sign.preferences.SigningProfileContainer;
import org.tizen.common.sign.signer.ReferenceCacheParser;
import org.tizen.common.sign.signer.TizenIncrementalSigner;
import org.tizen.common.sign.util.SigningProfileUtil;
import org.tizen.common.util.IOUtil;

public class SignatureGenerator {
    protected static final Logger logger = LoggerFactory.getLogger(SignatureGenerator.class);
    protected Executor executor = CommonPlugin.getDefault().getExecutor();
    protected IPreferenceStore pStore = SigningProfileUtil.getPreferenceStore();
    protected boolean bRDS = false;

    protected boolean getInsertSignatureOption() {
        return TizenPlatformConstants.SIGNING_DEFAULT;
    }

    protected String getActiveProfileName() {
        return this.pStore.getString("defaultprofile");
    }

    public void sign(String path, SigningProfile profile) {
        logger.trace("sign (path: {}, RDS: {})", (Object)path, (Object)this.isRDSMode());
        SignCommand command = new SignCommand(path, profile, this.isRDSMode());
        command.setExcludes(new String[]{".*", "*~"});
        this.executor.execute(this.executor.getContext(), new Command[]{command});
    }

    public void setRDSMode(boolean bRDS) {
        this.bRDS = bRDS;
    }

    public boolean isRDSMode() {
        return this.bRDS;
    }

    public static void generate(String dir, String signedDir, String profilesPath, String profileName) throws IOException, UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException, CertificateException, ParserConfigurationException, XMLSecurityException {
        FileInputStream is = null;
        try {
            is = new FileInputStream(profilesPath);
            SignatureGenerator.generate(dir, signedDir, is, profileName);
        }
        catch (Throwable throwable) {
            IOUtil.tryClose((Object[])new Object[]{is});
            throw throwable;
        }
        IOUtil.tryClose((Object[])new Object[]{is});
    }

    public static void generate(String dir, String signedDir, InputStream profilesIs, String profileName) throws IOException, UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException, CertificateException, ParserConfigurationException, XMLSecurityException {
        SigningProfile profile = SignatureGenerator.loadProfile(profilesIs, profileName);
        TizenIncrementalSigner signer = new TizenIncrementalSigner(profile, dir);
        signer.setReferenceCacheParser(new ReferenceCacheParser((FileHandler)new StandardFileHandler(signedDir)));
        signer.sign(false);
    }

    public static void generateBySlicing(String dir, String signedDir, String profilesPath, String profileName) throws IOException, UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException, CertificateException, ParserConfigurationException, XMLSecurityException {
        FileInputStream is = null;
        try {
            is = new FileInputStream(profilesPath);
            SignatureGenerator.generateBySlicing(dir, signedDir, is, profileName);
        }
        catch (Throwable throwable) {
            IOUtil.tryClose((Object[])new Object[]{is});
            throw throwable;
        }
        IOUtil.tryClose((Object[])new Object[]{is});
    }

    public static void generateBySlicing(String dir, String signedDir, InputStream profilesIs, String profileName) throws IOException, UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException, CertificateException, ParserConfigurationException, XMLSecurityException {
        SigningProfile profile = SignatureGenerator.loadProfile(profilesIs, profileName);
        TizenIncrementalSigner signer = new TizenIncrementalSigner(profile, dir);
        signer.setReferenceCacheParser(new ReferenceCacheParser((FileHandler)new StandardFileHandler(signedDir)));
        signer.signWithSlicing();
    }

    public static SigningProfile loadProfile(InputStream profilesIs, String profileName) throws IOException {
        SigningProfileContainer container = new SigningProfileContainer();
        container.readProfileXML(profilesIs);
        SigningProfile profile = container.getProfileByName(profileName);
        if (profile == null) {
            throw new IOException("Not found a specified profile: " + profileName);
        }
        return profile;
    }
}

