/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sign.signer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.security.Init;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.content.X509Data;
import org.apache.xml.security.signature.Manifest;
import org.apache.xml.security.signature.ObjectContainer;
import org.apache.xml.security.signature.Reference;
import org.apache.xml.security.signature.SignedInfo;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.transforms.TransformationException;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.utils.ElementProxy;
import org.apache.xml.security.utils.XMLUtils;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.appfw.resourcecutter.ResourceCutter;
import org.tizen.common.file.FileHandler;
import org.tizen.common.file.Filter;
import org.tizen.common.file.SimpleFileFilter;
import org.tizen.common.file.StandardFileHandler;
import org.tizen.common.sign.model.AuthorSignatureXml;
import org.tizen.common.sign.model.Delta;
import org.tizen.common.sign.model.DeltaState;
import org.tizen.common.sign.model.FeatureDPI;
import org.tizen.common.sign.model.ISignatureXml;
import org.tizen.common.sign.model.ReferenceCache;
import org.tizen.common.sign.model.ReferenceDelegator;
import org.tizen.common.sign.model.ResolverCustomResource;
import org.tizen.common.sign.preferences.SigningProfile;
import org.tizen.common.sign.preferences.SigningProfileItem;
import org.tizen.common.sign.signer.DeltaListResourceParser;
import org.tizen.common.sign.signer.ReferenceCacheParser;
import org.tizen.common.sign.util.SignatureUtility;
import org.tizen.common.sign.util.XMLUtil;
import org.tizen.common.util.Assert;
import org.tizen.common.util.FilenameUtil;
import org.tizen.common.util.IOUtil;
import org.tizen.common.util.ReflectionUtil;
import org.tizen.common.util.StringUtil;
import org.tizen.common.util.URIEscapeUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TizenIncrementalSigner {
    protected static final Logger logger = LoggerFactory.getLogger(TizenIncrementalSigner.class);
    private static final String REFERENCES_IN_SIGNEDINFO = "references";
    protected static final String PROPERTY_REFERENCE_URI = "#prop";
    protected static final String KEY_TYPE_PKCS12 = "PKCS12";
    protected static final int MAX_CHAIN_CERTIFICATES = 3;
    protected final String[] defaultFilterList = new String[]{".manifest.tmp", ".delta.lst"};
    protected Filter filter = null;
    protected ReferenceCacheParser cacheParser;
    protected DeltaListResourceParser deltaParser;
    protected String rootPath;
    protected SigningProfile certProfile;
    private XMLSignature signature;
    protected Map<String, InputStream> isMap;
    protected Map<String, String> realPathMap;
    protected Map<String, ISignatureXml> authorXmlMap;
    protected ResourceMode mode = ResourceMode.ORIGINAL;

    static {
        Init.init();
        try {
            ElementProxy.setDefaultPrefix((String)"http://www.w3.org/2000/09/xmldsig#", (String)"");
        }
        catch (XMLSecurityException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    public TizenIncrementalSigner(SigningProfile certProfile, String rootPath) {
        this(certProfile, rootPath, null);
    }

    public TizenIncrementalSigner(SigningProfile certProfile, String rootPath, Filter filter) {
        Assert.notNull((Object)rootPath);
        this.certProfile = certProfile;
        this.rootPath = rootPath;
        this.filter = filter;
        this.initialize();
    }

    public Filter getFilter() {
        if (this.filter == null) {
            return new SimpleFileFilter(true);
        }
        return this.filter;
    }

    public void setMode(ResourceMode mode) {
        Assert.notNull((Object)((Object)mode));
        this.mode = mode;
    }

    protected void initialize() {
        StandardFileHandler defaultHandler = new StandardFileHandler();
        defaultHandler.setCurrentWorkingDirectory(new File(this.rootPath).getAbsolutePath());
        this.cacheParser = new ReferenceCacheParser((FileHandler)defaultHandler);
        this.deltaParser = new DeltaListResourceParser((FileHandler)defaultHandler);
    }

    public void setReferenceCacheParser(ReferenceCacheParser cacheParser) {
        Assert.notNull((Object)cacheParser);
        this.cacheParser = cacheParser;
    }

    public void setDeltaListResourceParser(DeltaListResourceParser deltaParser) {
        Assert.notNull((Object)deltaParser);
        this.deltaParser = deltaParser;
    }

    public void signWithSlicing() throws ParserConfigurationException, XMLSecurityException, IOException, UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        logger.debug("Multi-signing for app-slicing.");
        this.authorXmlMap = new HashMap<String, ISignatureXml>();
        ArrayList<ISignatureXml> xmlList = new ArrayList<ISignatureXml>();
        File resFolder = new File(this.rootPath, "res");
        FeatureDPI[] dpis = this.getSupportedDpiTypes(resFolder.getCanonicalPath());
        logger.trace("Sliced signatures will be created: {}", (Object)Arrays.toString((Object[])dpis));
        FeatureDPI[] featureDPIArray = dpis;
        int n = dpis.length;
        int n2 = 0;
        while (n2 < n) {
            FeatureDPI dpi = featureDPIArray[n2];
            ISignatureXml xml = this.slice(this.certProfile.getAuthorProfileItem(), dpi);
            this.authorXmlMap.put(xml.getFilename(), xml);
            xmlList.add(xml);
            ++n2;
        }
        for (SigningProfileItem item : this.certProfile.getProfileItems()) {
            if (item == null || StringUtil.isEmpty((CharSequence)item.getKeyLocation())) continue;
            int ordinal = this.certProfile.getOrdinal(item);
            File xmlFile = this.getXMLFile(item);
            this.sign(item, ordinal, xmlFile, false);
        }
        for (ISignatureXml xml : xmlList) {
            xml.writeToFileIn(this.rootPath);
        }
    }

    private FeatureDPI[] getSupportedDpiTypes(String resFolder) throws IOException {
        try {
            Set types = new ResourceCutter(resFolder).getAvailableDpi();
            FeatureDPI[] dpis = FeatureDPI.convert(types.toArray(new String[0]));
            ArrayList<FeatureDPI> list = new ArrayList<FeatureDPI>();
            list.addAll(Arrays.asList(dpis));
            return list.toArray(new FeatureDPI[0]);
        }
        catch (IllegalArgumentException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new IOException("Failed to divide DPI resources: " + e.getMessage(), e);
        }
        catch (ParserConfigurationException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new IOException("Failed to parse DPI resource information: " + e.getMessage(), e);
        }
    }

    private Set<String> getDpiResourcesInResFolder(String resFolder, FeatureDPI dpi) throws IOException {
        try {
            ResourceCutter cutter = new ResourceCutter(resFolder);
            return cutter.getValidFiles(new String[]{"feature-dpi"}, new String[]{dpi.getDpiType()});
        }
        catch (IllegalArgumentException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new IOException("Failed to divide DPI resources: " + e.getMessage(), e);
        }
        catch (ParserConfigurationException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new IOException("Failed to parse DPI resource information: " + e.getMessage(), e);
        }
    }

    private List<String> getDpiResources(List<String> resources, FeatureDPI dpi) throws IOException {
        if (FeatureDPI.ALL.equals((Object)dpi)) {
            return resources;
        }
        File root = new File(this.rootPath);
        File resFolder = new File(root, "res");
        Set<String> cuttingFiles = this.getDpiResourcesInResFolder(resFolder.getCanonicalPath(), dpi);
        ArrayList<String> selectedResources = new ArrayList<String>();
        for (String resource : resources) {
            File absoluteRes = new File(root, resource);
            String absolutePath = absoluteRes.getPath();
            if (this.isChild(resFolder, absoluteRes) && !cuttingFiles.contains(absolutePath)) continue;
            selectedResources.add(resource);
        }
        return selectedResources;
    }

    private ISignatureXml slice(SigningProfileItem item, FeatureDPI dpi) throws ParserConfigurationException, XMLSecurityException, IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        Document document = XMLUtil.create();
        XMLSignature authorXml = this.createXMLSignature(document, this.rootPath);
        authorXml.addResourceResolver((ResourceResolverSpi)new ResolverCustomResource());
        authorXml.setId("AuthorSignature");
        File root = new File(this.rootPath);
        List<String> resources = this.findResources(root, true);
        List<String> selectedResources = this.getDpiResources(resources, dpi);
        this.addResources(authorXml, selectedResources);
        this.addPropertyElement(authorXml, document, true);
        KeyStore keyStore = TizenIncrementalSigner.loadKeyStore(item.getKeyLocation(), KEY_TYPE_PKCS12, item.getPassword());
        String alias = TizenIncrementalSigner.getFirstAlias(keyStore);
        if (alias == null) {
            throw new KeyStoreException("Couldn't find an alias in the key store.");
        }
        this.addX509CertificateChain(authorXml, item, keyStore, alias);
        Key key = keyStore.getKey(alias, item.getPassword());
        authorXml.sign(key);
        return new AuthorSignatureXml(document, dpi);
    }

    private boolean isChild(File parent, File child) {
        while (child != null) {
            if (child.getPath().equals(parent.getPath())) {
                return true;
            }
            child = child.getParentFile();
        }
        return false;
    }

    public byte[][] sign(boolean bIncremental) throws UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException, CertificateException, XMLSecurityException, ParserConfigurationException, IOException {
        return this.sign(bIncremental, null);
    }

    public byte[][] sign(boolean bIncremental, OutputStream[] oss) throws UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException, CertificateException, XMLSecurityException, ParserConfigurationException, IOException {
        Assert.notNull((Object)this.certProfile);
        this.authorXmlMap = new HashMap<String, ISignatureXml>();
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        int i = 0;
        for (SigningProfileItem item : this.certProfile.getProfileItems()) {
            byte[] signatureValue = null;
            if (item != null && !StringUtil.isEmpty((CharSequence)item.getKeyLocation())) {
                int ordinal = this.certProfile.getOrdinal(item);
                if (oss == null) {
                    File xmlFile = this.getXMLFile(item);
                    signatureValue = this.sign(item, ordinal, xmlFile, bIncremental);
                } else {
                    signatureValue = this.sign(item, ordinal, oss[i], bIncremental);
                }
            }
            result.add(signatureValue);
            ++i;
        }
        return (byte[][])result.toArray((T[])new byte[0][]);
    }

    public byte[] sign(SigningProfileItem item, int ordinal, File xmlFile, boolean bIncremental) throws UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException, CertificateException, XMLSecurityException, ParserConfigurationException, IOException {
        byte[] byArray;
        Assert.notNull((Object)xmlFile);
        FileOutputStream xmlOs = null;
        try {
            xmlOs = new FileOutputStream(xmlFile);
            byArray = this.sign(item, ordinal, xmlOs, bIncremental);
        }
        catch (Throwable throwable) {
            IOUtil.tryClose((Object[])new Object[]{xmlOs});
            throw throwable;
        }
        IOUtil.tryClose((Object[])new Object[]{xmlOs});
        return byArray;
    }

    public byte[] sign(SigningProfileItem item, int ordinal, OutputStream os, boolean bIncremental) throws UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException, CertificateException, XMLSecurityException, ParserConfigurationException, IOException {
        Assert.notNull((Object)item);
        Assert.isTrue((ordinal >= 0 ? 1 : 0) != 0);
        Assert.notNull((Object)os);
        if (bIncremental) {
            bIncremental = this.loadDeltas();
        }
        Document document = this.generateStructure(ordinal, bIncremental);
        KeyStore keyStore = TizenIncrementalSigner.loadKeyStore(item.getKeyLocation(), KEY_TYPE_PKCS12, item.getPassword());
        String alias = TizenIncrementalSigner.getFirstAlias(keyStore);
        if (alias == null) {
            throw new KeyStoreException("Couldn't find an alias in the key store.");
        }
        this.addX509CertificateChain(item, keyStore, alias);
        Key key = keyStore.getKey(alias, item.getPassword());
        this.signature.sign(key);
        List<Reference> refs = this.interceptReferenceList();
        this.writeDocument(document, os);
        if (ordinal == 0) {
            AuthorSignatureXml signatureXml = new AuthorSignatureXml(document);
            this.authorXmlMap.put(signatureXml.getFilename(), signatureXml);
        }
        this.storeDigestCache(refs);
        return this.signature.getSignatureValue();
    }

    public void setInputStreamMap(Map<String, InputStream> isMap) {
        this.isMap = isMap;
    }

    public InputStream addInputStream(String uri, InputStream is) {
        Assert.notNull((Object)uri);
        Assert.notNull((Object)is);
        if (this.isMap == null) {
            this.isMap = new HashMap<String, InputStream>();
        }
        return this.isMap.put(uri, is);
    }

    public void setRealPathMap(Map<String, String> realPathMap) {
        this.realPathMap = realPathMap;
    }

    public String addRealPath(String uri, String realPath) {
        Assert.notNull((Object)uri);
        Assert.notNull((Object)realPath);
        if (this.realPathMap == null) {
            this.realPathMap = new HashMap<String, String>();
        }
        return this.realPathMap.put(uri, realPath);
    }

    protected ResolverCustomResource getResourceResolver() {
        ResolverCustomResource resolver = new ResolverCustomResource();
        resolver.addInputStreams(this.isMap);
        resolver.addRealPaths(this.realPathMap);
        resolver.setAuthorSignatureXML(this.authorXmlMap);
        return resolver;
    }

    private XMLSignature createXMLSignature(Document document, String rootPath) throws XMLSecurityException {
        XMLSignature signature = new XMLSignature(document, new File(rootPath).toURI().toString(), "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", "http://www.w3.org/2001/10/xml-exc-c14n#");
        document.appendChild(signature.getElement());
        return signature;
    }

    protected Document generateStructure(int ordinal, boolean bIncremental) throws XMLSecurityException, ParserConfigurationException, IOException {
        boolean bAuthor = SigningProfile.isAuthorOrdinal(ordinal);
        Document document = XMLUtil.create();
        this.signature = this.createXMLSignature(document, this.rootPath);
        this.signature.addResourceResolver((ResourceResolverSpi)this.getResourceResolver());
        this.signature.setId(bAuthor ? "AuthorSignature" : "DistributorSignature");
        if (bIncremental && this.cacheParser.exists()) {
            List<Reference> refs = this.interceptReferenceList();
            if (refs == null) {
                throw new XMLSecurityException("Failed to intercept the reference list. Cannot perform incrementally.");
            }
            this.restoreReferenceList(refs, bAuthor);
        } else {
            ArrayList<String> resources = new ArrayList();
            if (this.realPathMap != null) {
                for (String mapKey : this.realPathMap.keySet()) {
                    if (this.isFilterResource(mapKey, bAuthor)) continue;
                    resources.add(mapKey);
                }
            } else if (this.mode == ResourceMode.ORIGINAL) {
                resources = this.findResources(new File(this.rootPath), bAuthor);
            }
            for (String key : this.authorXmlMap.keySet()) {
                ISignatureXml xml = this.authorXmlMap.get(key);
                String xmlName = xml.getFilename();
                if (resources.contains(xmlName)) continue;
                resources.add(xmlName);
            }
            if (this.isMap != null) {
                for (String mapKey : this.isMap.keySet()) {
                    resources.add(mapKey);
                }
            }
            this.addResources(resources);
        }
        this.addPropertyElement(document, bAuthor);
        return document;
    }

    protected boolean loadDeltas() throws IOException {
        if (this.deltaParser.isRead()) {
            return true;
        }
        if (this.deltaParser.exists()) {
            this.deltaParser.read();
            return true;
        }
        return false;
    }

    protected boolean loadCaches() throws IOException {
        this.cacheParser.read();
        return true;
    }

    protected void restoreReferenceList(List<Reference> refs, boolean bAuthor) throws XMLSecurityException, IOException {
        String uri;
        this.loadCaches();
        List<String> deltasInCaches = this.removeDeltasInCaches();
        ArrayList<String> filtered = new ArrayList<String>();
        ReferenceCache[] referenceCacheArray = this.cacheParser.getCaches();
        int n = referenceCacheArray.length;
        int n2 = 0;
        while (n2 < n) {
            ReferenceCache cache = referenceCacheArray[n2];
            uri = cache.getUri();
            if (!this.isFilterResource(uri, bAuthor)) {
                filtered.add(uri);
            }
            ++n2;
        }
        filtered.addAll(deltasInCaches);
        String authorFilename = SignatureUtility.getAuthorFilename();
        if (!bAuthor && !filtered.contains(authorFilename)) {
            filtered.add(authorFilename);
        }
        this.addResources(filtered);
        ArrayList<ReferenceDelegator> delegators = new ArrayList<ReferenceDelegator>();
        for (Reference ref : refs) {
            uri = this.getURIPath(ref);
            Delta delta = this.findDeltaReference(ref);
            ReferenceDelegator.setReference(ref);
            ReferenceDelegator delegator = null;
            if (delta != null) {
                delegator = new ReferenceDelegator(ref.getElement(), ref.getBaseURI(), (Manifest)this.signature.getSignedInfo(), delta.getRealPath());
            } else {
                ReferenceCache rc = this.cacheParser.getCache(uri);
                if (rc == null) {
                    throw new IOException("Caches are broken. Reference URI is not exist in caches: " + uri);
                }
                delegator = new ReferenceDelegator(ref.getElement(), ref.getBaseURI(), (Manifest)this.signature.getSignedInfo(), rc.getDigestValue());
            }
            delegators.add(delegator);
        }
        refs.clear();
        refs.addAll(delegators);
    }

    protected List<String> removeDeltasInCaches() throws XMLSignatureException {
        ArrayList<String> list = new ArrayList<String>();
        Delta[] deltaArray = this.deltaParser.getDeltas();
        int n = deltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            Delta delta = deltaArray[n2];
            String uri = delta.getUri();
            this.cacheParser.remove(uri);
            if (delta.getState() == DeltaState.Changed) {
                list.add(uri);
            }
            ++n2;
        }
        return list;
    }

    protected Delta findDeltaReference(Reference ref) throws IOException {
        String uri = this.getURIPath(ref);
        Delta[] deltaArray = this.deltaParser.getDeltas();
        int n = deltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            Delta delta = deltaArray[n2];
            if (uri.equals(delta.getUri())) {
                if (delta.getState() != DeltaState.Changed) break;
                return delta;
            }
            ++n2;
        }
        return null;
    }

    private List<Reference> interceptReferenceList() {
        SignedInfo signedInfo = this.signature.getSignedInfo();
        Object referencesObj = ReflectionUtil.getObject((Object)signedInfo, (String)REFERENCES_IN_SIGNEDINFO, (boolean)true);
        if (referencesObj instanceof List) {
            return (List)referencesObj;
        }
        return null;
    }

    protected void storeDigestCache(List<Reference> refs) throws XMLSecurityException, IOException {
        for (Reference ref : refs) {
            String uri = this.getURIPath(ref);
            if (PROPERTY_REFERENCE_URI.equals(uri)) continue;
            byte[] digestValue = ref.getDigestValue();
            this.cacheParser.update(new ReferenceCache(uri, digestValue));
        }
        this.cacheParser.write();
    }

    protected boolean isFilterResource(String name, boolean bAuthor) {
        String[] stringArray = this.defaultFilterList;
        int n = this.defaultFilterList.length;
        int n2 = 0;
        while (n2 < n) {
            String filter = stringArray[n2];
            if (filter.equals(name)) {
                return true;
            }
            ++n2;
        }
        if (bAuthor && SignatureUtility.isAuthorSignatureFile(name)) {
            return true;
        }
        return SignatureUtility.isDistributorSignatureFile(name);
    }

    protected boolean isFilterResource(File resource, boolean bAuthor) {
        String name = resource.getName();
        return this.isFilterResource(name, bAuthor);
    }

    protected List<String> findResources(File resource, boolean bAuthor) throws XMLSignatureException {
        ArrayList<String> list = new ArrayList<String>();
        String path = FilenameUtil.getRelativePath2((String)this.rootPath, (String)resource.getPath());
        boolean bResult = this.getFilter().accept(this.rootPath, path);
        if (!bResult) {
            return list;
        }
        if (resource.isDirectory()) {
            File[] fileArray = resource.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                list.addAll(this.findResources(child, bAuthor));
                ++n2;
            }
        } else if (resource.isFile() && !this.isFilterResource(resource, bAuthor)) {
            list.add(path);
        }
        return list;
    }

    protected File getXMLFile(SigningProfileItem item) {
        return new File(this.rootPath, this.getXMLFilename(item));
    }

    protected String getXMLFilename(SigningProfileItem item) {
        Assert.notNull((Object)this.certProfile);
        Assert.notNull((Object)item);
        int ordinal = this.certProfile.getOrdinal(item);
        Assert.isTrue((ordinal != -1 ? 1 : 0) != 0);
        if (ordinal == 0) {
            return SignatureUtility.getAuthorFilename();
        }
        return SignatureUtility.getDistributorFilename(ordinal);
    }

    protected void writeDocument(Document document, OutputStream os) {
        XMLUtils.outputDOM((Node)document, (OutputStream)os);
    }

    public static KeyStore loadKeyStore(String keyFilePath, String type, char[] password) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        Assert.notNull((Object)keyFilePath);
        return TizenIncrementalSigner.loadKeyStore(new File(keyFilePath), type, password);
    }

    protected static KeyStore loadKeyStore(File keyFile, String type, char[] password) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        KeyStore keyStore;
        Assert.notNull((Object)keyFile);
        Assert.notNull((Object)type);
        Assert.notNull((Object)password);
        String path = keyFile.getPath();
        logger.debug("Load key path: {}", (Object)path);
        if (!keyFile.exists()) {
            throw new FileNotFoundException(path);
        }
        KeyStore keyStore2 = KeyStore.getInstance(type);
        FileInputStream keyIs = null;
        try {
            keyIs = new FileInputStream(keyFile);
            keyStore2.load(keyIs, password);
            keyStore = keyStore2;
        }
        catch (Throwable throwable) {
            IOUtil.tryClose((Object[])new Object[]{keyIs});
            throw throwable;
        }
        IOUtil.tryClose((Object[])new Object[]{keyIs});
        return keyStore;
    }

    public static String getFirstAlias(KeyStore keyStore) throws KeyStoreException {
        Assert.notNull((Object)keyStore);
        Enumeration<String> aliases = keyStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            if (!keyStore.isKeyEntry(alias)) continue;
            return alias;
        }
        return null;
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected X509Certificate getX509Certificate(String pemFilePath) throws IOException {
        X509Certificate x509Certificate;
        Object object;
        Assert.notNull((Object)pemFilePath);
        FileReader reader = null;
        PEMReader pemReader = null;
        try {
            reader = new FileReader(pemFilePath);
            pemReader = new PEMReader((Reader)reader);
            object = null;
            boolean bl = true;
            while (true) {
                if (bl && !(bl = false)) {
                    if (true) break block5;
                }
                if (!(object instanceof X509Certificate)) break block5;
                x509Certificate = (X509Certificate)object;
                break;
            }
        }
        catch (Throwable throwable) {
            IOUtil.tryClose((Object[])new Object[]{pemReader, reader});
            throw throwable;
        }
        {
            block5: {
                IOUtil.tryClose((Object[])new Object[]{pemReader, reader});
                return x509Certificate;
            }
            if ((object = pemReader.readObject()) != null) continue;
        }
        IOUtil.tryClose((Object[])new Object[]{pemReader, reader});
        return null;
    }

    protected void addX509CertificateChain(SigningProfileItem item, KeyStore keyStore, String alias) throws XMLSecurityException, IOException, KeyStoreException {
        this.addX509CertificateChain(this.signature, item, keyStore, alias);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void addX509CertificateChain(XMLSignature signaturXml, SigningProfileItem item, KeyStore keyStore, String alias) throws XMLSecurityException, IOException, KeyStoreException {
        Assert.notNull((Object)signaturXml);
        Assert.notNull((Object)keyStore);
        String[] caPaths = this.getCertPaths(item);
        Certificate[] certificateChain = keyStore.getCertificateChain(alias);
        Assert.notNull((Object)certificateChain);
        Assert.isTrue((certificateChain.length > 0 ? 1 : 0) != 0);
        Assert.isTrue((boolean)(certificateChain[0] instanceof X509Certificate));
        signaturXml.addKeyInfo((X509Certificate)certificateChain[0]);
        X509Data x509Data = signaturXml.getKeyInfo().itemX509Data(0);
        if (x509Data == null) {
            x509Data = new X509Data(signaturXml.getDocument());
            signaturXml.getKeyInfo().add(x509Data);
        }
        int i = 1;
        while (i < 3) {
            if (certificateChain.length < i + 1) {
                String path = caPaths[i - 1];
                if (!StringUtil.isEmpty((CharSequence)path)) {
                    X509Certificate caX509Certificate = this.getX509Certificate(path);
                    if (caX509Certificate == null) throw new XMLSecurityException("X509Certificate is not found in: " + path);
                    x509Data.addCertificate(caX509Certificate);
                }
            } else {
                Assert.isTrue((boolean)(certificateChain[i] instanceof X509Certificate));
                x509Data.addCertificate((X509Certificate)certificateChain[i]);
            }
            ++i;
        }
    }

    protected String[] getCertPaths(SigningProfileItem item) {
        Assert.notNull((Object)item);
        return new String[]{item.getCAPath(), item.getRootCAPath()};
    }

    protected void addResources(List<String> resources) throws XMLSignatureException, IOException {
        Collections.sort(resources);
        for (String uri : resources) {
            this.addResource(uri, null);
        }
    }

    protected void addResources(XMLSignature signature, List<String> resources) throws XMLSignatureException, IOException {
        Collections.sort(resources);
        for (String uri : resources) {
            this.addResource(signature, uri, null);
        }
    }

    protected void addResource(String uri, Transforms trans) throws XMLSignatureException, IOException {
        Assert.notNull((Object)this.signature);
        Assert.notNull((Object)uri);
        this.addResource(this.signature, uri, trans);
    }

    private void addResource(XMLSignature signature, String uri, Transforms trans) throws XMLSignatureException, IOException {
        String refUrl = URIEscapeUtil.encode((String)uri);
        signature.addDocument(refUrl, trans, "http://www.w3.org/2001/04/xmlenc#sha256");
    }

    protected String getURIPath(Reference ref) throws IOException {
        Assert.notNull((Object)ref);
        String encodedURI = ref.getURI();
        return URIEscapeUtil.decode((String)encodedURI);
    }

    protected void addPropertyElement(Document document, boolean isAuthor) throws XMLSignatureException, TransformationException {
        Assert.notNull((Object)this.signature);
        this.addPropertyElement(this.signature, document, isAuthor);
    }

    protected void addPropertyElement(XMLSignature signature, Document document, boolean isAuthor) throws XMLSignatureException, TransformationException {
        String[][] propertyTypes;
        Assert.notNull((Object)document);
        ObjectContainer container = new ObjectContainer(document);
        container.setId("prop");
        Element properties = document.createElement("SignatureProperties");
        properties.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:dsp", "http://www.w3.org/2009/xmldsig-properties");
        String signTypeTarget = isAuthor ? "#AuthorSignature" : "#DistributorSignature";
        String signTypeRoleURI = isAuthor ? "http://www.w3.org/ns/widgets-digsig#role-author" : "http://www.w3.org/ns/widgets-digsig#role-distributor";
        String[][] stringArrayArray = new String[3][];
        stringArrayArray[0] = new String[]{"profile", "dsp:Profile", "http://www.w3.org/ns/widgets-digsig#profile"};
        stringArrayArray[1] = new String[]{"role", "dsp:Role", signTypeRoleURI};
        String[] stringArray = new String[3];
        stringArray[0] = "identifier";
        stringArray[1] = "dsp:Identifier";
        stringArrayArray[2] = stringArray;
        String[][] stringArrayArray2 = propertyTypes = stringArrayArray;
        int n = propertyTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String[] propertyType = stringArrayArray2[n2];
            String propertyId = propertyType[0];
            String propertyName = propertyType[1];
            String uri = propertyType[2];
            Element profileProperty = this.createPropertyElement(document, propertyId, signTypeTarget);
            profileProperty.appendChild(this.createSubPropertyElement(document, propertyName, uri));
            properties.appendChild(profileProperty);
            ++n2;
        }
        container.appendChild((Node)properties);
        signature.appendObject(container);
        Transforms transforms = new Transforms(document);
        transforms.addTransform("http://www.w3.org/2006/12/xml-c14n11");
        signature.addDocument(PROPERTY_REFERENCE_URI, transforms, "http://www.w3.org/2001/04/xmlenc#sha256");
    }

    private Element createSubPropertyElement(Document document, String propertyName, String uri) {
        Element subProperty = document.createElement(propertyName);
        if (uri != null) {
            subProperty.setAttribute("URI", uri);
        }
        return subProperty;
    }

    private Element createPropertyElement(Document document, String idValue, String targetValue) {
        Element property = document.createElement("SignatureProperty");
        property.setAttribute("Id", idValue);
        property.setAttribute("Target", targetValue);
        return property;
    }

    public static boolean checkCertificatePassword(String keyPath, String password) throws FileNotFoundException, NoSuchAlgorithmException, CertificateException, KeyStoreException {
        Assert.notNull((Object)keyPath);
        Assert.notNull((Object)password);
        char[] pwd = password.toCharArray();
        try {
            KeyStore keyStore = TizenIncrementalSigner.loadKeyStore(keyPath, KEY_TYPE_PKCS12, pwd);
            String alias = TizenIncrementalSigner.getFirstAlias(keyStore);
            if (alias == null) {
                throw new CertificateException("Couldn't find an alias in the KeyStore.");
            }
            return keyStore.getKey(alias, pwd) != null;
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException iOException) {
            logger.error("{} is invalid certificate file or password incorrect.", (Object)keyPath);
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            logger.error("{} is invalid certificate file or password incorrect.", (Object)keyPath);
        }
        return false;
    }

    public static enum ResourceMode {
        ORIGINAL,
        HAVE_REAL;

    }
}

