/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sign.signer;

import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.sign.preferences.SigningProfile;
import org.tizen.common.sign.preferences.SigningProfileItem;
import org.tizen.common.sign.signer.TizenIncrementalSigner;
import org.tizen.common.sign.util.SignatureUtility;
import org.tizen.common.util.StringUtil;

public class TizenSigner {
    protected static final Logger logger = LoggerFactory.getLogger(TizenSigner.class);

    public static void usage() {
        System.out.println("Tizen Signer 1.0.0");
        System.out.println("Usage:");
        System.out.println(" java org.tizen.common.sign.signer.TizenSigner targetDir authorCAPath authorP12Path authorPass dist1P12Path dist1Pass dist1CAPath dist2P12Path dist2Pass dist2CAPath dist2RootPath");
        System.err.println(" java org.tizen.common.sign.signer.TizenSigner targetDir authorCAPath authorP12Path authorPass dist1P12Path dist1Pass dist1CAPath dist2P12Path dist2Pass dist2CAPath dist2RootPath");
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 11) {
            TizenSigner.usage();
            return;
        }
        String targetDir = args[0];
        String authorCAPath = args[1];
        String authorP12Path = args[2];
        String authorPass = args[3];
        String dist1P12Path = args[4];
        String dist1Pass = args[5];
        String dist1CAPath = args[6];
        String dist2P12Path = args[7];
        String dist2Pass = args[8];
        String dist2CAPath = args[9];
        String dist2RootPath = args[10];
        SigningProfile profile = new SigningProfile("temp");
        profile.createProfileItem(0, authorP12Path, authorPass, authorCAPath, null);
        logger.info("[Author] p12: {}, CA: {}", (Object)authorP12Path, (Object)authorCAPath);
        TizenSigner.checkNullParameters(targetDir, authorP12Path, authorPass);
        profile.createProfileItem(1, dist1P12Path, dist1Pass, dist1CAPath, null);
        logger.info("[Distributor1] p12: {}, CA: {}", (Object)dist1P12Path, (Object)dist1CAPath);
        TizenSigner.checkNullParameters(targetDir, dist1P12Path, dist1Pass);
        if (!StringUtil.isEmpty((CharSequence)dist2P12Path)) {
            logger.info("[Distributor2] p12: {}, CA: {}, RootCA: {}", new Object[]{dist2P12Path, dist2CAPath, dist2RootPath});
            profile.createProfileItem(2, dist2P12Path, dist2Pass, dist2CAPath, dist2RootPath);
            TizenSigner.checkNullParameters(targetDir, dist2P12Path, dist2Pass);
        }
        TizenIncrementalSigner signer = new TizenIncrementalSigner(profile, targetDir);
        signer.sign(false);
    }

    public static void authorSign(String targetDir, String authorP12Path, String authorPass, String authorCAPath, String rootCaPath) throws Exception {
        TizenSigner.checkNullParameters(targetDir, authorP12Path, authorPass);
        SigningProfileItem item = new SigningProfileItem();
        item.setKeyLocation(authorP12Path);
        item.setPassword(authorPass.toCharArray());
        item.setCAPath(authorCAPath);
        item.setRootCAPath(rootCaPath);
        TizenIncrementalSigner signer = new TizenIncrementalSigner(null, targetDir);
        String signatureName = SignatureUtility.getAuthorFilename();
        signer.sign(item, 0, new File(targetDir, signatureName), false);
    }

    public static void distSign(String targetDir, String distP12Path, String distPass, String distCAPath, String distRootPath, int distNumber) throws Exception {
        TizenSigner.checkNullParameters(targetDir, distP12Path, distPass);
        SigningProfileItem item = new SigningProfileItem();
        item.setKeyLocation(distP12Path);
        item.setPassword(distPass.toCharArray());
        item.setCAPath(distCAPath);
        item.setRootCAPath(distRootPath);
        TizenIncrementalSigner signer = new TizenIncrementalSigner(null, targetDir);
        String signatureName = SignatureUtility.getDistributorFilename(distNumber);
        signer.sign(item, distNumber, new File(targetDir, signatureName), false);
    }

    public static void authorIncrementalSign(String targetDir, String authorP12Path, String authorPass, String authorCAPath, String rootCaPath) throws Exception {
        TizenSigner.checkNullParameters(targetDir, authorP12Path, authorPass);
        SigningProfileItem item = new SigningProfileItem();
        item.setKeyLocation(authorP12Path);
        item.setPassword(authorPass.toCharArray());
        item.setCAPath(authorCAPath);
        item.setRootCAPath(rootCaPath);
        TizenIncrementalSigner signer = new TizenIncrementalSigner(null, targetDir);
        String signatureName = SignatureUtility.getAuthorFilename();
        signer.sign(item, 0, new File(targetDir, signatureName), true);
    }

    public static void distIncrementalSign(String targetDir, String distP12Path, String distPass, String distCAPath, String distRootPath, int distNumber) throws Exception {
        TizenSigner.checkNullParameters(targetDir, distP12Path, distPass);
        SigningProfileItem item = new SigningProfileItem();
        item.setKeyLocation(distP12Path);
        item.setPassword(distPass.toCharArray());
        item.setCAPath(distCAPath);
        item.setRootCAPath(distRootPath);
        TizenIncrementalSigner signer = new TizenIncrementalSigner(null, targetDir);
        String signatureName = SignatureUtility.getDistributorFilename(distNumber);
        signer.sign(item, distNumber, new File(targetDir, signatureName), true);
    }

    private static void checkNullParameters(String targetDir, String p12Path, String pass) throws IllegalArgumentException {
        String emptyParameter = null;
        if (StringUtil.isEmpty((CharSequence)targetDir)) {
            emptyParameter = "target directory";
        } else if (StringUtil.isEmpty((CharSequence)p12Path)) {
            emptyParameter = "certificate location";
        } else if (StringUtil.isEmpty((CharSequence)pass)) {
            emptyParameter = "password";
        } else {
            return;
        }
        throw new IllegalArgumentException(String.valueOf(emptyParameter) + " is empty");
    }

    public static void dist2SignWithParameterCheck(String targetDir, String dist2P12Path, String dist2Pass, String dist2CAPath, String dist2RootPath) throws Exception {
        if (!StringUtil.isEmpty((CharSequence)dist2P12Path) && !StringUtil.isEmpty((CharSequence)dist2Pass)) {
            if (StringUtil.isEmpty((CharSequence)dist2CAPath) || StringUtil.isEmpty((CharSequence)dist2RootPath)) {
                dist2CAPath = null;
                dist2RootPath = null;
            }
            TizenSigner.distSign(targetDir, dist2P12Path, dist2Pass, dist2CAPath, dist2RootPath, 2);
        }
    }

    public static void dist2IncrementalSignWithParameterCheck(String targetDir, String dist2P12Path, String dist2Pass, String dist2CAPath, String dist2RootPath) throws Exception {
        if (!StringUtil.isEmpty((CharSequence)dist2P12Path) && !StringUtil.isEmpty((CharSequence)dist2Pass)) {
            if (StringUtil.isEmpty((CharSequence)dist2CAPath) || StringUtil.isEmpty((CharSequence)dist2RootPath)) {
                dist2CAPath = null;
                dist2RootPath = null;
            }
            TizenSigner.distIncrementalSign(targetDir, dist2P12Path, dist2Pass, dist2CAPath, dist2RootPath, 2);
        }
    }
}

