/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sign.preferences;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.InvalidKeyException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.sign.preferences.SigningProfileItem;
import org.tizen.common.sign.util.SigningPathUtil;
import org.tizen.common.sign.util.XMLUtil;
import org.tizen.common.util.Assert;
import org.tizen.common.util.CipherUtil;
import org.tizen.common.util.ParsingUtil;
import org.tizen.common.util.StringUtil;
import org.tizen.common.util.cryptutil.CryptFactory;
import org.tizen.common.util.cryptutil.ICrypt;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SigningProfile {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected String profileName;
    protected final Map<Integer, SigningProfileItem> profileItemMap;
    public static final int AUTHOR_ORDINAL = 0;
    public static final int MAX_DISTRIBUTOR = 2;
    public static final int NOTHING = -1;
    private static final String PWD_EXT = ".pwd";
    private static final String P12_EXT = ".p12";

    public SigningProfile(String profileName) {
        Assert.notNull((Object)profileName);
        this.profileName = profileName;
        this.profileItemMap = new HashMap<Integer, SigningProfileItem>();
        int i = 0;
        while (i <= 2) {
            this.profileItemMap.put(i, null);
            ++i;
        }
    }

    public String getProfileName() {
        return this.profileName;
    }

    public void setProfileName(String profileName) {
        Assert.notNull((Object)profileName);
        this.profileName = profileName;
    }

    public void setProfileItem(int ordinal, SigningProfileItem item) {
        Assert.isTrue((ordinal >= 0 && ordinal <= 2 ? 1 : 0) != 0);
        this.profileItemMap.put(ordinal, item);
    }

    public SigningProfileItem getProfileItem(int ordinal) {
        Assert.isTrue((ordinal >= 0 && ordinal <= 2 ? 1 : 0) != 0);
        return this.profileItemMap.get(ordinal);
    }

    public boolean containsProfileItem(int ordinal) {
        return this.getProfileItem(ordinal) != null;
    }

    public SigningProfileItem removeProfileItem(int ordinal) {
        Assert.isTrue((ordinal >= 0 && ordinal <= 2 ? 1 : 0) != 0);
        SigningProfileItem removedItem = this.profileItemMap.remove(ordinal);
        this.profileItemMap.put(ordinal, null);
        return removedItem;
    }

    public List<SigningProfileItem> getProfileItems() {
        ArrayList<SigningProfileItem> result = new ArrayList<SigningProfileItem>();
        TreeSet<Integer> keys = new TreeSet<Integer>(this.profileItemMap.keySet());
        for (Integer key : keys) {
            result.add(this.profileItemMap.get(key));
        }
        return result;
    }

    public SigningProfileItem getAuthorProfileItem() {
        return this.getProfileItem(0);
    }

    public List<SigningProfileItem> getDistributorProfileItems() {
        ArrayList<SigningProfileItem> result = new ArrayList<SigningProfileItem>();
        TreeSet<Integer> keys = new TreeSet<Integer>(this.profileItemMap.keySet());
        for (Integer key : keys) {
            if (key == 0) continue;
            result.add(this.profileItemMap.get(key));
        }
        return result;
    }

    public SigningProfileItem createProfileItem(int ordinal, String keyPath, String password, String caPath, String rootCaPath) {
        Assert.isTrue((ordinal >= 0 ? 1 : 0) != 0);
        SigningProfileItem item = new SigningProfileItem(keyPath == null ? "" : keyPath, "", SigningProfile.isAuthorOrdinal(ordinal), caPath == null ? "" : caPath, rootCaPath == null ? "" : rootCaPath);
        if (!StringUtil.isEmpty((CharSequence)password)) {
            item.setPassword(password.toCharArray());
        }
        this.setProfileItem(ordinal, item);
        return item;
    }

    public boolean stored(String passwordAttr) {
        return !passwordAttr.endsWith(PWD_EXT);
    }

    public SigningProfileItem readProfileItem(Node node, String version) {
        if (!(node instanceof Element)) {
            return null;
        }
        Element itemElement = (Element)node;
        String passwordAttr = itemElement.getAttribute("password");
        String key = itemElement.getAttribute("key");
        String author = itemElement.getAttribute("author");
        String distributor = itemElement.getAttribute("distributor");
        String ca = itemElement.getAttribute("ca");
        String rootca = itemElement.getAttribute("rootca");
        String pass = "";
        if (!passwordAttr.isEmpty() && !key.isEmpty()) {
            if (this.stored(passwordAttr)) {
                try {
                    pass = CipherUtil.getDecryptedString((String)passwordAttr);
                }
                catch (InvalidKeyException e) {
                    this.logger.error("Exception occurred while decrypting signing password", (Throwable)e);
                }
                catch (IllegalBlockSizeException e) {
                    this.logger.error("Exception occurred while decrypting signing password", (Throwable)e);
                }
                catch (BadPaddingException e) {
                    this.logger.error("Exception occurred while decrypting signing password", (Throwable)e);
                }
            } else {
                ICrypt dec = CryptFactory.getCrypt();
                pass = dec.decrypt(passwordAttr);
            }
        }
        int ordinal = -1;
        ordinal = StringUtil.isEmpty((CharSequence)version) ? (ParsingUtil.parseBoolean((String)author, (boolean)false) ? 0 : this.getEmptyDistributorOrdinal()) : ParsingUtil.parseInt((String)distributor, (int)-1);
        if (ordinal <= -1 || ordinal > 2) {
            return null;
        }
        this.logger.trace("item - key: {}, ordinal: {}, ca: {}, rootca: {}, pass: {}", new Object[]{key, ordinal, ca, rootca, StringUtil.mask((String)pass, (String)"*")});
        return this.createProfileItem(ordinal, key, pass, ca, rootca);
    }

    public void writeProfileItem(Document doc, Element profileElement, int ordinal) {
        String keyLocation;
        Assert.notNull((Object)doc);
        Assert.notNull((Object)profileElement);
        SigningProfileItem item = this.getProfileItem(ordinal);
        if (item == null) {
            return;
        }
        Element element = doc.createElement("profileitem");
        XMLUtil.setElementAttribute(doc, "key", item.getKeyLocation(), element);
        XMLUtil.setElementAttribute(doc, "ca", item.getCAPath(), element);
        XMLUtil.setElementAttribute(doc, "rootca", item.getRootCAPath(), element);
        String passwordAttr = keyLocation = Paths.get(item.getKeyLocation(), new String[0]).toString();
        if (!keyLocation.toString().isEmpty()) {
            Path sdkPath = Paths.get(InstallPathConfig.getSDKPath(), new String[0]);
            try {
                Path sdkDataPath = Paths.get(InstallPathConfig.getUserDataPath(), new String[0]);
                Path keyLocPath = Paths.get(keyLocation, new String[0]);
                if (keyLocPath.startsWith(sdkPath)) {
                    passwordAttr = sdkDataPath.resolve(keyLocPath.subpath(sdkDataPath.getNameCount(), keyLocPath.getNameCount())).toString();
                }
            }
            catch (Exception e) {
                this.logger.error("Unable to extract SDK data path: ", (Throwable)e);
            }
            passwordAttr = String.valueOf(passwordAttr.substring(0, passwordAttr.lastIndexOf(P12_EXT))) + PWD_EXT;
            char[] password = item.getPassword();
            String pass = password == null ? "" : new String(item.getPassword());
            ICrypt enc = CryptFactory.getCrypt();
            enc.encrypt(pass, passwordAttr);
        }
        XMLUtil.setElementAttribute(doc, "password", passwordAttr, element);
        XMLUtil.setElementAttribute(doc, "distributor", Integer.toString(ordinal), element);
        profileElement.appendChild(element);
    }

    public SigningProfileItem createProfileItemForDeveloper() {
        return this.createProfileItem(1, SigningPathUtil.getDeveloperKeyPath(), SigningPathUtil.getDeveloperKeyPassword(), SigningPathUtil.getDeveloperCAPath(), "");
    }

    public SigningProfileItem createProfileItemForDeveloperNewVersion() {
        return this.createProfileItem(1, SigningPathUtil.getDeveloperKeyPathNewVersion(), SigningPathUtil.getDeveloperKeyPassword(), SigningPathUtil.getDeveloperCAPathNewVersion(), "");
    }

    public SigningProfileItem createProfileItemForPartnerDeveloper(int versionLevel) {
        if (versionLevel == 0) {
            return this.createProfileItem(1, SigningPathUtil.getPartnerDeveloperKeyPath(), SigningPathUtil.getDeveloperKeyPassword(), SigningPathUtil.getPartnerDeveloperCAPath(), "");
        }
        return this.createProfileItem(1, SigningPathUtil.getPartnerDeveloperNewVersionKeyPath(), SigningPathUtil.getDeveloperKeyPassword(), SigningPathUtil.getPartnerDeveloperNewVersionCAPath(), "");
    }

    public SigningProfileItem createProfileItemForPlatformDeveloper(int versionLevel) {
        if (versionLevel == 0) {
            return this.createProfileItem(1, SigningPathUtil.getPlatformDeveloperKeyPath(), SigningPathUtil.getDeveloperKeyPassword(), SigningPathUtil.getPlatformDeveloperCAPath(), "");
        }
        return this.createProfileItem(1, SigningPathUtil.getPlatformDeveloperNewVersionKeyPath(), SigningPathUtil.getDeveloperKeyPassword(), SigningPathUtil.getPlatformDeveloperNewVersionCAPath(), "");
    }

    public SigningProfileItem createProfileItemForNewVersion() {
        return this.createProfileItem(1, SigningPathUtil.getNewVersionKeyPath(), SigningPathUtil.getDeveloperKeyPassword(), SigningPathUtil.getNewVersionCAPath(), "");
    }

    public SigningProfileItem createEmptyProfileItem(int ordinal) {
        String defaultCAPath = "";
        if (SigningProfile.isAuthorOrdinal(ordinal)) {
            defaultCAPath = SigningPathUtil.getAuthorCAPath();
        }
        return this.createProfileItem(ordinal, "", "", defaultCAPath, "");
    }

    public static boolean isAuthorOrdinal(int ordinal) {
        return ordinal == 0;
    }

    public int getEmptyDistributorOrdinal() {
        int i = 1;
        while (i <= 2) {
            if (!this.containsProfileItem(i)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getOrdinal(SigningProfileItem item) {
        TreeSet<Integer> keys = new TreeSet<Integer>(this.profileItemMap.keySet());
        for (Integer key : keys) {
            if (item != this.profileItemMap.get(key)) continue;
            return key;
        }
        return -1;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SigningProfile)) {
            return false;
        }
        SigningProfile profile = (SigningProfile)obj;
        int i = 0;
        while (i <= 1) {
            if (!this.getProfileItem(i).equals(profile.getProfileItem(i))) {
                return false;
            }
            ++i;
        }
        SigningProfileItem thisLastItem = this.getProfileItem(2);
        SigningProfileItem objLastItem = profile.getProfileItem(2);
        if (thisLastItem == null) {
            if (objLastItem == null) {
                return true;
            }
            return !objLastItem.hasKeyLocation();
        }
        if (objLastItem == null) {
            return !thisLastItem.hasKeyLocation();
        }
        return thisLastItem.equals(objLastItem);
    }

    public int hashCode() {
        return 100;
    }
}

