/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sign.ui.dialog;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.sign.preferences.SigningProfileItem;
import org.tizen.common.sign.signer.TizenIncrementalSigner;
import org.tizen.common.sign.ui.dialog.Messages;
import org.tizen.common.sign.util.SigningPathUtil;
import org.tizen.common.sign.util.SigningProfileUtil;
import org.tizen.common.ui.font.TizenFonts;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.StringUtil;
import signing.CertificateChecker;

public class CertificateEditionDialog
extends Dialog {
    private Label lDescription;
    private Text textCertPath;
    private Text textCertPasswd;
    private final int IDX_CERTPATH = 0;
    private final int IDX_PASSWORD = 1;
    private String certPath;
    private String certPasswd;
    private boolean isDistributor;
    private SigningProfileItem originCert;
    private static final Logger logger = LoggerFactory.getLogger(CertificateEditionDialog.class);

    public CertificateEditionDialog(Shell parentShell, SigningProfileItem cert, boolean isDist) {
        super(parentShell);
        this.originCert = cert;
        this.isDistributor = isDist;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.CERT_EDIT_DLG_TITLE);
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10 | 0x400);
    }

    protected Point getInitialSize() {
        return new Point(680, 400);
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        CertificateEditionDialog.applyDialogFont((Control)composite);
        this.initializeDialogUnits((Control)composite);
        this.createTitleArea(composite);
        this.dialogArea = this.createDialogArea(composite);
        this.buttonBar = this.createButtonBar(composite);
        this.setInput();
        return composite;
    }

    public void setDescription(String description) {
        this.lDescription.setText(description);
    }

    private Control createTitleArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 20;
        GridData layoutData = new GridData(768);
        layoutData.heightHint = 40;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)layoutData);
        composite.setBackground(this.getShell().getDisplay().getSystemColor(1));
        this.lDescription = new Label(composite, 0);
        layoutData = new GridData(772);
        layoutData.grabExcessVerticalSpace = true;
        this.lDescription.setLayoutData((Object)layoutData);
        this.lDescription.setBackground(this.getShell().getDisplay().getSystemColor(1));
        this.setDescription(Messages.CERT_EDIT_DLG_DESC);
        return composite;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 2048);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 30;
        layout.marginWidth = 30;
        layout.verticalSpacing = 18;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.createPathComposite(composite);
        this.createPasswordComposite(composite);
        return composite;
    }

    private void createPathComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 4;
        layout.horizontalSpacing = 10;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        Label lCertPath = new Label(composite, 0);
        lCertPath.setFont(TizenFonts.getBoldFont());
        lCertPath.setText(Messages.CERT_EDIT_DLG_FILEPATH);
        GridData labelLayout = new GridData(769);
        labelLayout.horizontalSpan = 2;
        lCertPath.setLayoutData((Object)labelLayout);
        this.textCertPath = new Text(composite, 2048);
        GridData layoutData = new GridData(768);
        layoutData.verticalIndent = 11;
        this.textCertPath.setLayoutData((Object)layoutData);
        this.textCertPath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                CertificateEditionDialog.this.validate();
            }
        });
        Button btBrowse = new Button(composite, 8);
        layoutData = new GridData();
        layoutData.verticalIndent = 11;
        btBrowse.setLayoutData((Object)layoutData);
        btBrowse.setText(Messages.CERT_EDIT_DLG_BROWSE);
        btBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                FileDialog dlg = new FileDialog(CertificateEditionDialog.this.getShell(), 4096);
                dlg.setFilterExtensions(new String[]{"*.p12"});
                if (CertificateEditionDialog.this.isDistributor) {
                    dlg.setFilterPath(SigningPathUtil.getDistributorCertificatePath());
                } else {
                    dlg.setFilterPath(SigningProfileUtil.getAuthorCertStorePath().toPortableString());
                }
                String filepath = dlg.open();
                if (!StringUtil.isEmpty((CharSequence)filepath)) {
                    CertificateEditionDialog.this.textCertPath.setText(filepath);
                }
            }
        });
        Label lpathError = this.createErrorLabel(composite);
        layoutData = new GridData();
        lpathError.setLayoutData((Object)layoutData);
        this.textCertPath.setData("label", (Object)lpathError);
    }

    private void createPasswordComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 4;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        Label lPasswd = new Label(composite, 0);
        lPasswd.setFont(TizenFonts.getBoldFont());
        if (this.isDistributor) {
            lPasswd.setText(Messages.CERT_EDIT_DLG_PASSWD);
        } else {
            lPasswd.setText(Messages.CERT_EDIT_DLG_PASSWD_OPTIONAL);
        }
        lPasswd.setLayoutData((Object)new GridData(768));
        this.textCertPasswd = new Text(composite, 0x400800);
        GridData layoutData = new GridData(768);
        layoutData.verticalIndent = 11;
        this.textCertPasswd.setLayoutData((Object)layoutData);
        this.textCertPasswd.setMessage(Messages.CERT_EDIT_DLG_PASSWD_GUIDE);
        this.textCertPasswd.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                CertificateEditionDialog.this.validate();
            }
        });
        Label lError = this.createErrorLabel(composite);
        layoutData = new GridData();
        lError.setLayoutData((Object)layoutData);
        this.textCertPasswd.setData("label", (Object)lError);
    }

    private Label createErrorLabel(Composite parent) {
        Label label = new Label(parent, 0);
        label.setFont(TizenFonts.getSmallFont());
        label.setForeground(this.getShell().getDisplay().getSystemColor(3));
        return label;
    }

    private void setErrorLabel(int index, String message) {
        Label label;
        if (index == 0) {
            label = (Label)this.textCertPath.getData("label");
        } else if (index == 1) {
            label = (Label)this.textCertPasswd.getData("label");
        } else {
            return;
        }
        label.setText(message);
        label.getParent().layout();
    }

    private void setInput() {
        if (this.originCert != null) {
            this.textCertPath.setText(this.originCert.getKeyLocation());
            this.textCertPasswd.setText(new String(this.originCert.getPassword()));
        }
    }

    public String getCertPath() {
        return this.certPath;
    }

    public String getCertPasswd() {
        return this.certPasswd;
    }

    protected void okPressed() {
        this.certPath = this.textCertPath.getText();
        this.certPasswd = this.textCertPasswd.getText();
        super.okPressed();
    }

    protected void validate() {
        boolean validDistCert;
        boolean validPasswd;
        boolean validPath;
        block13: {
            validPath = false;
            validPasswd = false;
            validDistCert = true;
            if (!this.textCertPath.getText().isEmpty()) {
                if (FileUtil.isExist((String)this.textCertPath.getText())) {
                    this.setErrorLabel(0, "");
                    validPath = true;
                } else {
                    this.setErrorLabel(0, Messages.CERT_PATH_ERROR);
                    validPath = false;
                }
            } else {
                this.setErrorLabel(0, "");
                validPath = false;
            }
            if (validPath && !this.textCertPasswd.getText().isEmpty()) {
                try {
                    if (TizenIncrementalSigner.checkCertificatePassword(this.textCertPath.getText(), this.textCertPasswd.getText())) {
                        this.setErrorLabel(1, "");
                        validPasswd = true;
                        if (this.isDistributor) {
                            if (CertificateChecker.isAuthorCertificate((String)SigningPathUtil.getRootCertificatePath(), (String)this.textCertPath.getText(), (String)this.textCertPasswd.getText())) {
                                validDistCert = false;
                                this.setErrorLabel(1, Messages.CERT_DISTCERT_ERROR);
                            } else {
                                validDistCert = true;
                                this.setErrorLabel(1, "");
                            }
                        }
                        break block13;
                    }
                    this.setErrorLabel(1, Messages.CERT_PASSWORD_ERROR);
                    validPasswd = false;
                }
                catch (Exception exception) {
                    logger.warn("Invalid certificate file or incorrect password.");
                }
            } else {
                this.setErrorLabel(1, "");
                if (!this.isDistributor) {
                    validPasswd = true;
                }
            }
        }
        this.getButton(0).setEnabled(validPath && validPasswd && validDistCert);
    }
}

