/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sign.ui.dialog;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.sign.preferences.SigningProfile;
import org.tizen.common.sign.ui.dialog.Messages;
import org.tizen.common.ui.font.TizenFonts;

public class DuplicateProfileDialog
extends Dialog {
    private Label lDescription;
    private SigningProfile originalProfile;
    private SigningProfile importingProfile;
    private boolean applyAll;
    private int importSelection = 0;
    public static final int DUPLICATE_PROFILE_OVERWRITE = 0;
    public static final int DUPLICATE_PROFILE_KEEP_OLD = 1;
    public static final int DUPLICATE_PROFILE_KEEP_BOTH = 2;
    private static final Logger logger = LoggerFactory.getLogger(DuplicateProfileDialog.class);

    public DuplicateProfileDialog(Shell parentShell, SigningProfile orig, SigningProfile importing) {
        super(parentShell);
        this.originalProfile = orig;
        this.importingProfile = importing;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.PROFILE_MIGRATE_DLG_TITLE);
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10 | 0x400);
    }

    protected Point getInitialSize() {
        return new Point(576, 538);
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        DuplicateProfileDialog.applyDialogFont((Control)composite);
        this.initializeDialogUnits((Control)composite);
        this.createTitleArea(composite);
        this.dialogArea = this.createDialogArea(composite);
        this.buttonBar = this.createButtonBar(composite);
        return composite;
    }

    public void setDescription(String description) {
        this.lDescription.setText(description);
    }

    private Control createTitleArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 20;
        GridData layoutData = new GridData(768);
        layoutData.heightHint = 60;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)layoutData);
        composite.setBackground(this.getShell().getDisplay().getSystemColor(1));
        this.lDescription = new Label(composite, 0);
        layoutData = new GridData(772);
        layoutData.grabExcessVerticalSpace = true;
        this.lDescription.setLayoutData((Object)layoutData);
        this.lDescription.setBackground(this.getShell().getDisplay().getSystemColor(1));
        this.setDescription(Messages.DUPLICATE_PROFILE_DLG_DESC);
        return composite;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 2048);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 20;
        layout.marginWidth = 30;
        layout.verticalSpacing = 10;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.duplicateProfileInfoComposite(composite);
        this.applyAllComposite(composite);
        return composite;
    }

    private void duplicateProfileInfoComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 4;
        layout.horizontalSpacing = 10;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        Label lProfileName = new Label(composite, 0);
        lProfileName.setFont(TizenFonts.getBoldFont());
        lProfileName.setText(String.valueOf(Messages.DUPLICATE_PROFILE_DLG_CERT_PROFILE_NAME) + this.originalProfile.getProfileName());
        GridData labelLayout = new GridData(769);
        lProfileName.setLayoutData((Object)labelLayout);
        Composite selectionGroup = new Composite(composite, 0);
        layout = new GridLayout(2, false);
        selectionGroup.setLayout((Layout)layout);
        GridData layoutData = new GridData(768);
        selectionGroup.setLayoutData((Object)layoutData);
        Button btImport = new Button(selectionGroup, 16);
        layoutData = new GridData(769);
        layoutData.horizontalSpan = 2;
        layoutData.verticalIndent = 11;
        btImport.setLayoutData((Object)layoutData);
        btImport.setText(Messages.DUPLICATE_PROFILE_DLG_OVERWRITE);
        Label lImportingAuthor = new Label(selectionGroup, 0);
        lImportingAuthor.setText(Messages.DUPLICATE_PROFILE_DLG_AUTHOR);
        labelLayout = new GridData();
        labelLayout.horizontalIndent = 5;
        lImportingAuthor.setLayoutData((Object)labelLayout);
        Text importAuthorCertPath = new Text(selectionGroup, 2048);
        importAuthorCertPath.setText(this.importingProfile.getProfileItem(0).getKeyLocation());
        importAuthorCertPath.setEditable(false);
        GridData pathLayout = new GridData(768);
        pathLayout.heightHint = 24;
        importAuthorCertPath.setLayoutData((Object)pathLayout);
        Label lImportingDist = new Label(selectionGroup, 0);
        lImportingDist.setText(Messages.DUPLICATE_PROFILE_DLG_DISTRIBUTOR);
        labelLayout = new GridData();
        labelLayout.horizontalIndent = 5;
        lImportingDist.setLayoutData((Object)labelLayout);
        Text importDistCertPath = new Text(selectionGroup, 2048);
        importDistCertPath.setText(this.importingProfile.getProfileItem(1).getKeyLocation());
        importDistCertPath.setEditable(false);
        pathLayout = new GridData(768);
        pathLayout.heightHint = 24;
        importDistCertPath.setLayoutData((Object)pathLayout);
        Button btNoImport = new Button(selectionGroup, 16);
        layoutData = new GridData(769);
        layoutData.horizontalSpan = 2;
        layoutData.verticalIndent = 11;
        btNoImport.setLayoutData((Object)layoutData);
        btNoImport.setText(Messages.DUPLICATE_PROFILE_DLG_KEEP_OLD);
        Label lOrigAuthor = new Label(selectionGroup, 0);
        lOrigAuthor.setText(Messages.DUPLICATE_PROFILE_DLG_AUTHOR);
        labelLayout = new GridData();
        labelLayout.horizontalIndent = 5;
        lOrigAuthor.setLayoutData((Object)labelLayout);
        Text origAuthorCertPath = new Text(selectionGroup, 2048);
        origAuthorCertPath.setText(this.originalProfile.getProfileItem(0).getKeyLocation());
        origAuthorCertPath.setEditable(false);
        pathLayout = new GridData(768);
        pathLayout.heightHint = 24;
        origAuthorCertPath.setLayoutData((Object)pathLayout);
        Label lOrigDist = new Label(selectionGroup, 0);
        lOrigDist.setText(Messages.DUPLICATE_PROFILE_DLG_DISTRIBUTOR);
        labelLayout = new GridData();
        labelLayout.horizontalIndent = 5;
        lOrigDist.setLayoutData((Object)labelLayout);
        Text origDistCertPath = new Text(selectionGroup, 2048);
        origDistCertPath.setText(this.originalProfile.getProfileItem(1).getKeyLocation());
        origDistCertPath.setEditable(false);
        pathLayout = new GridData(768);
        pathLayout.heightHint = 24;
        origDistCertPath.setLayoutData((Object)pathLayout);
        Button btKeepBoth = new Button(selectionGroup, 16);
        layoutData = new GridData(769);
        layoutData.horizontalSpan = 2;
        layoutData.verticalIndent = 11;
        btKeepBoth.setLayoutData((Object)layoutData);
        btKeepBoth.setText(Messages.DUPLICATE_PROFILE_DLG_KEEP_BOTH);
        Label lRename = new Label(selectionGroup, 0);
        lRename.setText(String.valueOf(Messages.DUPLICATE_PROFILE_DLG_KEEP_BOTH_DESC) + "\"" + this.importingProfile.getProfileName() + " (1)\".");
        labelLayout = new GridData();
        labelLayout.horizontalSpan = 2;
        labelLayout.horizontalIndent = 5;
        lRename.setLayoutData((Object)labelLayout);
        btImport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.widget).getSelection()) {
                    DuplicateProfileDialog.this.importSelection = 0;
                }
            }
        });
        btNoImport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.widget).getSelection()) {
                    DuplicateProfileDialog.this.importSelection = 1;
                }
            }
        });
        btKeepBoth.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.widget).getSelection()) {
                    DuplicateProfileDialog.this.importSelection = 2;
                }
            }
        });
    }

    private void applyAllComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 15;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        Button btAskAgain = new Button(composite, 32);
        GridData layoutData = new GridData();
        layoutData.verticalIndent = 11;
        btAskAgain.setLayoutData((Object)layoutData);
        btAskAgain.setText(Messages.DUPLICATE_PROFILE_DLG_APPLY_ALL);
        btAskAgain.setSelection(false);
        btAskAgain.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DuplicateProfileDialog.this.applyAll = ((Button)e.widget).getSelection();
            }
        });
    }

    public int getImportSelection() {
        return this.importSelection;
    }

    public boolean getApplyAll() {
        return this.applyAll;
    }

    protected void okPressed() {
        super.okPressed();
    }
}

