/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sign.ui.dialog;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.tizen.common.sign.ui.CertificateIntroButtonInformation;
import org.tizen.common.sign.ui.dialog.Messages;
import org.tizen.common.ui.font.TizenFonts;
import org.tizen.common.util.ImageUtil;

public class IoTCertificateIntroDialog
extends Dialog {
    public static final int DEFAULT_CERTIFICATE = 1000;
    public static final int EXTENSION_CERTIFICATE = 1001;
    private static final int TITLE_X = 340;
    private static final int TITLE_Y = 35;
    private static final int DEFAULT_SUBJECT_X = 195;
    private static final int EXTENSION_SUBJECT_X = 485;
    private static final int BUTTON_LABEL_Y = 75;
    private static final int DESCRIPTION_Y = 287;
    private static final int DEFAULT_CIRCLE_X = 110;
    private static final int EXTENSION_CIRCLE_X = 400;
    private static final int CIRCLE_Y = 108;
    private static final int CIRCLE_SIZE = 170;
    private static final int CIRCLE_OPACITY = 51;
    private static final int CIRCLE_HOVER_LINE_WIDTH = 6;
    private static final int DESC_TEXT_WRAP_WIDTH = 380;
    private final Font titleFont = TizenFonts.getBoldFont();
    private final Font typeFont = TizenFonts.getFont((int)6, (int)1);
    private final Font descriptionFont = TizenFonts.getNormalFont();
    private final Color white = Display.getCurrent().getSystemColor(1);
    private final Image backgroundImage = ImageUtil.getImage((String)"org.tizen.common.sign.ui", (String)"images/certificate_Intro_bg.png");
    private String defaultProfileLabel = "";
    private String defaultProfileDesc = "";
    private Image defaultProfileNormalImage = null;
    private Image defaultProfileHoverImage = null;
    private Image defaultProfileSelectedImage = null;
    private Image defaultProfileImage = null;
    private String extProfileLabel = "Another service";
    private String extProfileDescription = "";
    private Image extProfileNormalImage = null;
    private Image extProfileHoverImage = null;
    private Image extProfileSelectedImage = null;
    private Image extProfileImage = null;
    private boolean isDefaultImagePushed = false;
    private boolean isExtensionImagePushed = false;

    public IoTCertificateIntroDialog(Shell parentShell, CertificateIntroButtonInformation defaultButton, CertificateIntroButtonInformation extButtonInfo) {
        super(parentShell);
        this.extProfileDescription = extButtonInfo.getDescription();
        this.extProfileNormalImage = extButtonInfo.getNormalImage();
        this.extProfileHoverImage = extButtonInfo.getHoverImage();
        this.extProfileSelectedImage = extButtonInfo.getSelectedImage();
        this.extProfileImage = this.extProfileNormalImage;
        this.defaultProfileLabel = defaultButton.getLabel();
        this.defaultProfileDesc = defaultButton.getDescription();
        this.defaultProfileNormalImage = defaultButton.getNormalImage();
        this.defaultProfileHoverImage = defaultButton.getHoverImage();
        this.defaultProfileSelectedImage = defaultButton.getSelectedImage();
        this.defaultProfileImage = this.defaultProfileNormalImage;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.CERTINFODLG_TITLE);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button closeButton = this.createButton(parent, 12, Messages.CERT_MANAGER_CLOSE, true);
        closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IoTCertificateIntroDialog.this.setReturnCode(64);
                IoTCertificateIntroDialog.this.close();
            }
        });
    }

    protected Control createDialogArea(Composite parent) {
        int compHeight;
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        comp.setLayout((Layout)layout);
        GridData layoutData = new GridData();
        int compWidth = this.backgroundImage.getImageData().width;
        layoutData.heightHint = compHeight = this.backgroundImage.getImageData().height;
        layoutData.widthHint = compWidth;
        comp.setLayoutData((Object)layoutData);
        IoTCertificateIntroDialog.applyDialogFont((Control)comp);
        final Canvas canvas = new Canvas(comp, 0x20000000);
        GridData gridData = new GridData(1808);
        canvas.setLayoutData((Object)gridData);
        canvas.setBackgroundImage(this.backgroundImage);
        canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                GC gc = event.gc;
                gc.setForeground(IoTCertificateIntroDialog.this.white);
                gc.setFont(IoTCertificateIntroDialog.this.titleFont);
                int x = 340 - gc.textExtent((String)Messages.CERTINFODLG_MAIN_DESC).x / 2;
                gc.drawString(Messages.CERTINFODLG_MAIN_DESC, x, 35, true);
                this.drawTypeName(gc, IoTCertificateIntroDialog.this.defaultProfileLabel, 195);
                this.drawTypeName(gc, IoTCertificateIntroDialog.this.extProfileLabel, 485);
                gc.setAntialias(1);
                if (IoTCertificateIntroDialog.this.defaultProfileImage.equals((Object)IoTCertificateIntroDialog.this.defaultProfileHoverImage)) {
                    this.drawCircleLine(gc, 110);
                } else if (IoTCertificateIntroDialog.this.extProfileImage.equals((Object)IoTCertificateIntroDialog.this.extProfileHoverImage)) {
                    this.drawCircleLine(gc, 400);
                }
                if (!IoTCertificateIntroDialog.this.defaultProfileImage.equals((Object)IoTCertificateIntroDialog.this.defaultProfileSelectedImage)) {
                    gc.setAlpha(51);
                }
                this.drawCircle(gc, 110);
                if (!IoTCertificateIntroDialog.this.extProfileImage.equals((Object)IoTCertificateIntroDialog.this.extProfileSelectedImage)) {
                    gc.setAlpha(51);
                }
                this.drawCircle(gc, 400);
                gc.drawImage(IoTCertificateIntroDialog.this.defaultProfileImage, 110, 108);
                gc.drawImage(IoTCertificateIntroDialog.this.extProfileImage, 400, 108);
                if (!IoTCertificateIntroDialog.this.defaultProfileImage.equals((Object)IoTCertificateIntroDialog.this.defaultProfileNormalImage)) {
                    this.drawDescription(gc, event.display, IoTCertificateIntroDialog.this.defaultProfileDesc, 195);
                } else if (!IoTCertificateIntroDialog.this.extProfileImage.equals((Object)IoTCertificateIntroDialog.this.extProfileNormalImage)) {
                    this.drawDescription(gc, event.display, IoTCertificateIntroDialog.this.extProfileDescription, 485);
                }
            }

            private void drawTypeName(GC gc, String typeName, int locationX) {
                gc.setFont(IoTCertificateIntroDialog.this.typeFont);
                int x = locationX - gc.textExtent((String)typeName).x / 2;
                gc.drawText(typeName, x, 75, true);
            }

            private void drawCircleLine(GC gc, int locationX) {
                gc.setLineWidth(6);
                gc.drawOval(locationX + 3, 111, 164, 164);
            }

            private void drawCircle(GC gc, int locationX) {
                gc.fillOval(locationX, 108, 170, 170);
                gc.setAlpha(255);
            }

            private void drawDescription(GC gc, Display display, String desc, int locationX) {
                gc.setFont(IoTCertificateIntroDialog.this.descriptionFont);
                int x = gc.textExtent((String)desc).x;
                TextLayout layout = new TextLayout((Device)display);
                layout.setText(desc);
                if (x > 380) {
                    x = x / (x / 320 + 1) + 60;
                }
                layout.setWidth(x);
                layout.draw(gc, locationX - x / 2, 287);
            }
        });
        canvas.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent event) {
                int x = event.x;
                int y = event.y;
                if (IoTCertificateIntroDialog.this.isDefaultCertImageArea(x, y)) {
                    if (IoTCertificateIntroDialog.this.isExtensionImagePushed) {
                        return;
                    }
                    if (IoTCertificateIntroDialog.this.isDefaultImagePushed) {
                        IoTCertificateIntroDialog.this.defaultProfileImage = IoTCertificateIntroDialog.this.defaultProfileSelectedImage;
                    } else {
                        IoTCertificateIntroDialog.this.defaultProfileImage = IoTCertificateIntroDialog.this.defaultProfileHoverImage;
                    }
                } else if (IoTCertificateIntroDialog.this.isExtensionCertImageArea(x, y)) {
                    if (IoTCertificateIntroDialog.this.isDefaultImagePushed) {
                        return;
                    }
                    if (IoTCertificateIntroDialog.this.isExtensionImagePushed) {
                        IoTCertificateIntroDialog.this.extProfileImage = IoTCertificateIntroDialog.this.extProfileSelectedImage;
                    } else {
                        IoTCertificateIntroDialog.this.extProfileImage = IoTCertificateIntroDialog.this.extProfileHoverImage;
                    }
                } else {
                    IoTCertificateIntroDialog.this.defaultProfileImage = IoTCertificateIntroDialog.this.defaultProfileNormalImage;
                    IoTCertificateIntroDialog.this.extProfileImage = IoTCertificateIntroDialog.this.extProfileNormalImage;
                }
                canvas.redraw();
            }
        });
        canvas.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent event) {
                int x = event.x;
                int y = event.y;
                if (IoTCertificateIntroDialog.this.isDefaultCertImageArea(x, y)) {
                    if (IoTCertificateIntroDialog.this.isDefaultImagePushed) {
                        IoTCertificateIntroDialog.this.setReturnCode(1000);
                        IoTCertificateIntroDialog.this.close();
                    }
                } else if (IoTCertificateIntroDialog.this.isExtensionCertImageArea(x, y) && IoTCertificateIntroDialog.this.isExtensionImagePushed) {
                    IoTCertificateIntroDialog.this.setReturnCode(1001);
                    IoTCertificateIntroDialog.this.close();
                }
                IoTCertificateIntroDialog.this.isDefaultImagePushed = false;
                IoTCertificateIntroDialog.this.isExtensionImagePushed = false;
            }

            public void mouseDown(MouseEvent event) {
                int x = event.x;
                int y = event.y;
                if (IoTCertificateIntroDialog.this.isDefaultCertImageArea(x, y)) {
                    IoTCertificateIntroDialog.this.isDefaultImagePushed = true;
                    IoTCertificateIntroDialog.this.defaultProfileImage = IoTCertificateIntroDialog.this.defaultProfileSelectedImage;
                    canvas.redraw();
                } else if (IoTCertificateIntroDialog.this.isExtensionCertImageArea(x, y)) {
                    IoTCertificateIntroDialog.this.isExtensionImagePushed = true;
                    IoTCertificateIntroDialog.this.extProfileImage = IoTCertificateIntroDialog.this.extProfileSelectedImage;
                    canvas.redraw();
                }
            }
        });
        return comp;
    }

    private boolean isDefaultCertImageArea(int x, int y) {
        return 110 < x && x < 280 && 108 < y && y < 278;
    }

    private boolean isExtensionCertImageArea(int x, int y) {
        return 400 < x && x < 570 && 108 < y && y < 278;
    }

    public boolean close() {
        return super.close();
    }
}

