/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sign.ui.dialog;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.sign.preferences.SigningProfileItem;
import org.tizen.common.sign.ui.CertificateType;
import org.tizen.common.sign.ui.CertificateTypeExtensions;
import org.tizen.common.sign.ui.common.CertificateComposite;
import org.tizen.common.sign.ui.common.CertificateCustomButton;
import org.tizen.common.sign.ui.common.CertificateManagementImages;
import org.tizen.common.sign.ui.dialog.CertificateAdditionDialog;
import org.tizen.common.sign.ui.dialog.IoTCertificateExtensionHandler;
import org.tizen.common.sign.ui.dialog.IoTProfileRemovalListener;
import org.tizen.common.sign.ui.dialog.Messages;
import org.tizen.common.sign.ui.model.CertificateInformation;
import org.tizen.common.sign.util.SigningProfileUtil;
import org.tizen.common.ui.color.TizenColors;
import org.tizen.common.ui.font.TizenFonts;
import org.tizen.common.util.StringUtil;

public class IoTCertificateManageComposite {
    private static final int PROFILE_TABLE_HEIGHT = 95;
    private Composite certComposite;
    private Composite keyComposite;
    private Label lDescription;
    private CertificateCustomButton migrateProfileButton;
    private CertificateCustomButton addProfileButton;
    private CertificateCustomButton removeProfileButton;
    private CertificateCustomButton activeProfileButton;
    private TableViewer profileTable;
    private String selectedProfileName;
    private List<String> profileList;
    private final CertificateManagementImages certificateImages = new CertificateManagementImages();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private IoTCertificateExtensionHandler extensionHandler = new IoTCertificateExtensionHandler();
    private Shell shell = null;

    private Shell getShell() {
        return this.shell;
    }

    public IoTCertificateManageComposite(Shell parentShell, Label lDescription) {
        this.shell = parentShell;
        this.lDescription = lDescription;
        this.loadProfileList();
    }

    public Control createDialogArea(Composite parent) {
        return this.createMainComposite(parent);
    }

    public Composite createMainComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 30;
        layout.marginHeight = 30;
        layout.verticalSpacing = 10;
        composite.setLayout((Layout)layout);
        GridData layoutData = new GridData(1808);
        composite.setLayoutData((Object)layoutData);
        composite.setBackgroundMode(2);
        composite.setBackground(TizenColors.getTizenLightGrey());
        this.createProfileComposite(composite);
        this.createCertificateComposite(composite);
        Canvas separator = new Canvas(parent, 0);
        separator.setBackground(TizenColors.getTizenSmokeGrey());
        GridData separatorData = new GridData(768);
        separatorData.heightHint = 1;
        separator.setLayoutData((Object)separatorData);
        return composite;
    }

    private void createProfileTitleComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        GridData gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        Label lProfile = new Label(composite, 0);
        lProfile.setFont(TizenFonts.getBoldFont());
        lProfile.setText(Messages.CERT_MANAGER_CERT_PROFILE);
        lProfile.setLayoutData((Object)new GridData(768));
        Composite buttonComp = new Composite(composite, 0);
        layout = new GridLayout(4, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 12;
        buttonComp.setLayout((Layout)layout);
        gridData = new GridData(128);
        buttonComp.setLayoutData((Object)gridData);
        this.migrateProfileButton = new CertificateCustomButton(buttonComp, this.certificateImages.PROFILE_MIGRATE[0], this.certificateImages.PROFILE_MIGRATE[1], this.certificateImages.PROFILE_MIGRATE[2], this.certificateImages.PROFILE_MIGRATE[3]);
        GridData layoutData = new GridData(68);
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.grabExcessVerticalSpace = true;
        this.migrateProfileButton.setLayoutData(layoutData);
        this.addProfileButton = new CertificateCustomButton(buttonComp, this.certificateImages.PROFILE_ADD[0], this.certificateImages.PROFILE_ADD[1], this.certificateImages.PROFILE_ADD[2], this.certificateImages.PROFILE_ADD[3]);
        this.addProfileButton.setLayoutData(layoutData);
        this.removeProfileButton = new CertificateCustomButton(buttonComp, this.certificateImages.PROFILE_REMOVE[0], this.certificateImages.PROFILE_REMOVE[1], this.certificateImages.PROFILE_REMOVE[2], this.certificateImages.PROFILE_REMOVE[3]);
        this.removeProfileButton.setLayoutData(layoutData);
        this.activeProfileButton = new CertificateCustomButton(buttonComp, this.certificateImages.PROFILE_ACTIVE[0], this.certificateImages.PROFILE_ACTIVE[1], this.certificateImages.PROFILE_ACTIVE[2], this.certificateImages.PROFILE_ACTIVE[3]);
        this.activeProfileButton.setLayoutData(layoutData);
    }

    private void createProfileListComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackgroundMode(1);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 95;
        composite.setLayoutData((Object)gridData);
        this.profileTable = new TableViewer(composite, 68352);
        GridData data = new GridData(1808);
        this.profileTable.getTable().setLayoutData((Object)data);
        this.profileTable.getTable().setHeaderVisible(false);
        final TableColumn column = new TableColumn(this.profileTable.getTable(), 0);
        this.profileTable.getTable().addListener(11, new Listener(){

            public void handleEvent(Event event) {
                column.setWidth(((IoTCertificateManageComposite)IoTCertificateManageComposite.this).profileTable.getTable().getClientArea().width);
            }
        });
        this.profileTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                IoTCertificateManageComposite.this.selectedProfileName = (String)selection.getFirstElement();
                String cert = null;
                String key = null;
                if (IoTCertificateManageComposite.this.selectedProfileName != null) {
                    cert = IoTCertificateManageComposite.this.selectedProfileName;
                    key = IoTCertificateManageComposite.this.selectedProfileName;
                }
                IoTCertificateManageComposite.this.updateCertComposite(IoTCertificateManageComposite.this.certComposite, cert, false);
                IoTCertificateManageComposite.this.updateCertComposite(IoTCertificateManageComposite.this.keyComposite, key, true);
                IoTCertificateManageComposite.this.activeProfileButton.setEnabled(IoTCertificateManageComposite.this.selectedProfileName != null);
                if (IoTCertificateManageComposite.this.selectedProfileName == null) {
                    return;
                }
            }
        });
        this.profileTable.getTable().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                IoTCertificateManageComposite.this.setActiveProfile();
            }
        });
        this.profileTable.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object element) {
                return ((List)element).toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.profileTable.getTable().addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                if (IoTCertificateManageComposite.this.profileTable.getTable().getItemCount() == 0) {
                    Point textPt = event.gc.textExtent(Messages.CERT_MANAGER_NOPROFILE);
                    int x = (((IoTCertificateManageComposite)IoTCertificateManageComposite.this).profileTable.getTable().getSize().x - textPt.x) / 2;
                    int y = (((IoTCertificateManageComposite)IoTCertificateManageComposite.this).profileTable.getTable().getSize().y - textPt.y) / 2;
                    event.gc.drawString(Messages.CERT_MANAGER_NOPROFILE, x, y, true);
                }
            }
        });
        this.profileTable.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                String profileName = (String)element;
                String activeProfileName = IoTCertificateManageComposite.this.getActiveProfileName();
                if (activeProfileName != null && activeProfileName.equals(profileName)) {
                    return ((IoTCertificateManageComposite)IoTCertificateManageComposite.this).certificateImages.ACTIVE_STATUS;
                }
                return null;
            }

            public String getText(Object element) {
                return (String)element;
            }
        });
    }

    public static int iotServicesCount() {
        List<CertificateType> certificateTypes = CertificateTypeExtensions.getCertificateTypes();
        int count = 0;
        for (CertificateType certType : certificateTypes) {
            if (certType.getProfileType() == null || !certType.getProfileType().equals("IoT Cloud Service")) continue;
            ++count;
        }
        return count;
    }

    private void createProfileComposite(Composite parent) {
        this.createProfileTitleComposite(parent);
        this.createProfileListComposite(parent);
        this.migrateProfileButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent paramMouseEvent) {
                IoTCertificateManageComposite.this.migrateProfile();
            }
        });
        this.activeProfileButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent paramMouseEvent) {
                IoTCertificateManageComposite.this.setActiveProfile();
            }
        });
        this.addProfileButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent paramMouseEvent) {
                try {
                    HashMap<String, String> parameters = new HashMap<String, String>();
                    if (IoTCertificateManageComposite.iotServicesCount() > 1) {
                        parameters.put("command", "execute");
                    } else {
                        parameters.put("command", "defaultPage");
                    }
                    int result = (Integer)IoTCertificateManageComposite.this.extensionHandler.execute(new ExecutionEvent(null, parameters, null, null));
                    if (result == 0) {
                        IoTCertificateManageComposite.this.loadProfileList();
                        IoTCertificateManageComposite.this.setInput();
                    }
                }
                catch (ExecutionException e) {
                    IoTCertificateManageComposite.this.logger.error("Failed to execute certificate creation handler", (Throwable)e);
                }
            }
        });
        this.removeProfileButton.addMouseListener((MouseListener)new IoTProfileRemovalListener(this.profileTable, this.extensionHandler));
        this.removeProfileButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent paramMouseEvent) {
                TableItem[] items = IoTCertificateManageComposite.this.profileTable.getTable().getItems();
                IoTCertificateManageComposite.this.activeProfileButton.setEnabled(items.length > 1);
                IoTCertificateManageComposite.this.removeProfileButton.setEnabled(items.length > 0);
            }
        });
    }

    private String getActiveProfileName() {
        String activeProfileName = null;
        try {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("command", "getActiveCertificate");
            activeProfileName = (String)this.extensionHandler.execute(new ExecutionEvent(null, parameters, null, null));
        }
        catch (ExecutionException e) {
            this.logger.error("Failed to get active certificate", (Throwable)e);
        }
        return activeProfileName;
    }

    private void updateCertComposite(Composite parent, String data, boolean isPrivatekey) {
        Control[] children;
        Control[] controlArray = children = parent.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.dispose();
            ++n2;
        }
        if (data == null) {
            this.createEmptyComposite(parent, false);
        } else if (StringUtil.isEmpty((CharSequence)data)) {
            this.createEmptyComposite(parent, true);
        } else {
            String filePath;
            String certPath = "";
            X509Certificate certInfo = null;
            try {
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.put("command", "getCertPath");
                certPath = (String)this.extensionHandler.execute(new ExecutionEvent(null, parameters, null, null));
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
            if (isPrivatekey) {
                filePath = String.valueOf(certPath) + File.separatorChar + data + File.separatorChar + "privatekey";
            } else {
                filePath = String.valueOf(certPath) + File.separatorChar + data + File.separatorChar + "certificate";
                certInfo = this.loadCertificate(filePath);
            }
            filePath = filePath.substring(filePath.indexOf(new Path(SigningProfileUtil.getUserDataPath()).lastSegment()));
            new CertificateComposite(parent, 0, new CertificateInformation(filePath, certInfo, isPrivatekey));
        }
        parent.setData("data", (Object)data);
        parent.layout(true, true);
    }

    private void createCertificateComposite(Composite parent) {
        Composite composite = new Composite(parent, 2048);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 15;
        layout.marginWidth = 20;
        layout.horizontalSpacing = 32;
        layout.verticalSpacing = 10;
        composite.setLayout((Layout)layout);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 215;
        composite.setLayoutData((Object)gridData);
        this.createTitleComposite(composite);
        this.createCertComposite(composite);
        this.createKeyComposite(composite);
    }

    private void createTitleComposite(Composite parent) {
        Composite authTitleComp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        authTitleComp.setLayout((Layout)layout);
        authTitleComp.setLayoutData((Object)new GridData(768));
        Label lTitle = new Label(authTitleComp, 0);
        lTitle.setFont(TizenFonts.getBoldFont());
        lTitle.setText(Messages.CERT_MANAGER_IOT_CERTIFICATE);
        Composite distTitleComp = new Composite(parent, 0);
        distTitleComp.setLayout((Layout)layout);
        distTitleComp.setLayoutData((Object)new GridData(768));
        lTitle = new Label(distTitleComp, 0);
        lTitle.setFont(TizenFonts.getBoldFont());
        lTitle.setText(Messages.CERT_MANAGER_IOT_PRIVATE_KEY);
    }

    private void createCertComposite(Composite parent) {
        this.certComposite = this.createCertificateDeckComposite(parent);
        new CertificateComposite(this.certComposite, 0);
    }

    private void createEmptyComposite(final Composite parent, boolean needAddButton) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        FormData formData = new FormData();
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        formData.top = new FormAttachment(0);
        formData.bottom = new FormAttachment(100);
        composite.setLayoutData((Object)formData);
        if (!needAddButton) {
            return;
        }
        CertificateCustomButton btAdd = new CertificateCustomButton(composite, this.certificateImages.CERT_ADD[0], this.certificateImages.CERT_ADD[1], this.certificateImages.CERT_ADD[2], this.certificateImages.CERT_ADD[3]);
        GridData layoutData = new GridData(68);
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.grabExcessVerticalSpace = true;
        btAdd.setLayoutData(layoutData);
        btAdd.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent event) {
                Object data = parent.getData("data");
                if (data == null) {
                    return;
                }
                if (data instanceof SigningProfileItem) {
                    SigningProfileItem certificate = (SigningProfileItem)data;
                    CertificateAdditionDialog dlg = new CertificateAdditionDialog(IoTCertificateManageComposite.this.getShell());
                    if (dlg.open() == 0) {
                        certificate.setKeyLocation(dlg.getCertPath());
                        certificate.setPassword(dlg.getCertPasswd().toCharArray());
                        IoTCertificateManageComposite.this.profileTable.setSelection(IoTCertificateManageComposite.this.profileTable.getSelection(), true);
                    }
                }
            }
        });
    }

    private void createKeyComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 4;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.keyComposite = this.createCertificateDeckComposite(composite);
        new CertificateComposite(this.keyComposite, 0);
    }

    private Composite createCertificateDeckComposite(Composite parent) {
        Composite composite = new Composite(parent, 2048);
        composite.setLayout((Layout)new FormLayout());
        GridData layoutData = new GridData(1808);
        layoutData.heightHint = 165;
        layoutData.widthHint = 180;
        composite.setLayoutData((Object)layoutData);
        composite.setBackground(this.getShell().getDisplay().getSystemColor(1));
        return composite;
    }

    public void setInput() {
        if (this.profileList.size() == 0) {
            this.lDescription.setText(Messages.CERT_MANAGER_EMPTY_DESC);
            this.removeProfileButton.setEnabled(false);
            this.activeProfileButton.setEnabled(false);
            this.logger.trace("Profile list is empty");
            return;
        }
        this.lDescription.setText(Messages.CERT_MANAGER_DESC);
        this.activeProfileButton.setEnabled(this.profileList.size() > 1);
        this.removeProfileButton.setEnabled(this.profileList.size() > 0);
        String activeProfileName = this.getActiveProfileName();
        if (activeProfileName == null && !this.profileList.isEmpty()) {
            activeProfileName = this.profileList.get(0);
        }
        this.selectedProfileName = activeProfileName;
        int activeProfileIndex = this.profileList.indexOf(activeProfileName);
        this.profileTable.setInput(this.profileList);
        this.profileTable.getTable().setSelection(activeProfileIndex);
        this.profileTable.setSelection(this.profileTable.getSelection(), true);
    }

    public void migrateProfile() {
        try {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("command", "importCertificate");
            int result = (Integer)this.extensionHandler.execute(new ExecutionEvent(null, parameters, null, null));
            if (result == 0) {
                this.loadProfileList();
                this.setInput();
            }
        }
        catch (ExecutionException e) {
            this.logger.error("Failed to execute certificate creation handler", (Throwable)e);
        }
    }

    private void loadProfileList() {
        try {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("command", "loadCertificates");
            this.profileList = (List)this.extensionHandler.execute(new ExecutionEvent(null, parameters, null, null));
        }
        catch (ExecutionException e) {
            this.logger.error("Failed to update certificates", (Throwable)e);
        }
    }

    private void setActiveProfile() {
        TableItem[] items = this.profileTable.getTable().getSelection();
        if (items.length < 1) {
            return;
        }
        this.selectedProfileName = (String)items[0].getData();
        this.applyActiveProfile();
        this.profileTable.refresh();
    }

    public void close() {
        this.applyActiveProfile();
    }

    private void applyActiveProfile() {
        if (!this.profileList.isEmpty() && this.selectedProfileName != null) {
            try {
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.put("command", "setActiveCertificate");
                parameters.put("certificateName", this.selectedProfileName);
                this.extensionHandler.execute(new ExecutionEvent(null, parameters, null, null));
            }
            catch (ExecutionException e) {
                this.logger.error("Failed to execute certificate creation handler", (Throwable)e);
            }
        }
    }

    private X509Certificate loadCertificate(String filePath) {
        X509Certificate cert = null;
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try (FileInputStream is = new FileInputStream(new File(filePath));){
                CertificateFactory factory = CertificateFactory.getInstance("X.509");
                cert = (X509Certificate)factory.generateCertificate(is);
                cert.checkValidity();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | CertificateException e) {
            e.printStackTrace();
        }
        return cert;
    }
}

