/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sign.ui.wizard;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.sign.signer.TizenIncrementalSigner;
import org.tizen.common.sign.ui.wizard.CertificateBaseWizardPage;
import org.tizen.common.sign.ui.wizard.CertificateCreationWizard;
import org.tizen.common.sign.ui.wizard.Messages;
import org.tizen.common.sign.util.SigningPathUtil;
import org.tizen.common.ui.font.TizenFonts;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.StringUtil;
import signing.CertificateChecker;

public class DistributorCertImportPage
extends CertificateBaseWizardPage {
    private Text textCertPath;
    private Text textPasswd;
    private final int IDX_CERTPATH = 0;
    private final int IDX_PASSWORD = 1;
    private static final Logger logger = LoggerFactory.getLogger(DistributorCertImportPage.class);

    protected DistributorCertImportPage(String pageName) {
        super(pageName);
        this.setDescription(Messages.DIST_CERT_IMPORT_DESC);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new FormLayout());
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 30);
        formData.right = new FormAttachment(100, -30);
        formData.top = new FormAttachment(0, 30);
        Composite firstComp = new Composite(composite, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 14;
        layout.horizontalSpacing = 10;
        firstComp.setLayout((Layout)layout);
        firstComp.setLayoutData((Object)formData);
        Label lCertPath = new Label(firstComp, 0);
        lCertPath.setFont(TizenFonts.getBoldFont());
        lCertPath.setText(Messages.DIST_CERT_IMPORT_CERT_PATH);
        new Label(firstComp, 0);
        this.textCertPath = new Text(firstComp, 2048);
        this.textCertPath.setLayoutData((Object)new GridData(768));
        this.textCertPath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                DistributorCertImportPage.this.validate();
            }
        });
        Button btBrowse = new Button(firstComp, 8);
        btBrowse.setText(Messages.CERT_IMPORT_PAGE_BROWSE);
        GridData layoutData = new GridData();
        layoutData.widthHint = 80;
        btBrowse.setLayoutData((Object)layoutData);
        btBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                FileDialog dlg = new FileDialog(DistributorCertImportPage.this.getShell(), 4096);
                dlg.setFilterExtensions(new String[]{"*.p12"});
                dlg.setFilterPath(SigningPathUtil.getDistributorCertificatePath());
                String filepath = dlg.open();
                if (!StringUtil.isEmpty((CharSequence)filepath)) {
                    DistributorCertImportPage.this.textCertPath.setText(filepath);
                }
            }
        });
        formData = new FormData();
        formData.left = new FormAttachment(0, 30);
        formData.right = new FormAttachment(100, -30);
        formData.top = new FormAttachment((Control)firstComp, 4);
        Label lpathError = this.createErrorLabel(composite);
        lpathError.setLayoutData((Object)formData);
        this.textCertPath.setData("label", (Object)lpathError);
        formData = new FormData();
        formData.left = new FormAttachment(0, 30);
        formData.right = new FormAttachment(100, -30);
        formData.top = new FormAttachment((Control)firstComp, 38);
        Composite secondComp = new Composite(composite, 0);
        layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 14;
        secondComp.setLayout((Layout)layout);
        secondComp.setLayoutData((Object)formData);
        Label lPasswd = new Label(secondComp, 0);
        lPasswd.setFont(TizenFonts.getBoldFont());
        lPasswd.setText(Messages.CERT_IMPORT_PAGE_PASSWD);
        this.textPasswd = new Text(secondComp, 0x400800);
        this.textPasswd.setLayoutData((Object)new GridData(768));
        this.textPasswd.setMessage(Messages.CERT_IMPORT_PAGE_PASSWD_GUIDE);
        this.textPasswd.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                DistributorCertImportPage.this.validate();
            }
        });
        formData = new FormData();
        formData.left = new FormAttachment(0, 30);
        formData.right = new FormAttachment(100, -30);
        formData.top = new FormAttachment((Control)secondComp, 4);
        Label lError = this.createErrorLabel(composite);
        lError.setLayoutData((Object)formData);
        this.textPasswd.setData("label", (Object)lError);
        this.setControl((Control)composite);
    }

    private void setErrorLabel(int index, String message) {
        Label label;
        if (index == 0) {
            label = (Label)this.textCertPath.getData("label");
        } else if (index == 1) {
            label = (Label)this.textPasswd.getData("label");
        } else {
            return;
        }
        label.setText(message);
        label.getParent().layout();
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    public String getCertPath() {
        return this.textCertPath.getText();
    }

    public String getPassword() {
        return this.textPasswd.getText();
    }

    public void validate() {
        boolean validDistCert;
        boolean validPasswd;
        boolean validPath;
        block11: {
            validPath = false;
            validPasswd = false;
            validDistCert = true;
            if (!this.textCertPath.getText().isEmpty()) {
                if (FileUtil.isExist((String)this.textCertPath.getText())) {
                    this.setErrorLabel(0, "");
                    validPath = true;
                } else {
                    this.setErrorLabel(0, Messages.CERT_IMPORT_PAGE_PATH_ERROR);
                    validPath = false;
                }
            } else {
                this.setErrorLabel(0, "");
                validPath = false;
            }
            if (validPath && !this.textPasswd.getText().isEmpty()) {
                try {
                    if (TizenIncrementalSigner.checkCertificatePassword(this.textCertPath.getText(), this.textPasswd.getText())) {
                        this.setErrorLabel(1, "");
                        validPasswd = true;
                        if (CertificateChecker.isAuthorCertificate((String)SigningPathUtil.getRootCertificatePath(), (String)this.textCertPath.getText(), (String)this.textPasswd.getText())) {
                            validDistCert = false;
                            this.setErrorLabel(1, Messages.CERT_IMPORT_PAGE_DISTCERT_ERROR);
                        } else {
                            validDistCert = true;
                            this.setErrorLabel(1, "");
                        }
                        break block11;
                    }
                    this.setErrorLabel(1, Messages.CERT_IMPORT_PAGE_PASSWORD_ERROR);
                    validPasswd = false;
                }
                catch (Exception exception) {
                    logger.warn("Invalid certificate file or incorrect password.");
                }
            } else {
                this.setErrorLabel(1, "");
            }
        }
        ((CertificateCreationWizard)this.getWizard()).setCanFinish(validPath && validPasswd && validDistCert);
        this.getWizard().getContainer().updateButtons();
    }
}

