/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.inject.Inject;
import org.eclipse.e4.ui.css.swt.dom.CTabFolderElement;
import org.eclipse.e4.ui.css.swt.dom.CompositeElement;
import org.eclipse.e4.ui.internal.css.swt.ICTabRendering;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolderRenderer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;

public class Tizen2ndTabRendering
extends CTabFolderRenderer
implements ICTabRendering {
    private static final String CONTAINS_TOOLBAR = "CTabRendering.containsToolbar";
    static final int LEFT_TOP = 0;
    static final int LEFT_BOTTOM = 1;
    static final int RIGHT_TOP = 2;
    static final int RIGHT_BOTTOM = 3;
    static final int OUTER_KEYLINE = 0;
    static final int ITEM_TOP_MARGIN = 2;
    static final int ITEM_BOTTOM_MARGIN = 6;
    static final int ITEM_LEFT_MARGIN = 4;
    static final int ITEM_RIGHT_MARGIN = 4;
    static final int INTERNAL_SPACING = 4;
    int[] shape;
    int cornerSize = 4;
    Color outerKeyline;
    Color[] activeToolbar;
    int[] activePercents;
    Color[] inactiveToolbar;
    int[] inactivePercents;
    boolean active;
    Color[] selectedTabFillColors;
    int[] selectedTabFillPercents;
    Color[] unselectedTabsColors;
    int[] unselectedTabsPercents;
    Color tabOutlineColor;
    int paddingLeft = 0;
    int paddingRight = 0;
    int paddingTop = 0;
    int paddingBottom = 0;
    private CTabFolderRendererWrapper rendererWrapper;
    private CTabFolderWrapper parentWrapper;
    private Color hotUnselectedTabsColorBackground;

    @Inject
    public Tizen2ndTabRendering(CTabFolder parent) {
        super(parent);
        this.parentWrapper = new CTabFolderWrapper(parent);
        this.rendererWrapper = new CTabFolderRendererWrapper(this);
    }

    public void setUnselectedHotTabsColorBackground(Color color) {
        this.hotUnselectedTabsColorBackground = color;
    }

    protected Rectangle computeTrim(int part, int state, int x, int y, int width, int height) {
        int borderTop = 0;
        int borderBottom = 0;
        int marginWidth = this.parent.marginWidth;
        int marginHeight = this.parent.marginHeight;
        switch (part) {
            case -1: {
                if (state == 4) {
                    x = -1 - this.paddingLeft;
                    int tabHeight = this.parent.getTabHeight() + 1;
                    y = y - this.paddingTop - marginHeight - tabHeight - borderTop - this.cornerSize / 4;
                    width = 2 + this.paddingLeft + this.paddingRight;
                    height += this.paddingTop + this.paddingBottom;
                    height += tabHeight + this.cornerSize / 4 + borderBottom + borderTop;
                    break;
                }
                x = x - marginWidth - 0 - this.cornerSize / 2;
                width = width + 0 + 2 * marginWidth + this.cornerSize;
                int tabHeight = this.parent.getTabHeight() + 1;
                if (this.parent.getMinimized()) {
                    y = y - tabHeight - borderTop - 5;
                    height = borderTop + borderBottom + tabHeight;
                    break;
                }
                y = y - marginHeight - tabHeight - borderTop - this.cornerSize / 4;
                height = height + borderBottom + borderTop + 2 * marginHeight + tabHeight + this.cornerSize / 2 + this.cornerSize / 4;
                break;
            }
            case -2: {
                x += 0;
                width += 0;
                break;
            }
            case -3: {
                x = x - 0 - this.cornerSize / 4;
                width = width + 0 + this.cornerSize / 2;
                height = height + borderTop + borderBottom;
                y -= borderTop;
                break;
            }
            default: {
                if (part < 0 || part >= this.parent.getItemCount()) break;
                x -= 4;
                width = width + 4 + 4 + 1;
                y -= 2;
                height = height + 2 + 6;
            }
        }
        return new Rectangle(x, y, width, height);
    }

    protected Point computeSize(int part, int state, GC gc, int wHint, int hHint) {
        wHint += this.paddingLeft + this.paddingRight;
        hHint += this.paddingTop + this.paddingBottom;
        if (part >= 0 && part < this.parent.getItemCount()) {
            gc.setAdvanced(true);
            Point result = super.computeSize(part, state, gc, wHint, hHint);
            return result;
        }
        return super.computeSize(part, state, gc, wHint, hHint);
    }

    protected void dispose() {
        super.dispose();
    }

    protected void draw(int part, int state, Rectangle bounds, GC gc) {
        switch (part) {
            case -4: {
                this.drawCustomBackground(gc, bounds, state);
                return;
            }
            case -1: {
                this.drawTabBody(gc, bounds, state);
                return;
            }
            case -2: {
                this.drawTabHeader(gc, bounds, state);
                return;
            }
        }
        if (part >= 0 && part < this.parent.getItemCount()) {
            gc.setAdvanced(true);
            if (bounds.width == 0 || bounds.height == 0) {
                return;
            }
            if ((state & 2) != 0) {
                this.drawSelectedTab(part, gc, bounds, state);
                super.draw(part, state &= 0xFFFFFFF7, bounds, gc);
            } else {
                this.drawUnselectedTab(part, gc, bounds, state);
                if ((state & 0x20) == 0 && !this.active) {
                    gc.setAlpha(127);
                    super.draw(part, state &= 0xFFFFFFF7, bounds, gc);
                    gc.setAlpha(255);
                } else {
                    super.draw(part, state &= 0xFFFFFFF7, bounds, gc);
                }
            }
            return;
        }
        super.draw(part, state, bounds, gc);
    }

    void drawTabHeader(GC gc, Rectangle bounds, int state) {
        int[] points = new int[1024];
        int index = 0;
        int radius = this.cornerSize / 2;
        int marginWidth = this.parent.marginWidth;
        int marginHeight = this.parent.marginHeight;
        int delta = 0 + 2 * marginWidth;
        int width = bounds.width - delta;
        int height = bounds.height - 0 - 2 * marginHeight;
        int circX = bounds.x + delta / 2 + radius;
        int circY = bounds.y + radius;
        Region clipping = new Region();
        gc.getClipping(clipping);
        Region region = new Region();
        region.add(this.shape);
        region.intersect(clipping);
        gc.setClipping(region);
        Rectangle trim = this.computeTrim(-2, state, 0, 0, 0, 0);
        trim.width = bounds.width - trim.width;
        trim.height = this.parent.getTabHeight() + 4 - trim.height;
        trim.x = -trim.x;
        trim.y = -trim.y;
        this.draw(-4, 0, trim, gc);
        gc.setClipping(clipping);
        clipping.dispose();
        region.dispose();
        int[] ltt = Tizen2ndTabRendering.drawCircle(circX + 1, circY + 1, radius, 0);
        System.arraycopy(ltt, 0, points, index, ltt.length);
        int[] lbb = Tizen2ndTabRendering.drawCircle(circX + 1, circY + height - radius * 2 - 2, radius, 1);
        System.arraycopy(lbb, 0, points, index += ltt.length, lbb.length);
        int[] rb = Tizen2ndTabRendering.drawCircle(circX + width - radius * 2 - 2, circY + height - radius * 2 - 2, radius, 3);
        System.arraycopy(rb, 0, points, index += lbb.length, rb.length);
        int[] rt = Tizen2ndTabRendering.drawCircle(circX + width - radius * 2 - 2, circY + 1, radius, 2);
        System.arraycopy(rt, 0, points, index += rb.length, rt.length);
        index += rt.length;
        points[index++] = points[0];
        points[index++] = points[1];
        int[] tempPoints = new int[index];
        System.arraycopy(points, 0, tempPoints, 0, index);
        if (this.outerKeyline == null) {
            this.outerKeyline = gc.getDevice().getSystemColor(2);
        }
        gc.setForeground(this.outerKeyline);
        if (this.outerKeyline.getRed() == 0 && this.outerKeyline.getGreen() == 138 && this.outerKeyline.getBlue() == 238) {
            gc.drawPolyline(this.shape);
        }
    }

    void drawTabBody(GC gc, Rectangle bounds, int state) {
        int[] points = new int[1024];
        int index = 0;
        int radius = this.cornerSize / 2;
        int marginWidth = this.parent.marginWidth;
        int marginHeight = this.parent.marginHeight;
        int delta = 0 + 2 * marginWidth;
        int width = bounds.width - delta;
        int height = Math.max(this.parent.getTabHeight() + 0, bounds.height - 0 - 2 * marginHeight);
        int circX = bounds.x + delta / 2 + radius;
        int circY = bounds.y + radius;
        index = 0;
        int[] ltt = Tizen2ndTabRendering.drawCircle(circX, circY, radius, 0);
        System.arraycopy(ltt, 0, points, index, ltt.length);
        int[] lbb = Tizen2ndTabRendering.drawCircle(circX, circY + height - radius * 2, radius, 1);
        System.arraycopy(lbb, 0, points, index += ltt.length, lbb.length);
        int[] rb = Tizen2ndTabRendering.drawCircle(circX + width - radius * 2, circY + height - radius * 2, radius, 3);
        System.arraycopy(rb, 0, points, index += lbb.length, rb.length);
        int[] rt = Tizen2ndTabRendering.drawCircle(circX + width - radius * 2, circY, radius, 2);
        System.arraycopy(rt, 0, points, index += rb.length, rt.length);
        index += rt.length;
        points[index++] = circX;
        points[index++] = circY - radius;
        int[] tempPoints = new int[index];
        System.arraycopy(points, 0, tempPoints, 0, index);
        this.shape = tempPoints;
    }

    void drawSelectedTab(int itemIndex, GC gc, Rectangle bounds, int state) {
        int selectionY2;
        int selectionX2;
        int selectionY1;
        int selectionX1;
        if (this.parent.getSingle() && this.parent.getItem(itemIndex).isShowing()) {
            return;
        }
        int width = bounds.width;
        int[] points = new int[1024];
        int index = 0;
        int radius = this.cornerSize / 2;
        int circX = bounds.x + radius;
        int circY = bounds.y - 1 + radius;
        int bottomY = bounds.y + bounds.height;
        if (itemIndex == 0 && bounds.x == -this.computeTrim((int)-2, (int)0, (int)0, (int)0, (int)0, (int)0).x) {
            points[index++] = --circX - radius;
            points[index++] = bottomY;
            points[index++] = selectionX1 = circX - radius;
            points[index++] = selectionY1 = bottomY;
        } else {
            if (this.active) {
                points[index++] = 0;
                points[index++] = bottomY;
            }
            points[index++] = selectionX1 = bounds.x;
            points[index++] = selectionY1 = bottomY;
        }
        int[] ltt = Tizen2ndTabRendering.drawCircle(circX, circY, radius, 0);
        int i = 0;
        while (i < ltt.length / 2) {
            int tmp = ltt[i];
            ltt[i] = ltt[ltt.length - i - 2];
            ltt[ltt.length - i - 2] = tmp;
            tmp = ltt[i + 1];
            ltt[i + 1] = ltt[ltt.length - i - 1];
            ltt[ltt.length - i - 1] = tmp;
            i += 2;
        }
        System.arraycopy(ltt, 0, points, index, ltt.length);
        index += ltt.length;
        int[] rt = Tizen2ndTabRendering.drawCircle(circX + width - radius * 2, circY, radius, 2);
        int i2 = 0;
        while (i2 < rt.length / 2) {
            int tmp = rt[i2];
            rt[i2] = rt[rt.length - i2 - 2];
            rt[rt.length - i2 - 2] = tmp;
            tmp = rt[i2 + 1];
            rt[i2 + 1] = rt[rt.length - i2 - 1];
            rt[rt.length - i2 - 1] = tmp;
            i2 += 2;
        }
        System.arraycopy(rt, 0, points, index, rt.length);
        index += rt.length;
        points[index++] = selectionX2 = bounds.width + circX - radius;
        points[index++] = selectionY2 = bounds.y + bounds.height;
        if (this.active) {
            points[index++] = this.parent.getSize().x - 0;
            points[index++] = bottomY;
        }
        gc.setClipping(0, bounds.y, this.parent.getSize().x - 0, bounds.y + bounds.height);
        if (this.selectedTabFillColors == null) {
            this.setSelectedTabFill(gc.getDevice().getSystemColor(1));
        }
        gc.setBackground(this.selectedTabFillColors[0]);
        gc.setForeground(this.selectedTabFillColors[0]);
        int[] tmpPoints = new int[index];
        System.arraycopy(points, 0, tmpPoints, 0, index);
        gc.fillPolygon(tmpPoints);
        gc.setBackground(gc.getDevice().getSystemColor(1));
        gc.fillRectangle(selectionX1, 0, selectionX2 - selectionX1, selectionY1);
        gc.setForeground(this.selectedTabFillColors[0]);
        gc.drawLine(selectionX1, selectionY1, selectionX2, selectionY2);
        if (this.tabOutlineColor == null) {
            this.tabOutlineColor = gc.getDevice().getSystemColor(2);
        }
        gc.setForeground(this.tabOutlineColor);
        gc.drawLine(tmpPoints[0], tmpPoints[1] - 1, tmpPoints[tmpPoints.length - 2], tmpPoints[1] - 1);
        Rectangle rect = null;
        gc.setClipping(rect);
        if (this.active) {
            if (this.outerKeyline == null) {
                this.outerKeyline = gc.getDevice().getSystemColor(3);
            }
            gc.setForeground(this.outerKeyline);
            if (this.outerKeyline.getRed() == 0 && this.outerKeyline.getGreen() == 138 && this.outerKeyline.getBlue() == 238) {
                gc.drawPolyline(this.shape);
            }
        }
    }

    void drawUnselectedTab(int itemIndex, GC gc, Rectangle bounds, int state) {
        if ((state & 0x20) != 0) {
            int width = bounds.width;
            int[] points = new int[1024];
            int[] inactive = new int[8];
            int index = 0;
            int inactive_index = 0;
            int radius = this.cornerSize / 2;
            int circX = bounds.x + radius;
            int circY = bounds.y - 1 + radius;
            int bottomY = bounds.y + bounds.height;
            int leftIndex = circX;
            if (itemIndex == 0) {
                if (this.parent.getSelectionIndex() != 0) {
                    --leftIndex;
                }
                points[index++] = leftIndex - radius;
                points[index++] = bottomY;
            } else {
                points[index++] = bounds.x;
                points[index++] = bottomY;
            }
            if (!this.active) {
                System.arraycopy(points, 0, inactive, 0, index);
                inactive_index += 2;
            }
            int rightIndex = circX - 1;
            int[] ltt = Tizen2ndTabRendering.drawCircle(leftIndex, circY, radius, 0);
            int i = 0;
            while (i < ltt.length / 2) {
                int tmp = ltt[i];
                ltt[i] = ltt[ltt.length - i - 2];
                ltt[ltt.length - i - 2] = tmp;
                tmp = ltt[i + 1];
                ltt[i + 1] = ltt[ltt.length - i - 1];
                ltt[ltt.length - i - 1] = tmp;
                i += 2;
            }
            System.arraycopy(ltt, 0, points, index, ltt.length);
            index += ltt.length;
            if (!this.active) {
                System.arraycopy(ltt, 0, inactive, inactive_index, 2);
                inactive_index += 2;
            }
            int[] rt = Tizen2ndTabRendering.drawCircle(rightIndex + width - radius * 2, circY, radius, 2);
            int i2 = 0;
            while (i2 < rt.length / 2) {
                int tmp = rt[i2];
                rt[i2] = rt[rt.length - i2 - 2];
                rt[rt.length - i2 - 2] = tmp;
                tmp = rt[i2 + 1];
                rt[i2 + 1] = rt[rt.length - i2 - 1];
                rt[rt.length - i2 - 1] = tmp;
                i2 += 2;
            }
            System.arraycopy(rt, 0, points, index, rt.length);
            index += rt.length;
            if (!this.active) {
                System.arraycopy(rt, rt.length - 4, inactive, inactive_index, 2);
                int n = inactive_index;
                inactive[n] = inactive[n] - 1;
                inactive_index += 2;
            }
            points[index++] = bounds.width + rightIndex - radius;
            points[index++] = bottomY;
            if (!this.active) {
                System.arraycopy(points, index - 2, inactive, inactive_index, 2);
                int n = inactive_index;
                inactive[n] = inactive[n] - 1;
                inactive_index += 2;
            }
            gc.setClipping(points[0], bounds.y, this.parent.getSize().x - 0, bounds.y + bounds.height);
            Color color = this.hotUnselectedTabsColorBackground;
            if (color == null) {
                color = gc.getDevice().getSystemColor(1);
            }
            gc.setBackground(color);
            int[] tmpPoints = new int[index];
            System.arraycopy(points, 0, tmpPoints, 0, index);
            gc.fillPolygon(tmpPoints);
            Color tempBorder = new Color(gc.getDevice(), 182, 188, 204);
            gc.setForeground(tempBorder);
            tempBorder.dispose();
            if (!this.active) {
                gc.drawLine(inactive[0], inactive[1], inactive[2], inactive[3]);
                gc.drawLine(inactive[4], inactive[5], inactive[6], inactive[7]);
            }
            Rectangle rect = null;
            gc.setClipping(rect);
            if (this.outerKeyline == null) {
                this.outerKeyline = gc.getDevice().getSystemColor(2);
            }
        }
    }

    static int[] drawCircle(int xC, int yC, int r, int circlePart) {
        int[] rightAngledPoints = new int[6];
        switch (circlePart) {
            case 0: {
                rightAngledPoints[0] = xC;
                rightAngledPoints[1] = 0;
                rightAngledPoints[2] = xC - r;
                rightAngledPoints[3] = 0;
                rightAngledPoints[4] = xC - r;
                rightAngledPoints[5] = yC;
                return rightAngledPoints;
            }
            case 1: {
                rightAngledPoints[0] = xC - r;
                rightAngledPoints[1] = yC;
                rightAngledPoints[2] = xC - r;
                rightAngledPoints[3] = yC + r;
                rightAngledPoints[4] = xC;
                rightAngledPoints[5] = yC + r;
                return rightAngledPoints;
            }
            case 2: {
                rightAngledPoints[0] = xC + r;
                rightAngledPoints[1] = yC;
                rightAngledPoints[2] = xC + r;
                rightAngledPoints[3] = 0;
                rightAngledPoints[4] = xC;
                rightAngledPoints[5] = 0;
                return rightAngledPoints;
            }
            case 3: {
                rightAngledPoints[0] = xC;
                rightAngledPoints[1] = yC + r;
                rightAngledPoints[2] = xC + r;
                rightAngledPoints[3] = yC + r;
                rightAngledPoints[4] = xC + r;
                rightAngledPoints[5] = yC;
                return rightAngledPoints;
            }
        }
        int x = 0;
        int y = r;
        int u = 1;
        int v = 2 * r - 1;
        int e = 0;
        int[] points = new int[1024];
        int[] pointsMirror = new int[1024];
        int loop = 0;
        int loopMirror = 0;
        while (x < y) {
            if (circlePart == 3) {
                points[loop++] = xC + x;
                points[loop++] = yC + y;
            }
            if (circlePart == 2) {
                points[loop++] = xC + y;
                points[loop++] = yC - x;
            }
            if (circlePart == 0) {
                points[loop++] = xC - x;
                points[loop++] = yC - y;
            }
            if (circlePart == 1) {
                points[loop++] = xC - y;
                points[loop++] = yC + x;
            }
            ++x;
            if (v < 2 * (e += (u += 2))) {
                --y;
                e -= v;
                v -= 2;
            }
            if (x > y) break;
            if (circlePart == 3) {
                pointsMirror[loopMirror++] = xC + y;
                pointsMirror[loopMirror++] = yC + x;
            }
            if (circlePart == 2) {
                pointsMirror[loopMirror++] = xC + x;
                pointsMirror[loopMirror++] = yC - y;
            }
            if (circlePart == 0) {
                pointsMirror[loopMirror++] = xC - y;
                pointsMirror[loopMirror++] = yC - x;
            }
            if (circlePart == 1) {
                pointsMirror[loopMirror++] = xC - x;
                pointsMirror[loopMirror++] = yC + y;
            }
            if (loop + 1 <= points.length) continue;
            int length = points.length * 2;
            int[] newPointTable = new int[length];
            int[] newPointTableMirror = new int[length];
            System.arraycopy(points, 0, newPointTable, 0, points.length);
            points = newPointTable;
            System.arraycopy(pointsMirror, 0, newPointTableMirror, 0, pointsMirror.length);
            pointsMirror = newPointTableMirror;
        }
        int[] finalArray = new int[loop + loopMirror];
        System.arraycopy(points, 0, finalArray, 0, loop);
        int i = loopMirror - 1;
        int j = loop;
        while (i > 0) {
            int tempX;
            int tempY = pointsMirror[i];
            finalArray[j] = tempX = pointsMirror[i - 1];
            finalArray[j + 1] = tempY;
            i -= 2;
            j += 2;
        }
        return finalArray;
    }

    static RGB blend(RGB c1, RGB c2, int ratio) {
        int r = Tizen2ndTabRendering.blend(c1.red, c2.red, ratio);
        int g = Tizen2ndTabRendering.blend(c1.green, c2.green, ratio);
        int b = Tizen2ndTabRendering.blend(c1.blue, c2.blue, ratio);
        return new RGB(r, g, b);
    }

    static int blend(int v1, int v2, int ratio) {
        int b = (ratio * v1 + (100 - ratio) * v2) / 100;
        return Math.min(255, b);
    }

    public Rectangle getPadding() {
        return new Rectangle(this.paddingTop, this.paddingRight, this.paddingBottom, this.paddingLeft);
    }

    public void setPadding(int paddingLeft, int paddingRight, int paddingTop, int paddingBottom) {
        this.paddingLeft = paddingLeft;
        this.paddingRight = paddingRight;
        this.paddingTop = paddingTop;
        this.paddingBottom = paddingBottom;
        this.parent.redraw();
    }

    public void setCornerRadius(int radius) {
        this.parent.redraw();
    }

    public void setShadowVisible(boolean visible) {
        this.parent.redraw();
    }

    public void setShadowColor(Color color) {
        this.parent.redraw();
    }

    public void setOuterKeyline(Color color) {
        this.outerKeyline = color;
        if (color != null) {
            this.setActive(color.getRed() != 255 || color.getGreen() != 255 || color.getBlue() != 255);
        }
        this.parent.redraw();
    }

    public void setSelectedTabFill(Color color) {
        this.setSelectedTabFill(new Color[]{color}, new int[]{100});
    }

    public void setSelectedTabFill(Color[] colors, int[] percents) {
        this.selectedTabFillColors = colors;
        this.selectedTabFillPercents = percents;
        this.parent.redraw();
    }

    public void setUnselectedTabsColor(Color color) {
        this.setUnselectedTabsColor(new Color[]{color}, new int[]{100});
    }

    public void setUnselectedTabsColor(Color[] colors, int[] percents) {
        this.unselectedTabsColors = colors;
        this.unselectedTabsPercents = percents;
        this.parent.redraw();
    }

    public void setTabOutline(Color color) {
        this.tabOutlineColor = color;
        this.parent.redraw();
    }

    public void setInnerKeyline(Color color) {
        this.parent.redraw();
    }

    public void setActiveToolbarGradient(Color[] color, int[] percents) {
        this.activeToolbar = color;
        this.activePercents = percents;
    }

    public void setInactiveToolbarGradient(Color[] color, int[] percents) {
        this.inactiveToolbar = color;
        this.inactivePercents = percents;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    private void drawCustomBackground(GC gc, Rectangle bounds, int state) {
        boolean selected = (state & 2) != 0;
        Color defaultBackground = selected ? this.parent.getSelectionBackground() : this.parent.getBackground();
        boolean vertical = selected ? this.parentWrapper.isSelectionGradientVertical() : this.parentWrapper.isGradientVertical();
        Rectangle partHeaderBounds = this.computeTrim(-2, state, bounds.x, bounds.y, bounds.width, bounds.height);
        this.drawUnselectedTabBackground(gc, partHeaderBounds, state, vertical, defaultBackground);
        this.drawTabBackground(gc, partHeaderBounds, state, vertical, defaultBackground);
        this.drawChildrenBackground(partHeaderBounds);
    }

    private void drawUnselectedTabBackground(GC gc, Rectangle partHeaderBounds, int state, boolean vertical, Color defaultBackground) {
        if (this.unselectedTabsColors == null) {
            boolean selected = (state & 2) != 0;
            this.unselectedTabsColors = selected ? this.parentWrapper.getSelectionGradientColors() : this.parentWrapper.getGradientColors();
            int[] nArray = this.unselectedTabsPercents = selected ? this.parentWrapper.getSelectionGradientPercents() : this.parentWrapper.getGradientPercents();
        }
        if (this.unselectedTabsColors == null) {
            this.unselectedTabsColors = new Color[]{gc.getDevice().getSystemColor(1)};
            this.unselectedTabsPercents = new int[]{100};
        }
        this.rendererWrapper.drawBackground(gc, partHeaderBounds.x, partHeaderBounds.y - 1, partHeaderBounds.width, partHeaderBounds.height, defaultBackground, this.unselectedTabsColors, this.unselectedTabsPercents, vertical);
    }

    private void drawTabBackground(GC gc, Rectangle partHeaderBounds, int state, boolean vertical, Color defaultBackground) {
        Color[] colors = this.selectedTabFillColors;
        int[] percents = this.selectedTabFillPercents;
        if (colors != null && colors.length == 2) {
            colors = new Color[]{colors[1], colors[1]};
        }
        if (colors == null) {
            boolean selected = (state & 2) != 0;
            colors = selected ? this.parentWrapper.getSelectionGradientColors() : this.parentWrapper.getGradientColors();
            int[] nArray = percents = selected ? this.parentWrapper.getSelectionGradientPercents() : this.parentWrapper.getGradientPercents();
        }
        if (colors == null) {
            colors = new Color[]{gc.getDevice().getSystemColor(1)};
            percents = new int[]{100};
        }
        this.rendererWrapper.drawBackground(gc, partHeaderBounds.x, partHeaderBounds.height - 1, partHeaderBounds.width, this.parent.getBounds().height, defaultBackground, colors, percents, vertical);
    }

    private void drawChildrenBackground(Rectangle partHeaderBounds) {
        Control[] controlArray = this.parent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (!CompositeElement.hasBackgroundOverriddenByCSS((Control)control) && this.containsToolbar(control)) {
                this.drawChildBackground((Composite)control, partHeaderBounds);
            }
            ++n2;
        }
    }

    private boolean containsToolbar(Control control) {
        if (control.getData(CONTAINS_TOOLBAR) != null) {
            return true;
        }
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                if (child instanceof ToolBar) {
                    control.setData(CONTAINS_TOOLBAR, (Object)true);
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private void drawChildBackground(Composite composite, Rectangle partHeaderBounds) {
        boolean partOfHeader;
        Rectangle rec = composite.getBounds();
        Color background = null;
        boolean bl = partOfHeader = rec.y >= partHeaderBounds.y && rec.y < partHeaderBounds.height;
        if (!partOfHeader && this.selectedTabFillColors != null) {
            background = this.selectedTabFillColors.length == 2 ? this.selectedTabFillColors[1] : this.selectedTabFillColors[0];
        }
        CTabFolderElement.setBackgroundOverriddenDuringRenderering((Composite)composite, background);
    }

    private static class CTabFolderRendererWrapper
    extends ReflectionSupport<CTabFolderRenderer> {
        private Method drawBackgroundMethod;

        public CTabFolderRendererWrapper(CTabFolderRenderer instance) {
            super(instance);
        }

        public void drawBackground(GC gc, int x, int y, int width, int height, Color defaultBackground, Color[] colors, int[] percents, boolean vertical) {
            if (this.drawBackgroundMethod == null) {
                this.drawBackgroundMethod = this.getMethod("drawBackground", GC.class, int[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Color.class, Image.class, Color[].class, int[].class, Boolean.TYPE);
            }
            Object[] objectArray = new Object[11];
            objectArray[0] = gc;
            objectArray[2] = x;
            objectArray[3] = y;
            objectArray[4] = width;
            objectArray[5] = height;
            objectArray[6] = defaultBackground;
            objectArray[8] = colors;
            objectArray[9] = percents;
            objectArray[10] = vertical;
            this.executeMethod(this.drawBackgroundMethod, objectArray);
        }
    }

    private static class CTabFolderWrapper
    extends ReflectionSupport<CTabFolder> {
        private Field selectionGradientVerticalField;
        private Field gradientVerticalField;
        private Field selectionGradientColorsField;
        private Field selectionGradientPercentsField;
        private Field gradientColorsField;
        private Field gradientPercentsField;

        public CTabFolderWrapper(CTabFolder instance) {
            super(instance);
        }

        public boolean isSelectionGradientVertical() {
            Boolean result;
            if (this.selectionGradientVerticalField == null) {
                this.selectionGradientVerticalField = this.getField("selectionGradientVertical");
            }
            return (result = (Boolean)this.getFieldValue(this.selectionGradientVerticalField)) != null ? result : true;
        }

        public boolean isGradientVertical() {
            Boolean result;
            if (this.gradientVerticalField == null) {
                this.gradientVerticalField = this.getField("gradientVertical");
            }
            return (result = (Boolean)this.getFieldValue(this.gradientVerticalField)) != null ? result : true;
        }

        public Color[] getSelectionGradientColors() {
            if (this.selectionGradientColorsField == null) {
                this.selectionGradientColorsField = this.getField("selectionGradientColorsField");
            }
            return (Color[])this.getFieldValue(this.selectionGradientColorsField);
        }

        public int[] getSelectionGradientPercents() {
            if (this.selectionGradientPercentsField == null) {
                this.selectionGradientPercentsField = this.getField("selectionGradientPercents");
            }
            return (int[])this.getFieldValue(this.selectionGradientPercentsField);
        }

        public Color[] getGradientColors() {
            if (this.gradientColorsField == null) {
                this.gradientColorsField = this.getField("gradientColors");
            }
            return (Color[])this.getFieldValue(this.gradientColorsField);
        }

        public int[] getGradientPercents() {
            if (this.gradientPercentsField == null) {
                this.gradientPercentsField = this.getField("gradientPercents");
            }
            return (int[])this.getFieldValue(this.gradientPercentsField);
        }
    }

    private static class ReflectionSupport<T> {
        private T instance;

        public ReflectionSupport(T instance) {
            this.instance = instance;
        }

        protected Object getFieldValue(Field field) {
            Object value = null;
            if (field != null) {
                boolean accessible = field.isAccessible();
                try {
                    try {
                        field.setAccessible(true);
                        value = field.get(this.instance);
                    }
                    catch (Exception exception) {
                        field.setAccessible(accessible);
                    }
                }
                finally {
                    field.setAccessible(accessible);
                }
            }
            return value;
        }

        protected Field getField(String name) {
            Class<?> cls = this.instance.getClass();
            while (!cls.equals(Object.class)) {
                try {
                    return cls.getDeclaredField(name);
                }
                catch (Exception exception) {
                    cls = cls.getSuperclass();
                }
            }
            return null;
        }

        protected Object executeMethod(Method method, Object ... params) {
            Object value = null;
            if (method != null) {
                boolean accessible = method.isAccessible();
                try {
                    try {
                        method.setAccessible(true);
                        value = method.invoke(this.instance, params);
                    }
                    catch (Exception exception) {
                        method.setAccessible(accessible);
                    }
                }
                finally {
                    method.setAccessible(accessible);
                }
            }
            return value;
        }

        protected Method getMethod(String name, Class<?> ... params) {
            Class<?> cls = this.instance.getClass();
            while (!cls.equals(Object.class)) {
                try {
                    return cls.getDeclaredMethod(name, params);
                }
                catch (Exception exception) {
                    cls = cls.getSuperclass();
                }
            }
            return null;
        }
    }
}

