/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.core.command.EclipseExecutor;
import org.tizen.common.core.command.Executor;
import org.tizen.common.core.command.Prompter;
import org.tizen.common.core.command.prompter.EclipsePrompter;
import org.tizen.common.core.command.prompter.SWTPrompter;
import org.tizen.common.util.DialogUtil;
import org.tizen.common.util.HostUtil;
import org.tizen.library.sdkutils.util.RemoteLogger;
import org.tizen.sdblib.SmartDevelopmentBridge;

public class CommonPlugin
extends AbstractUIPlugin {
    public static final String PRODUCT_NAME = "Certificate Manager";
    private static long startTime;
    private static long endTime;
    private static long usage;
    public static final String PLUGIN_ID = "org.tizen.common";
    private static CommonPlugin plugin;
    protected EclipsePrompter prompter = null;
    protected Executor executor = null;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        startTime = System.currentTimeMillis() / 1000L;
        RemoteLogger.logAccess((String)PRODUCT_NAME);
        this.initializeExecutor();
        this.initializeSmartDeviceBridge();
    }

    public void stop(BundleContext context) throws Exception {
        endTime = System.currentTimeMillis() / 1000L;
        usage = endTime - startTime;
        RemoteLogger.logUsage((String)PRODUCT_NAME, (long)usage);
        this.finalizeSmartDeviceBridge();
        plugin = null;
        super.stop(context);
    }

    public static CommonPlugin getDefault() {
        return plugin;
    }

    public Prompter getPrompter() {
        return this.prompter;
    }

    protected void initializeExecutor() {
        this.prompter = new EclipsePrompter(new SWTPrompter());
        this.executor = new EclipseExecutor(this.prompter);
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    protected void initializeSmartDeviceBridge() {
        String sdbPath = InstallPathConfig.getSDBPath();
        if (!HostUtil.exists(sdbPath)) {
            DialogUtil.openMessageDialog(String.format("There is no %s", sdbPath));
        } else {
            SmartDevelopmentBridge.createBridge((String)sdbPath);
        }
    }

    protected void finalizeSmartDeviceBridge() {
        SmartDevelopmentBridge.disconnectBridge();
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        if (InstallPathConfig.getCertRootPath() != null) {
            store.setDefault("certRootPath", InstallPathConfig.getCertRootPath());
        }
    }
}

