/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.file;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.tizen.common.file.FileHandler;
import org.tizen.common.file.StandardFileHandler;
import org.tizen.common.util.CollectionUtil;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.FilenameUtil;
import org.tizen.common.util.ObjectUtil;

public class EclipseFileHandler
extends StandardFileHandler {
    protected IWorkspaceRoot getWorkspace() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    protected IResource getResource(String path) throws IOException {
        String root = this.getWorkspace().getLocation().toPortableString();
        this.logger.trace("Path :{}, Root :{}", (Object)path, (Object)root);
        File fileChecker = new File(path);
        String relativePath = path;
        if (FilenameUtil.isAncestor(root, path)) {
            relativePath = FilenameUtil.getRelativePath(root, path);
        } else if (fileChecker.isAbsolute()) {
            return null;
        }
        LinkedList<String> fragments = new LinkedList<String>(Arrays.asList(FilenameUtil.getCanonicalFragments(relativePath)));
        String projectName = (String)fragments.remove();
        if (".metadata".equals(projectName)) {
            return null;
        }
        IProject project = this.getWorkspace().getProject(projectName);
        if (fragments.isEmpty()) {
            return project;
        }
        String fileName = CollectionUtil.removeLast(fragments);
        IProject parent = project;
        if (!fragments.isEmpty()) {
            parent = project.getFolder(CollectionUtil.concatenate(fragments, "/"));
        }
        try {
            if (parent.exists()) {
                IResource[] children;
                IResource[] iResourceArray = children = parent.members();
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource chlid = iResourceArray[n2];
                    if (ObjectUtil.equals(fileName, chlid.getName())) {
                        return chlid;
                    }
                    ++n2;
                }
            }
            fragments.add(fileName);
            String relativeFile = CollectionUtil.concatenate(fragments, "/");
            return project.getFile(relativeFile);
        }
        catch (CoreException e) {
            this.logger.warn("Exception :{}", (Throwable)e);
            return null;
        }
    }

    protected IContainer getFolder(String path) {
        String root = this.getWorkspace().getLocation().toPortableString();
        this.logger.trace("Path :{}, Root :{}", (Object)path, (Object)root);
        File fileChecker = new File(path);
        String relativePath = path;
        if (FilenameUtil.isAncestor(root, path)) {
            relativePath = FilenameUtil.getRelativePath(root, path);
        } else if (fileChecker.isAbsolute()) {
            return null;
        }
        LinkedList<String> fragments = new LinkedList<String>(Arrays.asList(FilenameUtil.getCanonicalFragments(relativePath)));
        String projectName = (String)fragments.remove();
        if (".metadata".equals(projectName)) {
            return null;
        }
        IProject project = this.getWorkspace().getProject(projectName);
        if (fragments.isEmpty()) {
            return project;
        }
        String fileName = CollectionUtil.removeLast(fragments);
        IProject parent = project;
        if (!fragments.isEmpty()) {
            parent = project.getFolder(CollectionUtil.concatenate(fragments, "/"));
        }
        try {
            if (parent.exists()) {
                IResource[] children;
                IResource[] iResourceArray = children = parent.members();
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource child = iResourceArray[n2];
                    if (child instanceof IContainer && ObjectUtil.equals(fileName, child.getName())) {
                        return (IContainer)child;
                    }
                    ++n2;
                }
            }
            fragments.add(fileName);
            String relativeFile = CollectionUtil.concatenate(fragments, "/");
            return project.getFolder(relativeFile);
        }
        catch (CoreException e) {
            this.logger.warn("Exception :{}", (Throwable)e);
            return null;
        }
    }

    @Override
    public String getCurrentWorkingDirectory() {
        return this.getWorkspace().getLocation().toPortableString();
    }

    @Override
    public void setCurrentWorkingDirectory(String cwd) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void makeDirectory(String path) throws IOException {
        File file = new File(path);
        if (file.isAbsolute()) {
            super.makeDirectory(path);
            Path p = new Path(path);
            try {
                IFile fileForLocation = this.getWorkspace().getFileForLocation((IPath)p);
                if (fileForLocation != null) {
                    fileForLocation.refreshLocal(-1, (IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (CoreException e) {
                throw new IOException(e);
            }
        }
    }

    @Override
    public void moveDirectory(String source, String target) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void copyDirectory(String source, String target) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeDirectory(String path) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<String> list(String path) throws IOException {
        IContainer folder = this.getFolder(path);
        if (folder == null || !folder.exists()) {
            return super.list(path);
        }
        try {
            IResource[] children = folder.members();
            ArrayList<String> ret = new ArrayList<String>();
            IResource[] iResourceArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IResource child = iResourceArray[n2];
                String childPath = FilenameUtil.getCanonicalForm(child.getLocation().toPortableString());
                if (child instanceof IContainer) {
                    childPath = String.valueOf(childPath) + "/";
                }
                if (childPath.startsWith("/")) {
                    ret.add(childPath.substring(1));
                } else {
                    ret.add(childPath);
                }
                ++n2;
            }
            this.logger.trace("Children :{}", ret);
            return ret;
        }
        catch (CoreException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void write(String path, InputStream out) throws IOException {
        this.logger.trace("Path :{}", (Object)path);
        IResource file = this.getResource(path);
        if (file == null) {
            super.write(path, out);
            return;
        }
        IFile f = (IFile)file.getAdapter(IFile.class);
        try {
            if (f.exists()) {
                f.setContents(out, false, false, (IProgressMonitor)new NullProgressMonitor());
            } else {
                f.create(out, false, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (CoreException e) {
            throw new IOException(e);
        }
    }

    @Override
    public InputStream read(String path) throws IOException {
        Path p = new Path(path);
        IFile eFile = this.getWorkspace().getFileForLocation((IPath)p);
        if (eFile == null) {
            return super.read(path);
        }
        try {
            return eFile.getContents();
        }
        catch (CoreException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void moveFile(String source, String target) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void copyFile(String source, String target) throws IOException {
        FileUtil.copyTo(source, target);
        Path targetPath = new Path(target);
        try {
            IFile fileForLocation;
            IFile file = this.getWorkspace().getFileForLocation((IPath)targetPath);
            if (file != null && (fileForLocation = this.getWorkspace().getFileForLocation((IPath)targetPath)) != null) {
                fileForLocation.refreshLocal(-1, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (CoreException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void removeFile(String path) throws IOException {
        this.logger.trace("Path :{}", (Object)path);
        IResource file = this.getResource(path);
        if (file == null || file.getType() != 1) {
            throw new IOException();
        }
        try {
            file.delete(true, null);
        }
        catch (CoreException e) {
            throw new IOException(e);
        }
    }

    @Override
    public Object get(String path, FileHandler.Attribute name) throws IOException {
        this.logger.trace("Path :{}, Attribute :{}", (Object)path, (Object)name);
        IResource file = this.getResource(path);
        if (file == null) {
            return super.get(path, name);
        }
        if (FileHandler.Attribute.TYPE.equals((Object)name)) {
            if (file instanceof IContainer) {
                return FileHandler.Type.DIRECTORY;
            }
            if (file instanceof IFile) {
                return FileHandler.Type.FILE;
            }
        } else {
            if (FileHandler.Attribute.EXISTS.equals((Object)name)) {
                if (file.exists()) {
                    return true;
                }
                return super.get(path, name);
            }
            if (FileHandler.Attribute.PATH.equals((Object)name)) {
                return file.getLocation().toPortableString();
            }
            if (FileHandler.Attribute.URI.equals((Object)name) || FileHandler.Attribute.URL.equals((Object)name)) {
                return file.getLocationURI().toURL().toString();
            }
            if (FileHandler.Attribute.MODIFIED.equals((Object)name)) {
                return file.getLocalTimeStamp();
            }
            if (FileHandler.Attribute.HIDDEN.equals((Object)name)) {
                return file.isHidden();
            }
            if (FileHandler.Attribute.READABLE.equals((Object)name)) {
                return file.isAccessible();
            }
            if (FileHandler.Attribute.NAME.equals((Object)name)) {
                return file.getName();
            }
            if (FileHandler.Attribute.WRITABLE.equals((Object)name)) {
                return file.isAccessible();
            }
        }
        throw new IOException(String.valueOf(path) + "'s Unknown attribute :" + (Object)((Object)name));
    }

    @Override
    public void set(String path, FileHandler.Attribute name, Object value) throws IOException {
        if (FileHandler.Attribute.QUALIFIED.equals((Object)name)) {
            return;
        }
        throw new UnsupportedOperationException();
    }

    public static void save(StringBuffer buffer, IFile file) throws CoreException {
        String encoding = null;
        try {
            encoding = file.getCharset();
        }
        catch (CoreException coreException) {}
        byte[] bytes = null;
        if (encoding != null) {
            try {
                bytes = buffer.toString().getBytes(encoding);
            }
            catch (Exception exception) {}
        } else {
            bytes = buffer.toString().getBytes();
        }
        ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
        boolean force = true;
        file.setContents((InputStream)stream, force, true, null);
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "@" + Integer.toHexString(this.hashCode()).substring(0, 4);
    }
}

