/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sdb.command;

import org.tizen.common.sdb.command.AbstractAppCommand;
import org.tizen.common.sdb.command.SdbCommandHelper;
import org.tizen.common.sdb.command.message.PkgcmdErrorType;
import org.tizen.common.sdb.command.receiver.PkgCmdReceiver;
import org.tizen.common.ui.view.console.ITizenConsoleManager;
import org.tizen.sdblib.IDevice;

public class ReInstallCommand
extends AbstractAppCommand {
    protected String APP_REINSTALL_COMMAND = "pkgcmd -q -r -t \"%s\" -n \"%s\"";
    protected String pkgType = null;
    protected String pkgId = null;
    protected int timeout = -1;

    public ReInstallCommand(IDevice device, String pkgType, String pkgId, int timeout, ITizenConsoleManager console) {
        this.device = device;
        this.pkgType = pkgType;
        this.pkgId = pkgId;
        this.timeout = timeout;
        this.launchConsole = console;
    }

    @Override
    protected void executeCommand() throws Exception {
        this.helper = new SdbCommandHelper(this.device, this.getConsole(), new PkgCmdReceiver(this.getConsole()));
        this.getConsole().print("Reinstall: ");
        this.helper.runPkgCmd(this.getCommand(), new PkgcmdErrorType(), this.timeout);
    }

    protected String getCommand() {
        String command = String.format(this.APP_REINSTALL_COMMAND, this.getPkgType(), this.getPkgId());
        return command;
    }

    protected String getPkgType() {
        return this.pkgType;
    }

    protected String getPkgId() {
        return this.pkgId;
    }

    protected int getTimeout() {
        return this.timeout;
    }
}

