/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.ui.view.console;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.tizen.common.ui.view.console.TextStyle;
import org.tizen.common.util.MapUtil;
import org.tizen.common.util.SWTUtil;

public class AnsicodeAdapter {
    public static final char ESCAPE = '\u001b';
    public static final Color BLACK = new Color((Device)SWTUtil.getDisplay(), 0, 0, 0);
    public static final Color RED = new Color((Device)SWTUtil.getDisplay(), 255, 0, 0);
    public static final Color GREEN = new Color((Device)SWTUtil.getDisplay(), 0, 255, 0);
    public static final Color YELLOW = new Color((Device)SWTUtil.getDisplay(), 255, 255, 0);
    public static final Color BLUE = new Color((Device)SWTUtil.getDisplay(), 0, 0, 255);
    public static final Color MAGENTA = new Color((Device)SWTUtil.getDisplay(), 255, 0, 255);
    public static final Color CYAN = new Color((Device)SWTUtil.getDisplay(), 0, 255, 255);
    public static final Color WHITE = new Color((Device)SWTUtil.getDisplay(), 255, 255, 255);
    public static final Color INTENSE_BLACK = new Color((Device)SWTUtil.getDisplay(), 0, 0, 0);
    public static final Color INTENSE_RED = new Color((Device)SWTUtil.getDisplay(), 139, 0, 0);
    public static final Color INTENSE_GREEN = new Color((Device)SWTUtil.getDisplay(), 0, 100, 0);
    public static final Color INTENSE_YELLOW = new Color((Device)SWTUtil.getDisplay(), 250, 250, 210);
    public static final Color INTENSE_BLUE = new Color((Device)SWTUtil.getDisplay(), 0, 0, 139);
    public static final Color INTENSE_MAGENTA = new Color((Device)SWTUtil.getDisplay(), 139, 0, 139);
    public static final Color INTENSE_CYAN = new Color((Device)SWTUtil.getDisplay(), 0, 139, 139);
    public static final Color INTENSE_WHITE = new Color((Device)SWTUtil.getDisplay(), 245, 245, 245);
    public static final Map<Integer, Color[]> CODE2COLOR = Collections.unmodifiableMap(MapUtil.asMap(new Object[][]{{30, new Color[]{INTENSE_BLACK, BLACK}}, {31, new Color[]{INTENSE_RED, RED}}, {32, new Color[]{INTENSE_GREEN, GREEN}}, {33, new Color[]{INTENSE_YELLOW, YELLOW}}, {34, new Color[]{INTENSE_BLUE, BLUE}}, {35, new Color[]{INTENSE_MAGENTA, MAGENTA}}, {36, new Color[]{INTENSE_CYAN, CYAN}}, {37, new Color[]{INTENSE_WHITE, WHITE}}, {40, new Color[]{INTENSE_BLACK, BLACK}}, {41, new Color[]{INTENSE_RED, RED}}, {42, new Color[]{INTENSE_GREEN, GREEN}}, {43, new Color[]{INTENSE_YELLOW, YELLOW}}, {44, new Color[]{INTENSE_BLUE, BLUE}}, {45, new Color[]{INTENSE_MAGENTA, MAGENTA}}, {46, new Color[]{INTENSE_CYAN, CYAN}}, {47, new Color[]{INTENSE_WHITE, WHITE}}}));
    private static int[] commands = new int[]{109, 110};

    private static List<TextStyle> parseAnsiString(String ansiString) {
        char command = '\u0000';
        ArrayList<TextStyle> styles = new ArrayList<TextStyle>();
        int arrayIndex = 0;
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < ansiString.length()) {
            if (ansiString.charAt(i) == '\u001b') {
                int min = ansiString.length() - 1;
                int startCommand = 0;
                int j = 0;
                while (j < commands.length) {
                    startCommand = ansiString.indexOf(commands[j], i);
                    if (min > startCommand && startCommand > -1) {
                        min = startCommand;
                    }
                    ++j;
                }
                command = ansiString.charAt(min);
                startCommand = min;
                if (startCommand < ansiString.length()) {
                    String colorCodes = ansiString.substring(i + 2, startCommand);
                    String[] codes = colorCodes.split(";");
                    Color[] colors = AnsicodeAdapter.getColorAttribute(codes);
                    int styleStart = startCommand + 1;
                    int styleEnd = 0;
                    int endEscape = ansiString.indexOf(27, styleStart);
                    if (endEscape < 0) {
                        styleEnd = ansiString.length();
                        i = ansiString.length();
                    } else {
                        int endCommand = ansiString.indexOf(command, endEscape);
                        if (endCommand < 0) {
                            styleEnd = ansiString.length();
                            i = ansiString.length();
                        } else {
                            styleEnd = endEscape;
                            i = endCommand;
                        }
                    }
                    String styleString = null;
                    styleString = ansiString.substring(styleStart, styleEnd);
                    TextStyle styleTs = new TextStyle(colors[0], colors[1], styleString);
                    if (sb.length() > 0) {
                        TextStyle defaultTs = new TextStyle(BLACK, WHITE, sb.toString());
                        styles.add(arrayIndex++, defaultTs);
                        sb.setLength(0);
                    }
                    styles.add(arrayIndex++, styleTs);
                }
            } else {
                sb.append(ansiString.charAt(i));
            }
            ++i;
        }
        if (sb.length() > 0) {
            TextStyle defaultTs = new TextStyle(BLACK, WHITE, sb.toString());
            styles.add(arrayIndex, defaultTs);
        }
        return styles;
    }

    private static Color[] getColorAttribute(String[] codes) {
        boolean brighter = false;
        Color[] color = new Color[]{BLACK, WHITE};
        int j = 0;
        while (j < codes.length) {
            if (codes[j].length() > 0 && codes[j].matches("[\\d]*")) {
                int code = Integer.parseInt(codes[j]);
                if (code == 0) {
                    brighter = false;
                } else if (code == 1) {
                    brighter = true;
                } else if (code >= 30 && code <= 39) {
                    if (code == 39) {
                        color[0] = BLACK;
                    } else if (code >= 30 && code <= 37) {
                        color[0] = AnsicodeAdapter.getColorFromANSICode(code, brighter);
                        brighter = false;
                    }
                } else if (code >= 40 && code <= 49) {
                    if (code == 49) {
                        color[1] = WHITE;
                    } else if (code >= 40 && code <= 47) {
                        color[1] = AnsicodeAdapter.getColorFromANSICode(code, brighter);
                    }
                }
            }
            ++j;
        }
        return color;
    }

    private static Color getColorFromANSICode(int code, boolean brighter) {
        Color[] colorSet = CODE2COLOR.get(code);
        if (colorSet == null) {
            return null;
        }
        return colorSet[brighter ? 0 : 1];
    }

    public static String getStripAnsiString(String newLineStr) {
        List<TextStyle> styles = AnsicodeAdapter.parseAnsiString(newLineStr);
        StringBuilder sb = new StringBuilder();
        for (TextStyle style : styles) {
            sb.append(style.getStripString());
        }
        return sb.toString();
    }

    public static List<TextStyle> getStringStyles(String newLineStr) {
        List<TextStyle> styles = AnsicodeAdapter.parseAnsiString(newLineStr);
        return styles;
    }
}

