/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.tizen.common.util.OSChecker;
import org.tizen.common.util.StringUtil;

public class ValidationUtil {
    private static final String REGEX_IRI = "([a-z]([a-z]|\\d|\\+|-|\\.)*):(\\/\\/(((([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&'\\(\\)\\*\\+,;=]|:)*@)?((\\[(|(v[\\da-f]{1,}\\.(([a-z]|\\d|-|\\.|_|~)|[!\\$&'\\(\\)\\*\\+,;=]|:)+))\\])|((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5]))|(([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&'\\(\\)\\*\\+,;=])*)(:\\d*)?)(\\/(([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&'\\(\\)\\*\\+,;=]|:|@)*)*|(\\/((([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&'\\(\\)\\*\\+,;=]|:|@)+(\\/(([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&'\\(\\)\\*\\+,;=]|:|@)*)*)?)|((([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&'\\(\\)\\*\\+,;=]|:|@)+(\\/(([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&'\\(\\)\\*\\+,;=]|:|@)*)*)|((([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&'\\(\\)\\*\\+,;=]|:|@)){0})(\\?((([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&'\\(\\)\\*\\+,;=]|:|@)|[\\uE000-\\uF8FF]|\\/|\\?)*)?(\\#((([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&'\\(\\)\\*\\+,;=]|:|@)|\\/|\\?)*)?";
    private static final String REGEX_EMAIL = "[A-Za-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[A-Za-z0-9!#$%&'*+/=?^_`{|}~-]+)*@(?:[A-Za-z0-9](?:[A-Za-z0-9-]*[A-Za-z0-9])?\\.)+[A-Za-z0-9](?:[A-Za-z0-9-]*[A-Za-z0-9])??";
    private static final String REGEX_URL = "\\b(https?)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]";
    private static final String REGEX_FILEURI = "([a-zA-Z0-9\\-_\\.!\\~\\*'\\(\\);\\?\\@\\&=\\+$,]|(%[a-fA-F0-9]{2}))*";
    private static final String REGEX_VERSION = "[0-9]{1,3}\\.[0-9]{1,3}(\\.[0-9]{1,5})?";
    private static final String REGEX_REQUIRED_VERSION = "[0-9]{1,}\\.[0-9]{1,}(\\.[0-9]{1,})?(\\.[0-9]{1,})?";
    private static final String REGEX_REQUIRED_VERSION_2DIGIT = "[0-9]{1,}\\.[0-9]{1,}";
    private static final String REGEX_APPWIDGETID = "[0-9a-zA-Z]{10}\\.[0-9a-zA-Z]{1,52}\\.[0-9a-zA-Z]{1,}";
    private static final String REGEX_IPADDRESS = "^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])$";
    private static final String REGEX_PORT = "^(6553[0-5]|655[0-2]\\d|65[0-4]\\d\\d|6[0-4]\\d{3}|[1-5]\\d{4}|[1-9]\\d{0,3}|0)$";
    private static final String REGEX_APPLICATIONID = "[0-9a-zA-Z]{10}\\.[0-9a-zA-Z]{1,52}";
    public static final String REGEX_PRIVILEGE = "([a-z]|[A-Z]|[0-9]|/|:|\\.|-|_)*";
    private static final String REGEX_UBUNTU_FILE_PATH = "([/])?(/[a-zA-Z0-9-\\s_.-]+)+";
    private static final String REGEX_WINDOW_FILE_PATH = "([a-zA-Z]:)?(\\\\[a-zA-Z0-9-\\s_.-]+)+";
    public static final String[] WIDGET_CONTENT_FILE_EXTENSIONS = new String[]{".html", ".htm", ".xhtml", ".xht", ".svg"};
    public static final String[] WIDGET_ICON_FILE_EXTENSIONS = new String[]{".png", ".gif", ".jpg", ".ico"};
    public static final String[] WIDGET_ICON_FILTER_EXTENSIONS = new String[]{"*.png;*.gif;*.jpg;*.ico;"};
    public static final String[] SERVICE_CONTENT_FILE_EXTENSION = new String[]{".js"};
    public static final String[] WARNING_SCREENSIZE_FEATURES = new String[]{"http://tizen.org/feature/screen.size.all", "http://tizen.org/feature/screen.size.normal"};
    public static final String ASTERISK = "*";

    public static boolean checkForEmail(String value) {
        Pattern pattern = Pattern.compile(REGEX_EMAIL);
        Matcher matcher = pattern.matcher(value);
        return matcher.matches();
    }

    public static boolean checkForIRI(String value) {
        Pattern pattern = Pattern.compile(REGEX_IRI, 2);
        Matcher matcher = pattern.matcher(value);
        return matcher.matches();
    }

    public static boolean checkForURL(String value) {
        Pattern pattern = Pattern.compile(REGEX_URL);
        Matcher matcher = pattern.matcher(value);
        return matcher.matches();
    }

    public static boolean checkForFileURI(String value) {
        Pattern pattern = Pattern.compile(REGEX_FILEURI);
        Matcher matcher = pattern.matcher(value);
        return matcher.matches();
    }

    public static boolean checkForFilePathURI(String value) {
        Pattern pattern = null;
        Matcher matcher = null;
        pattern = OSChecker.isWindows() ? Pattern.compile(REGEX_WINDOW_FILE_PATH) : Pattern.compile(REGEX_UBUNTU_FILE_PATH);
        matcher = pattern.matcher(value);
        if (matcher.matches()) {
            return true;
        }
        pattern = Pattern.compile(REGEX_URL);
        matcher = pattern.matcher(value);
        return matcher.matches();
    }

    public static boolean checkForIconSrc(String value) {
        return value.contains(":");
    }

    public static boolean checkForServiceId(String value) {
        Pattern pattern = Pattern.compile(REGEX_APPLICATIONID);
        Matcher matcher = pattern.matcher(value);
        return matcher.matches();
    }

    public static boolean checkForFileExtension(String value, String[] extensions) {
        if (StringUtil.isEmpty(value) || extensions == null) {
            return false;
        }
        if (value.startsWith(".")) {
            return false;
        }
        String[] stringArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            String ext = stringArray[n2];
            if (value.toLowerCase().endsWith(ext)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean checkForVersion(String version) {
        if (version == null || StringUtil.isEmpty(version)) {
            return false;
        }
        Pattern pattern = Pattern.compile(REGEX_VERSION);
        Matcher matcher = pattern.matcher(version);
        if (matcher.matches()) {
            String[] versions = version.split("\\.");
            if (versions.length < 3) {
                return false;
            }
            int index = 0;
            while (index < 2) {
                int xy = Integer.parseInt(versions[index]);
                if (xy < 0 || 255 < xy) {
                    return false;
                }
                ++index;
            }
            int z = Integer.parseInt(versions[2]);
            return z >= 0 && 65535 >= z;
        }
        return false;
    }

    public static boolean checkForRequiredVersion2Digit(String version) {
        if (version == null || StringUtil.isEmpty(version)) {
            return false;
        }
        Pattern pattern = Pattern.compile(REGEX_REQUIRED_VERSION_2DIGIT);
        Matcher matcher = pattern.matcher(version);
        return matcher.matches();
    }

    public static boolean checkForRequiredVersion(String version) {
        if (version == null || StringUtil.isEmpty(version)) {
            return false;
        }
        Pattern pattern = Pattern.compile(REGEX_REQUIRED_VERSION);
        Matcher matcher = pattern.matcher(version);
        return matcher.matches();
    }

    public static boolean checkForDynamicBoxId(String id) {
        Pattern pattern = Pattern.compile(REGEX_APPWIDGETID);
        Matcher matcher = pattern.matcher(id);
        return matcher.matches();
    }

    public static boolean checkForIP(String ip) {
        Pattern pattern = Pattern.compile(REGEX_IPADDRESS);
        Matcher matcher = pattern.matcher(ip);
        return matcher.matches();
    }

    public static boolean checkForPort(String port) {
        Pattern pattern = Pattern.compile(REGEX_PORT);
        Matcher matcher = pattern.matcher(port);
        return matcher.matches();
    }

    public static boolean checkForWidgetIconFileExtension(String iconFileName) {
        return ValidationUtil.checkForFileExtension(iconFileName, WIDGET_ICON_FILE_EXTENSIONS);
    }

    public static boolean checkForWidgetContentFileExtension(String contentFileName) {
        return ValidationUtil.checkForFileExtension(contentFileName, WIDGET_CONTENT_FILE_EXTENSIONS);
    }

    public static boolean checkForServiceContentFileExtension(String contentFileName) {
        return ValidationUtil.checkForFileExtension(contentFileName, SERVICE_CONTENT_FILE_EXTENSION);
    }

    public static boolean checkForWarningFeature(String featureName) {
        String[] stringArray = WARNING_SCREENSIZE_FEATURES;
        int n = WARNING_SCREENSIZE_FEATURES.length;
        int n2 = 0;
        while (n2 < n) {
            String feature = stringArray[n2];
            if (feature.equalsIgnoreCase(featureName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean checkForAccessOrigin(String origin) {
        return ASTERISK.equals(origin) || ValidationUtil.checkForURL(origin);
    }

    public static boolean checkForPrivilege(String privilege) {
        Pattern pattern = Pattern.compile(REGEX_PRIVILEGE);
        Matcher matcher = pattern.matcher(privilege);
        return matcher.matches();
    }
}

