/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.util.cache;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Widget;
import org.tizen.common.util.ArrayUtil;
import org.tizen.common.util.SWTUtil;
import org.tizen.common.util.cache.OneFont;

public class FontCache {
    private static List<OneFont> _existing = new ArrayList<OneFont>();

    public static synchronized void disposeAll() {
        SWTUtil.tryDispose(_existing.toArray(new Widget[0]));
        _existing.clear();
    }

    public static synchronized Font getFont(FontData fd) {
        OneFont of2;
        if (fd == null) {
            return null;
        }
        boolean disposed = false;
        OneFont toRemove = null;
        for (OneFont of2 : _existing) {
            if (!of2.matches(fd)) continue;
            if (of2.getFont().isDisposed()) {
                disposed = true;
                toRemove = of2;
                break;
            }
            return of2.getFont();
        }
        if (disposed) {
            _existing.remove(toRemove);
        }
        of2 = new OneFont(fd);
        _existing.add(of2);
        return of2.getFont();
    }

    public static synchronized int getCount() {
        return _existing.size();
    }

    public static Font getFont(Font font) {
        if (font == null || font.isDisposed()) {
            return null;
        }
        FontData fd = ArrayUtil.pickupFirst(font.getFontData());
        return FontCache.getFont(fd);
    }

    public static synchronized Font getFont(String fontName, int height, int style) {
        OneFont of2;
        if (fontName == null) {
            return null;
        }
        boolean disposed = false;
        OneFont toRemove = null;
        for (OneFont of2 : _existing) {
            if (!of2.getName().equals(fontName) || of2.getHeight() != height || of2.getStyle() != style) continue;
            if (of2.getFont().isDisposed()) {
                disposed = true;
                toRemove = of2;
                break;
            }
            return of2.getFont();
        }
        if (disposed) {
            _existing.remove(toRemove);
        }
        of2 = new OneFont(fontName, height, style);
        _existing.add(of2);
        return of2.getFont();
    }
}

