#!/bin/bash -x
## User Define for desktop menu
desktopfile="${HOME}/.local/share/applications/tizen-studio-certificatemanager.desktop"
iconfile=tizen_certificate_manager.ico
cert_path=tools/certificate-manager
exefile=certificate-manager
comment="Tizen Certificate Manager"
name="Certificate Manager"

## Do not modify the followings (Make desktop menu)
TIZEN_SDK_INSTALL_PATH="${INSTALLED_PATH}"
exepath="$TIZEN_SDK_INSTALL_PATH/${cert_path}/$exefile"
cert_resources_path="${TIZEN_SDK_INSTALL_PATH}/${cert_path}/resources"
cert_icons_path=${cert_resources_path}/icons
categoryfile="${MENU_DIRECTORY_PATH}"

## Register start menu
if [ -e "${MAKESHORTCUT_PATH}" ]
then
    "${MAKESHORTCUT_PATH}" -f "${desktopfile}" -e "${exepath}" -i "${cert_icons_path}/${iconfile}" -n "${name}" -c "${comment}"
fi

exit 0
