/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.sdblib;

import java.io.IOException;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.tizen.sdblib.Device;
import org.tizen.sdblib.SdbHelper;
import org.tizen.sdblib.SmartDevelopmentBridge;
import org.tizen.sdblib.exception.SdbCommandRejectedException;
import org.tizen.sdblib.exception.TimeoutException;

public class PlatformCapability {
    private static final String KEY_SECURE_PROTOCOL = "secure_protocol";
    private static final String KEY_ROOTCMD_SUPPORT = "rootcmd_support";
    private static final String KEY_ZONE_SUPPORT = "zone_support";
    private static final String KEY_MULTIUSER_SUPPORT = "multiuser_support";
    private static final String KEY_CPU_ARCH = "cpu_arch";
    private static final String KEY_PROFILE_NAME = "profile_name";
    private static final String KEY_VENDOR_NAME = "vendor_name";
    private static final String KEY_DEVICE_NAME = "device_name";
    private static final String KEY_CANLAUNCH = "can_launch";
    private static final String KEY_PLATFORM_VERSION = "platform_version";
    private static final String KEY_PRODUCT_VERSION = "product_version";
    private static final String KEY_SDBD_VERSION = "sdbd_version";
    private static final String KEY_ROOTONOFF_SUPPORT = "rootonoff_support";
    private static final String KEY_SDBD_ROOTPERM = "sdbd_rootperm";
    private static final String KEY_SDK_TOOLPATH = "sdk_toolpath";
    private static final String KEY_PKGCMD_DEBUGMODE = "pkgcmd_debugmode";
    private static final String KEY_APPCMD_SUPPORT = "appcmd_support";
    private static final String KEY_DUID = "duid";
    private static final String KEY_APPID2PID_SUPPORT = "appid2pid_support";
    public static final String ENABLED = "enabled";
    public static final String DISABLED = "disabled";
    public static final String UNKNOWN = "unknown";
    private HashMap<String, String> map = new HashMap();
    private Device mDevice;
    private static final int CAPBUF_SIZE = 4096;
    private static final String PAIR_DELIM = "\n";
    private static final String KEY_VALUE_DELIM = ":";

    public PlatformCapability(Device device) throws TimeoutException, SdbCommandRejectedException, IOException {
        this.mDevice = device;
        this.loadPlatformCapability();
    }

    private void loadPlatformCapability() throws TimeoutException, SdbCommandRejectedException, IOException {
        byte[] reqBytes = SdbHelper.sendServiceRequest(SmartDevelopmentBridge.getBridge(), this.mDevice, "capability:", 4096);
        byte[] tmpByte = new byte[4096];
        int len = 0;
        len = ((reqBytes[1] & 0xFF) << 8) + (reqBytes[0] & 0xFF);
        if (len > 4095) {
            len = 4095;
        }
        System.arraycopy(reqBytes, 2, tmpByte, 0, len);
        String capString = SdbHelper.replyToString(tmpByte).trim();
        StringTokenizer capStringTokenizer = new StringTokenizer(capString, PAIR_DELIM);
        while (capStringTokenizer.hasMoreTokens()) {
            StringTokenizer pairTokenizer = new StringTokenizer(capStringTokenizer.nextToken(), KEY_VALUE_DELIM);
            String key = pairTokenizer.nextToken();
            String value = pairTokenizer.nextToken();
            this.map.put(key, value);
        }
    }

    private String getCapabilityMapValue(String key) {
        String ret = this.map.get(key);
        if (ret == null) {
            return UNKNOWN;
        }
        return ret;
    }

    public String getSecureProtocol() {
        return this.getCapabilityMapValue(KEY_SECURE_PROTOCOL);
    }

    public String getRootcmdSupport() {
        return this.getCapabilityMapValue(KEY_ROOTCMD_SUPPORT);
    }

    public String getZoneSupport() {
        return this.getCapabilityMapValue(KEY_ZONE_SUPPORT);
    }

    public String getMultiuserSupport() {
        return this.getCapabilityMapValue(KEY_MULTIUSER_SUPPORT);
    }

    public String getCpuArch() {
        return this.getCapabilityMapValue(KEY_CPU_ARCH);
    }

    public String getProfileName() {
        return this.getCapabilityMapValue(KEY_PROFILE_NAME);
    }

    public String getVendorName() {
        return this.getCapabilityMapValue(KEY_VENDOR_NAME);
    }

    public String getDeviceName() throws TimeoutException, SdbCommandRejectedException, IOException {
        this.loadPlatformCapability();
        return this.getCapabilityMapValue(KEY_DEVICE_NAME);
    }

    public String getCanLaunch() {
        return this.getCapabilityMapValue(KEY_CANLAUNCH);
    }

    public String getPlatformVersion() {
        return this.getCapabilityMapValue(KEY_PLATFORM_VERSION);
    }

    public String getProductVersion() {
        return this.getCapabilityMapValue(KEY_PRODUCT_VERSION);
    }

    public String getSdbdVersion() {
        return this.getCapabilityMapValue(KEY_SDBD_VERSION);
    }

    public String getRootOnOffSupport() {
        return this.getCapabilityMapValue(KEY_ROOTONOFF_SUPPORT);
    }

    public String getSdbdRootPerm() {
        return this.getCapabilityMapValue(KEY_SDBD_ROOTPERM);
    }

    public String getSdkToolPath() {
        return this.getCapabilityMapValue(KEY_SDK_TOOLPATH);
    }

    public String getPkgcmdDebugModeSupport() {
        String ret = this.getCapabilityMapValue(KEY_PKGCMD_DEBUGMODE);
        if (UNKNOWN.equals(ret)) {
            if ("0.1".equals(this.mDevice.getAppCmdProtocolVersion())) {
                return ENABLED;
            }
            return DISABLED;
        }
        return ret;
    }

    public String getAppCmdSupport() {
        return this.getCapabilityMapValue(KEY_APPCMD_SUPPORT);
    }

    public String getDUID() {
        return this.getCapabilityMapValue(KEY_DUID);
    }

    public String getAppid2pidSupport() {
        String ret = this.getCapabilityMapValue(KEY_APPID2PID_SUPPORT);
        if (UNKNOWN.equals(ret)) {
            if ("0.1".equals(this.mDevice.getAppCmdProtocolVersion())) {
                return ENABLED;
            }
            return DISABLED;
        }
        return ret;
    }
}

