/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.sdblib.dlog;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.regex.Pattern;
import org.tizen.sdblib.dlog.DlogInfo;
import org.tizen.sdblib.dlog.IDlogParser;
import org.tizen.sdblib.util.LogLevel;
import org.tizen.sdblib.util.StringUtil;

public class DlogTimeParser
implements IDlogParser {
    private static final Pattern pattern = Pattern.compile("(\\d{2}-\\d{2}\\s\\d{2}:\\d{2}:\\d{2})\\.?\\d*\\+?\\d*\\s+(V|D|I|W|E|F)/.*\\(\\s?(\\d+)\\):\\s(.*)");

    @Override
    public DlogInfo[] parse(String ... lines) {
        ArrayList<DlogInfo> infos = new ArrayList<DlogInfo>();
        DlogInfo info = null;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String[] matches;
            String line = stringArray[n2];
            if (line.length() > 0 && (matches = StringUtil.split(line, pattern)) != null && matches.length == 4) {
                info = new DlogInfo();
                try {
                    SimpleDateFormat ft = new SimpleDateFormat("y-MM-dd hh:mm:ss");
                    Date date = ft.parse("1-" + matches[0]);
                    info.setCalendar(date);
                }
                catch (ParseException parseException) {}
                info.setLogLevel(LogLevel.getByLetter(matches[1]));
                info.setTag(matches[1]);
                info.setPid(Integer.parseInt(matches[2]));
                info.setCommand(matches[3]);
                infos.add(info);
            }
            ++n2;
        }
        return infos.toArray(new DlogInfo[0]);
    }
}

