/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sign.signer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.Assert;
import org.tizen.common.util.IOUtil;

public class TizenIncrementalSigner {
    protected static final Logger logger = LoggerFactory.getLogger(TizenIncrementalSigner.class);
    protected static final String KEY_TYPE_PKCS12 = "PKCS12";

    public static String getFirstAlias(KeyStore keyStore) throws KeyStoreException {
        Assert.notNull((Object)keyStore);
        Enumeration<String> aliases = keyStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            if (!keyStore.isKeyEntry(alias)) continue;
            return alias;
        }
        return null;
    }

    public static boolean checkCertificatePassword(String keyPath, String password) throws FileNotFoundException, NoSuchAlgorithmException, CertificateException, KeyStoreException {
        Assert.notNull((Object)keyPath);
        Assert.notNull((Object)password);
        char[] pwd = password.toCharArray();
        try {
            KeyStore keyStore = TizenIncrementalSigner.loadKeyStore(keyPath, KEY_TYPE_PKCS12, pwd);
            String alias = TizenIncrementalSigner.getFirstAlias(keyStore);
            if (alias == null) {
                throw new CertificateException("Couldn't find an alias in the KeyStore.");
            }
            return keyStore.getKey(alias, pwd) != null;
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException iOException) {
            logger.error("{} is invalid certificate file or password incorrect.", (Object)keyPath);
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            logger.error("{} is invalid certificate file or password incorrect.", (Object)keyPath);
        }
        return false;
    }

    public static KeyStore loadKeyStore(String keyFilePath, String type, char[] password) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        Assert.notNull((Object)keyFilePath);
        return TizenIncrementalSigner.loadKeyStore(new File(keyFilePath), type, password);
    }

    protected static KeyStore loadKeyStore(File keyFile, String type, char[] password) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        KeyStore keyStore;
        Assert.notNull((Object)keyFile);
        Assert.notNull((Object)type);
        Assert.notNull((Object)password);
        String path = keyFile.getPath();
        logger.debug("Load key path: {}", (Object)path);
        if (!keyFile.exists()) {
            throw new FileNotFoundException(path);
        }
        KeyStore keyStore2 = KeyStore.getInstance(type);
        FileInputStream keyIs = null;
        try {
            keyIs = new FileInputStream(keyFile);
            keyStore2.load(keyIs, password);
            keyStore = keyStore2;
        }
        catch (Throwable throwable) {
            IOUtil.tryClose((Object[])new Object[]{keyIs});
            throw throwable;
        }
        IOUtil.tryClose((Object[])new Object[]{keyIs});
        return keyStore;
    }
}

