/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sign.ui.dialog;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.tizen.common.sign.ui.CertificateType;
import org.tizen.common.sign.ui.CertificateTypeExtensions;
import org.tizen.common.sign.ui.dialog.CertificateManageComposite;
import org.tizen.common.sign.ui.dialog.IoTCertificateManageComposite;
import org.tizen.common.sign.ui.dialog.Messages;

public class CertificateManageDialog
extends Dialog {
    CertificateManageComposite certMainComposite = null;
    IoTCertificateManageComposite iotCertMainComposite = null;
    private Label lDescription;

    public CertificateManageDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.CERT_MANAGER_TITLE);
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10 | 0x400);
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)gridData);
        CertificateManageDialog.applyDialogFont((Control)composite);
        this.initializeDialogUnits((Control)composite);
        this.createTitleArea(composite);
        this.certMainComposite = new CertificateManageComposite(this.getShell(), this.lDescription);
        this.dialogArea = this.createDialogArea(composite);
        this.buttonBar = this.createButtonBar(composite);
        return composite;
    }

    private Composite createTabs(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        TabFolder tabFolder = new TabFolder(parent, 2048);
        tabFolder.setLayoutData((Object)gridData);
        TabItem appSigning = new TabItem(tabFolder, 0);
        appSigning.setText("App Signing");
        Composite tabCompositeApp = new Composite((Composite)tabFolder, 0);
        tabCompositeApp.setLayout((Layout)layout);
        tabCompositeApp.setLayoutData((Object)gridData);
        appSigning.setControl((Control)tabCompositeApp);
        this.certMainComposite.createMainComposite(tabCompositeApp);
        this.certMainComposite.setInput();
        for (CertificateType certType : CertificateTypeExtensions.getCertificateTypes()) {
            if (!"SmartThings".equals(certType.getName())) continue;
            this.iotCertMainComposite = new IoTCertificateManageComposite(this.getShell(), this.lDescription);
            TabItem iotService = new TabItem(tabFolder, 0);
            iotService.setText("IoT Cloud Service");
            Composite tabCompositeIot = new Composite((Composite)tabFolder, 0);
            tabCompositeIot.setLayout((Layout)layout);
            tabCompositeIot.setLayoutData((Object)gridData);
            iotService.setControl((Control)tabCompositeIot);
            this.iotCertMainComposite.createMainComposite(tabCompositeIot);
            this.iotCertMainComposite.setInput();
            break;
        }
        return tabFolder;
    }

    public Control createTitleArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 20;
        GridData layoutData = new GridData(768);
        layoutData.heightHint = 60;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)layoutData);
        composite.setBackground(this.getShell().getDisplay().getSystemColor(1));
        this.lDescription = new Label(composite, 0);
        layoutData = new GridData(772);
        layoutData.grabExcessVerticalSpace = true;
        this.lDescription.setLayoutData((Object)layoutData);
        this.lDescription.setBackground(this.getShell().getDisplay().getSystemColor(1));
        return composite;
    }

    protected Control createDialogArea(Composite parent) {
        return this.createTabs(parent);
    }

    protected Control createButtonBar(Composite parent) {
        Control composite = super.createButtonBar(parent);
        parent.setBackground(this.getShell().getDisplay().getSystemColor(1));
        composite.setBackground(this.getShell().getDisplay().getSystemColor(1));
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button closeButton = this.createButton(parent, 12, Messages.CERT_MANAGER_CLOSE, true);
        closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CertificateManageDialog.this.setReturnCode(0);
                CertificateManageDialog.this.close();
            }
        });
    }

    public boolean close() {
        this.certMainComposite.close();
        if (this.iotCertMainComposite != null) {
            this.iotCertMainComposite.close();
        }
        return super.close();
    }
}

