/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sign.ui.validator;

import org.tizen.common.sign.ui.validator.CertificateValidateMessage;
import org.tizen.common.sign.ui.validator.ICertificateValidator;
import org.tizen.common.sign.ui.validator.Messages;
import org.tizen.common.sign.util.SigningPathUtil;
import org.tizen.common.util.FileUtil;

public class CertificateKeyFilenameValidator
implements ICertificateValidator {
    private static final String REGEX_ALPHANUMERIC_WITH_UNDERSCORE_HYPHEN = "[a-zA-Z0-9_-]*";

    @Override
    public CertificateValidateMessage validate(String value) {
        if (value.isEmpty()) {
            return new CertificateValidateMessage(false, "");
        }
        if (!value.matches(REGEX_ALPHANUMERIC_WITH_UNDERSCORE_HYPHEN)) {
            return new CertificateValidateMessage(false, Messages.CERT_NAME_LIMITATION);
        }
        String pkcsKeyStorePath = SigningPathUtil.getAuthorKeyStorePath((String)value);
        if (FileUtil.isExist((String)pkcsKeyStorePath)) {
            return new CertificateValidateMessage(false, Messages.DUPLICATE_KEY_FILENAME);
        }
        return new CertificateValidateMessage();
    }
}

