/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.connection.explorer;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.part.PluginTransfer;
import org.eclipse.ui.part.PluginTransferData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.connection.ConnectionPlugin;
import org.tizen.common.connection.debugtools.OnDemandInstall;
import org.tizen.common.connection.explorer.AllowOnlyFoldersFilter;
import org.tizen.common.connection.explorer.ConnectionExplorer;
import org.tizen.common.connection.explorer.ConnectionExplorerContentProvider;
import org.tizen.common.connection.explorer.ConnectionExplorerFileContentProvider;
import org.tizen.common.connection.explorer.ConnectionExplorerFileLabelProvider;
import org.tizen.common.connection.explorer.ConnectionExplorerLabelProvider;
import org.tizen.common.connection.explorer.ConnectionExplorerOperation;
import org.tizen.common.connection.explorer.ConnectionUIMessages;
import org.tizen.common.connection.explorer.FileSorter;
import org.tizen.common.connection.sdblib.dnd.FileEntryTransfer;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.sdb.command.FsCommand;
import org.tizen.common.ui.dialog.FileDialogUtils;
import org.tizen.common.ui.view.console.AnsicodeAdapter;
import org.tizen.common.util.ArrayUtil;
import org.tizen.common.util.DialogUtil;
import org.tizen.common.util.FilenameUtil;
import org.tizen.common.util.HostUtil;
import org.tizen.common.util.SWTUtil;
import org.tizen.sdblib.Arch;
import org.tizen.sdblib.DeviceState;
import org.tizen.sdblib.IDebugBridgeChangeListener;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.IDeviceChangeListener;
import org.tizen.sdblib.IShellOutputReceiver;
import org.tizen.sdblib.SmartDevelopmentBridge;
import org.tizen.sdblib.receiver.MultiLineReceiver;
import org.tizen.sdblib.service.FileEntry;
import org.tizen.sdblib.service.FileEntryType;
import org.tizen.sdblib.util.DeviceUtil;
import org.tizen.sdblib.util.IOUtil;

public class ConnectionExplorerPanel
implements IDeviceChangeListener,
IDebugBridgeChangeListener,
ConnectionPlugin.ISelectionListener {
    private final Logger logger = LoggerFactory.getLogger(ConnectionExplorerPanel.class);
    private static final String DRAGACTIONID = "org.tizen.common.connection.filedrop";
    private Composite parent;
    private TreeViewer treeViewer;
    private SashForm sash_form;
    private ConnectionExplorerContentProvider contentProvider;
    private ConnectionExplorerOperation operation;
    private TableViewer tableViewer;
    private Composite tableViewerComposite;
    private ConnectionExplorerFileContentProvider fileContentProvider;
    private ConnectionExplorerFileLabelProvider fileLabelProvider;
    private boolean bSubLog = false;
    private final int STATE_PROPERTY = 1;
    private final int STATE_DELETE = 2;
    private final int STATE_RENAME = 4;
    private final int STATE_REFRESH = 8;
    private final int STATE_COLLAPSE_ALL = 16;
    private final int STATE_PULL = 32;
    private final int STATE_PUSH = 64;
    private final int STATE_SUB = 128;
    private final int STATE_DISCONNECT = 256;
    private final int STATE_OPEN_SHELL = 512;
    private Action actionDevicePush;
    private Action actionDevicePull;
    private MenuManager subNewMenu;
    private Action actionPush;
    private Action actionPull;
    private Action actionRefresh;
    private Action actionCollapseAll;
    private Action actionRename;
    private Action actionProperty;
    private Action actionDelete;
    private Action actionDisconnect;
    private Action actionOpenShell;
    private MenuManager subLogMenu;
    private IDevice currentDevice;
    private String defaultSave;
    private static final String PATH_SEPARATOR = "/";
    private final List<IDevice> devicesList = new ArrayList<IDevice>();
    private ControlListener controlListener;
    private AllowOnlyFoldersFilter viewFilter;
    public static final DecimalFormat sizeFormat = new DecimalFormat("#,##0");
    private final int AUTO_ORIENTATION_WIDTH = 600;
    private boolean isSingleViewMode = false;
    private boolean selectionInDeviceView = false;
    private static final String ERROR_CODE_PATTERN = "^([1-9]|[1-9]\\d|1[0-1]\\d|12[0-7])";

    public ConnectionExplorerPanel() {
        this.operation = new ConnectionExplorerOperation();
    }

    protected Control createControl(Composite pParent) {
        this.parent = pParent;
        this.parent.setLayout((Layout)new GridLayout(1, false));
        this.controlListener = new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                int width = ((ConnectionExplorerPanel)ConnectionExplorerPanel.this).sash_form.getBounds().width;
                if (width > 600) {
                    ConnectionExplorerPanel.this.sash_form.setOrientation(256);
                } else {
                    ConnectionExplorerPanel.this.sash_form.setOrientation(512);
                }
            }
        };
        this.sash_form = new SashForm(this.parent, 512);
        this.sash_form.setLayout((Layout)new FillLayout());
        this.sash_form.setLayoutData((Object)new GridData(1808));
        this.sash_form.addControlListener(this.controlListener);
        this.treeViewer = new TreeViewer((Composite)this.sash_form, 67586);
        this.contentProvider = new ConnectionExplorerContentProvider();
        this.fileContentProvider = new ConnectionExplorerFileContentProvider();
        this.fileLabelProvider = new ConnectionExplorerFileLabelProvider();
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new ConnectionExplorerLabelProvider(this.parent.getDisplay()));
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!ConnectionExplorerPanel.this.selectionInDeviceView) {
                    ConnectionExplorerPanel.this.selectionInDeviceView = true;
                    if (!ConnectionExplorerPanel.this.isSingleViewMode) {
                        ConnectionExplorerPanel.this.tableViewerComposite.setVisible(true);
                        ConnectionExplorerPanel.this.tableViewerComposite.getParent().layout();
                    }
                }
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                FileEntry selected_file = null;
                if (selection.getFirstElement() instanceof FileEntry) {
                    selected_file = (FileEntry)selection.getFirstElement();
                    ConnectionExplorer.setPathText(selected_file.getFullPath());
                    ConnectionExplorerPanel.this.tableViewer.setInput((Object)selected_file);
                    TreeItem[] items = ConnectionExplorerPanel.this.treeViewer.getTree().getSelection();
                    int totalSize = 0;
                    int totalLength = items.length;
                    TreeItem[] treeItemArray = items;
                    int n = items.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TreeItem item = treeItemArray[n2];
                        Object data = item.getData();
                        if (data instanceof FileEntry) {
                            FileEntry entry = (FileEntry)data;
                            FileEntryType type = entry.getType();
                            if (type == FileEntryType.RootEmulator || type == FileEntryType.RootDevice) {
                                --totalLength;
                            } else if (!entry.getType().isDevice()) {
                                totalSize += Integer.valueOf(entry.getSize()).intValue();
                            }
                        }
                        ++n2;
                    }
                    ConnectionExplorer.statusLineManager.setMessage(String.valueOf(totalLength) + " object(s) selected. Size:" + sizeFormat.format(totalSize) + " bytes");
                    ConnectionExplorerPanel.this.notifyListeners();
                }
            }
        });
        this.treeViewer.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
            }

            public void treeExpanded(TreeExpansionEvent event) {
                if (!ConnectionExplorerPanel.this.selectionInDeviceView) {
                    ConnectionExplorerPanel.this.selectionInDeviceView = true;
                    if (!ConnectionExplorerPanel.this.isSingleViewMode) {
                        ConnectionExplorerPanel.this.tableViewerComposite.setVisible(true);
                        ConnectionExplorerPanel.this.tableViewerComposite.getParent().layout();
                    }
                }
            }
        });
        this.viewFilter = new AllowOnlyFoldersFilter();
        this.treeViewer.addFilter((ViewerFilter)this.viewFilter);
        this.treeViewer.addDragSupport(3, new Transfer[]{PluginTransfer.getInstance(), FileEntryTransfer.getInstance()}, new DragSourceListener(){

            public void dragStart(DragSourceEvent e) {
                TreeItem[] items = ConnectionExplorerPanel.this.treeViewer.getTree().getSelection();
                int i = 0;
                while (i < items.length) {
                    Object data = items[i].getData();
                    if (data instanceof FileEntry && (((FileEntry)data).isDirectory() || ((FileEntry)data).isRoot())) {
                        e.doit = false;
                        return;
                    }
                    ++i;
                }
                e.doit = true;
            }

            public void dragFinished(DragSourceEvent arg0) {
            }

            public void dragSetData(DragSourceEvent e) {
                TreeItem[] items = ConnectionExplorerPanel.this.treeViewer.getTree().getSelection();
                FileEntry[] entries = new FileEntry[items.length];
                int i = 0;
                while (i < items.length) {
                    Object data = items[i].getData();
                    if (data instanceof FileEntry) {
                        entries[i] = (FileEntry)data;
                    }
                    ++i;
                }
                if (FileEntryTransfer.getInstance().isSupportedType(e.dataType)) {
                    e.data = entries;
                } else if (PluginTransfer.getInstance().isSupportedType(e.dataType)) {
                    byte[] data = FileEntryTransfer.getInstance().toByteArray(entries);
                    e.data = new PluginTransferData(ConnectionExplorerPanel.DRAGACTIONID, data);
                }
            }
        });
        int ops = 3;
        Transfer[] transfers = new Transfer[]{FileTransfer.getInstance()};
        this.treeViewer.addDropSupport(ops, transfers, (DropTargetListener)new ViewerDropAdapter((Viewer)this.treeViewer){

            public boolean performDrop(Object data) {
                FileEntry target = (FileEntry)this.getCurrentTarget();
                if ((target = ConnectionExplorerPanel.this.getValidDirectoryFileEntry(target)) == null) {
                    return false;
                }
                String[] files = (String[])data;
                ConnectionExplorerPanel.this.pushFiles(files, target);
                ConnectionExplorerPanel.this.refresh(target);
                return true;
            }

            public boolean validateDrop(Object target, int operation, TransferData transferType) {
                if (target == null) {
                    return false;
                }
                FileEntry targetEntry = (FileEntry)target;
                return ConnectionExplorerPanel.this.getValidDirectoryFileEntry(targetEntry) != null;
            }
        });
        this.tableViewerComposite = new Composite((Composite)this.sash_form, 0);
        this.tableViewerComposite.setLayout((Layout)new FillLayout(512));
        this.tableViewer = new TableViewer(this.tableViewerComposite, 67586);
        this.tableViewer.setContentProvider((IContentProvider)this.fileContentProvider);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)this.fileLabelProvider);
        this.tableViewer.setSorter((ViewerSorter)new FileSorter());
        TableColumn nameColumn = new TableColumn(this.tableViewer.getTable(), 16384);
        nameColumn.setText("Name");
        nameColumn.setWidth(100);
        TableColumn dateColumn = new TableColumn(this.tableViewer.getTable(), 0x1000000);
        dateColumn.setText("Date");
        dateColumn.setWidth(80);
        TableColumn sizeColumn = new TableColumn(this.tableViewer.getTable(), 131072);
        sizeColumn.setText("Size (Byte)");
        sizeColumn.setWidth(60);
        nameColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ((FileSorter)ConnectionExplorerPanel.this.tableViewer.getSorter()).doSort(0);
                ConnectionExplorerPanel.this.tableViewer.refresh();
            }
        });
        dateColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ((FileSorter)ConnectionExplorerPanel.this.tableViewer.getSorter()).doSort(1);
                ConnectionExplorerPanel.this.tableViewer.refresh();
            }
        });
        sizeColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ((FileSorter)ConnectionExplorerPanel.this.tableViewer.getSorter()).doSort(2);
                ConnectionExplorerPanel.this.tableViewer.refresh();
            }
        });
        this.tableViewer.getTable().setHeaderVisible(true);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                FileEntry selected_file = null;
                if (selection.getFirstElement() instanceof FileEntry && (selected_file = (FileEntry)selection.getFirstElement()) != null) {
                    if (!selected_file.isDirectory()) {
                        selected_file = selected_file.getParent();
                    }
                    ConnectionExplorer.setPathText(selected_file.getFullPath());
                    TableItem[] items = ConnectionExplorerPanel.this.tableViewer.getTable().getSelection();
                    int totalSize = 0;
                    int totalLength = items.length;
                    TableItem[] tableItemArray = items;
                    int n = items.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableItem item = tableItemArray[n2];
                        Object data = item.getData();
                        if (data instanceof FileEntry) {
                            FileEntry entry = (FileEntry)data;
                            FileEntryType type = entry.getType();
                            if (type == FileEntryType.RootEmulator || type == FileEntryType.RootDevice) {
                                --totalLength;
                            } else if (!entry.getType().isDevice()) {
                                totalSize += Integer.valueOf(entry.getSize()).intValue();
                            }
                        }
                        ++n2;
                    }
                    ConnectionExplorer.statusLineManager.setMessage(String.valueOf(totalLength) + " object(s) selected. Size:" + sizeFormat.format(totalSize) + " bytes");
                }
            }
        });
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                FileEntryType type;
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                FileEntry selected_file = null;
                if (selection.getFirstElement() instanceof FileEntry && ((type = (selected_file = (FileEntry)selection.getFirstElement()).getType()) == FileEntryType.Directory || type == FileEntryType.DirectoryLink)) {
                    ConnectionExplorer.setPathText(selected_file.getFullPath());
                    ConnectionExplorerPanel.this.tableViewer.setInput((Object)selected_file);
                }
            }
        });
        this.tableViewer.setSorter((ViewerSorter)new FileSorter());
        this.tableViewerComposite.setVisible(false);
        return this.sash_form;
    }

    private FileEntry getValidDirectoryFileEntry(FileEntry fileEntry) {
        if (fileEntry == null) {
            return null;
        }
        if (!fileEntry.isDirectory()) {
            fileEntry = fileEntry.getParent();
        }
        if (fileEntry == null) {
            return null;
        }
        return fileEntry;
    }

    public void setToolItems(Action actionDevicePush, Action actionDevicePull) {
        this.actionDevicePush = actionDevicePush;
        this.actionDevicePull = actionDevicePull;
    }

    public void setActions(MenuManager pSubMenu, Action pActionPush, Action pActionPull, Action pActionRefresh, Action pActionCollapseAll, Action pActionRename, Action pActionProperty, Action pActionDelete, Action pActionDisconnect, Action pActionOpenShell, MenuManager pSubLogMenu) {
        this.subNewMenu = pSubMenu;
        this.actionPush = pActionPush;
        this.actionPull = pActionPull;
        this.actionRefresh = pActionRefresh;
        this.actionCollapseAll = pActionCollapseAll;
        this.actionRename = pActionRename;
        this.actionProperty = pActionProperty;
        this.actionDelete = pActionDelete;
        this.actionDisconnect = pActionDisconnect;
        this.actionOpenShell = pActionOpenShell;
        this.subLogMenu = pSubLogMenu;
        this.setActionEnabled();
    }

    protected void postCreation() {
        ConnectionPlugin.getDefault().addSelectionListener(this);
        SmartDevelopmentBridge.addDebugBridgeChangeListener((IDebugBridgeChangeListener)this);
        SmartDevelopmentBridge.addDeviceChangeListener((IDeviceChangeListener)this, (boolean)true);
    }

    public void pullSelection() {
        FileEntry[] selectedFileEntry = this.getMultiFileEntry();
        if (selectedFileEntry == null) {
            return;
        }
        DirectoryDialog dlg = new DirectoryDialog(this.parent.getShell(), 8192);
        this.setDialog((Dialog)dlg, ConnectionUIMessages.Explorer_ConetextMenu_Pull);
        String directoryName = dlg.open();
        if (directoryName != null) {
            this.pullSelection(selectedFileEntry, directoryName);
        }
    }

    public void pushIntoSelection() {
        this.doActionForEntry(new IActionForEntry(){

            @Override
            public void doAction() {
                FileEntry entry = ConnectionExplorerPanel.this.getSingleFileEntry();
                FileDialog dlg = new FileDialog(ConnectionExplorerPanel.this.parent.getShell(), 2);
                ConnectionExplorerPanel.this.setDialog((Dialog)dlg, ConnectionUIMessages.Explorer_ConetextMenu_Push);
                String firstFile = dlg.open();
                if (firstFile != null) {
                    String[] files = dlg.getFileNames();
                    String[] filesWithPath = new String[files.length];
                    int i = 0;
                    int n = files.length;
                    while (i < n) {
                        filesWithPath[i] = "";
                        int n2 = i;
                        filesWithPath[n2] = String.valueOf(filesWithPath[n2]) + dlg.getFilterPath();
                        if (filesWithPath[i].charAt(filesWithPath[i].length() - 1) != File.separatorChar) {
                            int n3 = i;
                            filesWithPath[n3] = String.valueOf(filesWithPath[n3]) + File.separatorChar;
                        }
                        int n4 = i;
                        filesWithPath[n4] = String.valueOf(filesWithPath[n4]) + files[i];
                        ++i;
                    }
                    if (entry != null) {
                        FileEntry refreshFileEntry = entry.isDirectory() || entry.isRoot() ? entry : entry.getParent();
                        ConnectionExplorerPanel.this.pushFiles(filesWithPath, refreshFileEntry);
                        ConnectionExplorerPanel.this.refresh(refreshFileEntry);
                    }
                }
            }

            @Override
            public boolean doCheckEnable() {
                return ConnectionExplorerPanel.this.isSingleEntry() && ConnectionExplorerPanel.this.actionPush.isEnabled();
            }
        });
    }

    private void setDialog(Dialog dialog, String text) {
        dialog.setText(text);
        String defaultPath = this.defaultSave;
        if (defaultPath == null) {
            defaultPath = System.getProperty("user.home");
        }
        if (dialog instanceof FileDialog) {
            FileDialog dlg = (FileDialog)dialog;
            dlg.setFilterPath(defaultPath);
            this.defaultSave = dlg.getFilterPath();
        } else if (dialog instanceof DirectoryDialog) {
            DirectoryDialog dlg = (DirectoryDialog)dialog;
            dlg.setFilterPath(defaultPath);
            this.defaultSave = dlg.getFilterPath();
        }
    }

    public void addNewFileSelection() {
        this.doActionForEntry(new IActionForEntry(){

            @Override
            public void doAction() {
                FileEntry entry = ConnectionExplorerPanel.this.getSingleFileEntry();
                if (entry == null) {
                    return;
                }
                String name = ConnectionExplorerPanel.this.getNameFromInputDialog("New File Resource", "New File Name: ", entry, "");
                if (name == null) {
                    return;
                }
                String fullPath = FilenameUtil.addDoubleQuote((String)(String.valueOf(entry.getFullEscapedPath()) + ConnectionExplorerPanel.PATH_SEPARATOR + name));
                String command = String.format("touch %s; echo $?", fullPath);
                MultiLineReceiver receiver = new MultiLineReceiver(){

                    public void processNewLines(String[] lines) {
                        ConnectionExplorerPanel.this.sayError(lines, "add_file_error", "Failed to add a file");
                    }
                };
                try {
                    try {
                        ConnectionExplorerPanel.this.currentDevice.executeShellCommand(command, (IShellOutputReceiver)receiver);
                    }
                    catch (IOException e) {
                        ConnectionExplorerPanel.this.logger.error("Failed to add new file", (Object)e.getMessage());
                        throw new RuntimeException(e);
                    }
                }
                finally {
                    IOUtil.tryClose((Closeable)receiver);
                }
                ConnectionExplorerPanel.this.refresh(entry);
            }

            @Override
            public boolean doCheckEnable() {
                return ConnectionExplorerPanel.this.isSingleEntry();
            }
        });
    }

    public void addNewFolderSelection() {
        this.doActionForEntry(new IActionForEntry(){

            @Override
            public void doAction() {
                FileEntry entry = ConnectionExplorerPanel.this.getSingleFileEntry();
                if (entry == null) {
                    return;
                }
                String name = ConnectionExplorerPanel.this.getNameFromInputDialog("New Folder Resource", "New Folder Name: ", entry, "");
                if (name == null) {
                    return;
                }
                String fullPath = FilenameUtil.addDoubleQuote((String)(String.valueOf(entry.getFullEscapedPath()) + ConnectionExplorerPanel.PATH_SEPARATOR + name));
                try {
                    FsCommand command = new FsCommand(ConnectionExplorerPanel.this.currentDevice, null);
                    command.mkdir(fullPath);
                }
                catch (Exception e) {
                    ConnectionExplorerPanel.this.logger.error("Failed to add a new folder", (Throwable)e);
                    throw new RuntimeException(e);
                }
                ConnectionExplorerPanel.this.refresh(entry);
            }

            @Override
            public boolean doCheckEnable() {
                return ConnectionExplorerPanel.this.isSingleEntry();
            }
        });
    }

    private String getNameFromInputDialog(String title, String message, FileEntry entry, String initValue) {
        InputDialog inputDialog;
        boolean again;
        do {
            again = false;
            inputDialog = new InputDialog(Display.getCurrent().getActiveShell(), title, message, initValue, (IInputValidator)new FileNameValidator());
            if (inputDialog.open() != 0) {
                return null;
            }
            String input = inputDialog.getValue();
            if (!this.findDuplicateFileEntry(input, entry)) continue;
            again = true;
        } while (again);
        return FilenameUtil.getEscapedName((String)inputDialog.getValue());
    }

    public void renameSelection() {
        this.doActionForEntry(new IActionForEntry(){

            @Override
            public void doAction() {
                FileEntry entry = ConnectionExplorerPanel.this.getSingleFileEntry();
                if (entry == null) {
                    return;
                }
                String name = ConnectionExplorerPanel.this.getNameFromInputDialog("Rename Resource", "New name: ", entry.getParent(), entry.getName());
                if (name == null) {
                    return;
                }
                String fullPath = entry.getFullEscapedPath();
                int lastIndex = fullPath.lastIndexOf(ConnectionExplorerPanel.PATH_SEPARATOR);
                String newPath = String.valueOf(fullPath.substring(0, lastIndex)) + ConnectionExplorerPanel.PATH_SEPARATOR + name;
                String command = String.format("mv %s %s; echo $?", FilenameUtil.addDoubleQuote((String)fullPath), FilenameUtil.addDoubleQuote((String)newPath));
                MultiLineReceiver receiver = new MultiLineReceiver(){

                    public void processNewLines(String[] lines) {
                        ConnectionExplorerPanel.this.sayError(lines, "rename_error", "A selection failed to be renamed");
                    }
                };
                try {
                    try {
                        ConnectionExplorerPanel.this.currentDevice.executeShellCommand(command, (IShellOutputReceiver)receiver);
                    }
                    catch (IOException e) {
                        ConnectionExplorerPanel.this.logger.error("failed to rename", (Throwable)e);
                        throw new RuntimeException(e);
                    }
                }
                finally {
                    IOUtil.tryClose((Closeable)receiver);
                }
                ConnectionExplorerPanel.this.refresh(entry.getParent());
            }

            @Override
            public boolean doCheckEnable() {
                return ConnectionExplorerPanel.this.isSingleEntry() && ConnectionExplorerPanel.this.actionRename.isEnabled();
            }
        });
    }

    public void deleteSelection() {
        this.doActionForEntry(new IActionForEntry(){

            @Override
            public void doAction() {
                FileEntry[] fileEntry = ConnectionExplorerPanel.this.getMultiFileEntry();
                if (fileEntry == null) {
                    return;
                }
                FileEntry[] fileEntryArray = fileEntry;
                int n = fileEntry.length;
                int n2 = 0;
                while (n2 < n) {
                    FileEntry entry = fileEntryArray[n2];
                    int ret = FileDialogUtils.confirmDelete((String)entry.getName());
                    if (ret != 1) {
                        String command = null;
                        command = entry.isDirectory() ? String.format("rm -rf %s; echo $?", FilenameUtil.addDoubleQuote((String)entry.getFullEscapedPath())) : String.format("rm -f %s; echo $?", FilenameUtil.addDoubleQuote((String)entry.getFullEscapedPath()));
                        MultiLineReceiver receiver = new MultiLineReceiver(){

                            public void processNewLines(String[] lines) {
                                ConnectionExplorerPanel.this.sayError(lines, "delete_error", "Failed to delete a selection");
                            }
                        };
                        try {
                            try {
                                ConnectionExplorerPanel.this.currentDevice.executeShellCommand(command, (IShellOutputReceiver)receiver);
                            }
                            catch (IOException e) {
                                ConnectionExplorerPanel.this.logger.error("Failed to delete", (Throwable)e);
                                throw new RuntimeException(e);
                            }
                        }
                        finally {
                            IOUtil.tryClose((Closeable)receiver);
                        }
                        ConnectionExplorerPanel.this.syncRefresh(entry.getParent());
                        ConnectionExplorerPanel.this.setActionEnabled();
                    }
                    ++n2;
                }
            }

            @Override
            public boolean doCheckEnable() {
                return ConnectionExplorerPanel.this.actionDelete.isEnabled();
            }
        });
    }

    public void openShell() {
        this.doActionForEntry(new IActionForEntry(){

            @Override
            public void doAction() {
                ConnectionExplorerPanel.this.operation.openShell(ConnectionExplorerPanel.this.currentDevice);
            }

            @Override
            public boolean doCheckEnable() {
                return ConnectionExplorerPanel.this.actionOpenShell.isEnabled();
            }
        });
    }

    public void showPropertySelection(final IWorkbenchPartSite site) {
        this.doActionForEntry(new IActionForEntry(){

            @Override
            public void doAction() {
                Focus focused = ConnectionExplorerPanel.this.getFocus();
                TableViewer isp = null;
                switch (focused) {
                    case TABLE: {
                        isp = ConnectionExplorerPanel.this.tableViewer;
                        break;
                    }
                    case TREE: {
                        isp = ConnectionExplorerPanel.this.treeViewer;
                        break;
                    }
                }
                if (isp != null) {
                    PropertyDialogAction pda = new PropertyDialogAction((IShellProvider)site, (ISelectionProvider)isp);
                    pda.run();
                }
            }

            @Override
            public boolean doCheckEnable() {
                return ConnectionExplorerPanel.this.actionProperty.isEnabled();
            }
        });
    }

    public void setPlatformLogOnOff(boolean On) {
        try {
            String command = String.format("dlogctrl set platformlog %s; echo $?", On ? "1" : "0");
            if (this.currentDevice.getApplicationCmdService() != null) {
                command = String.format("dlogctrl -k plog -s %s; echo $?", On ? "1" : "0");
            }
            this.currentDevice.executeShellCommand(command);
        }
        catch (IOException e) {
            this.logger.error("Failed to set platform log", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void disconnectSelection() {
        this.doActionForEntry(new IActionForEntry(){

            @Override
            public void doAction() {
                String sdbDisconnectDeviceCommand = String.valueOf(InstallPathConfig.getSDBPath()) + " disconnect " + ConnectionExplorerPanel.this.currentDevice.getSerialNumber();
                HostUtil.execute((String)sdbDisconnectDeviceCommand);
            }

            @Override
            public boolean doCheckEnable() {
                return ConnectionExplorerPanel.this.actionDisconnect.isEnabled();
            }
        });
    }

    private void sayError(String[] lines, String id, String message) {
        String lastLine = lines[lines.length - 1];
        if (!lastLine.equals("0")) {
            if (lines.length == 1 && lastLine.matches(ERROR_CODE_PATTERN)) {
                return;
            }
            if (lines.length <= 2) {
                Status status = new Status(4, id, 0, AnsicodeAdapter.getStripAnsiString((String)lines[0]), null);
                ErrorDialog.openError((Shell)SWTUtil.getActiveShell(), (String)"Message", (String)message, (IStatus)status);
            } else {
                MultiStatus multiStatus = new MultiStatus(id, 0, AnsicodeAdapter.getStripAnsiString((String)lines[0]), null);
                int i = 0;
                while (i < lines.length - 1) {
                    String strippedLine = AnsicodeAdapter.getStripAnsiString((String)lines[i]);
                    multiStatus.add((IStatus)new Status(4, id, 0, strippedLine, null));
                    ++i;
                }
                ErrorDialog.openError((Shell)SWTUtil.getActiveShell(), (String)"Message", (String)message, (IStatus)multiStatus);
            }
        }
    }

    public void bridgeChanged(final SmartDevelopmentBridge bridge) {
        final Tree tree = this.treeViewer.getTree();
        if (!tree.isDisposed()) {
            this.exec(new Runnable(){

                @Override
                public void run() {
                    if (!tree.isDisposed()) {
                        ConnectionExplorerPanel.this.treeViewer.setInput((Object)bridge);
                    } else {
                        SmartDevelopmentBridge.removeDebugBridgeChangeListener((IDebugBridgeChangeListener)ConnectionExplorerPanel.this);
                        SmartDevelopmentBridge.removeDeviceChangeListener((IDeviceChangeListener)ConnectionExplorerPanel.this);
                    }
                }
            });
        }
    }

    private void refresh(FileEntry entry) {
        RefreshViewThread refreshThread = new RefreshViewThread(entry);
        SWTUtil.asyncExec((Runnable)refreshThread);
    }

    private void syncRefresh(FileEntry entry) {
        RefreshViewThread refreshThread = new RefreshViewThread(entry);
        SWTUtil.syncExec((Runnable)refreshThread);
    }

    public void refreshSelection() {
        if (this.getSelectionCount() == 0) {
            return;
        }
        this.refresh(this.getSingleFileEntry());
    }

    private void pullSelection(FileEntry[] fileEntry, String localDirectory) {
    }

    private void openFailDialog(final String message) {
        Display display = this.parent.getDisplay();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                DialogUtil.openErrorDialog((Shell)ConnectionExplorerPanel.this.parent.getShell(), (String)"ERROR", (String)message);
            }
        });
    }

    private void pushFiles(String[] localFiles, FileEntry remoteDirectory) {
        Object[] paths = this.getFilesToOverwrite(localFiles, remoteDirectory);
        if (ArrayUtil.isEmpty((Object[])paths)) {
            return;
        }
        File[] files = new File[paths.length];
        int i = 0;
        int n = files.length;
        while (i < n) {
            files[i] = new File((String)paths[i]);
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private String[] getFilesToOverwrite(String[] src, FileEntry des) {
        FileEntry[] children = des.getChildren();
        ArrayList<String> listToOverwrite = new ArrayList<String>();
        boolean yesAll = false;
        String[] stringArray = src;
        int n = src.length;
        int n2 = 0;
        while (n2 < n) {
            block12: {
                String source;
                block10: {
                    File f;
                    block11: {
                        source = stringArray[n2];
                        f = new File(source);
                        boolean bFind = false;
                        FileEntry[] fileEntryArray = children;
                        int n3 = children.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            FileEntry entry = fileEntryArray[n4];
                            if (entry.getName().equals(f.getName())) {
                                bFind = true;
                                break;
                            }
                            ++n4;
                        }
                        if (!bFind || yesAll) break block10;
                        if (src.length != 1) break block11;
                        int ret = FileDialogUtils.allowFileOverwrite((String)f.getName());
                        if (ret == 1) {
                            return listToOverwrite.toArray(new String[0]);
                        }
                        break block10;
                    }
                    int ret = FileDialogUtils.checkOverwrite((String)f.getName());
                    switch (ret) {
                        case 3: {
                            return null;
                        }
                        case 2: {
                            break block12;
                        }
                        case 1: {
                            yesAll = true;
                            break;
                        }
                        case 0: 
                    }
                }
                listToOverwrite.add(source);
            }
            ++n2;
        }
        return listToOverwrite.toArray(new String[0]);
    }

    private boolean findDuplicateFileEntry(String src, FileEntry des) {
        FileEntry[] children;
        FileEntry[] fileEntryArray = children = des.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            FileEntry entry = fileEntryArray[n2];
            File f = new File(src);
            if (entry.getName().equals(f.getName())) {
                FileDialogUtils.notifyDuplication((String)f.getName());
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void onConnected(IDevice device) {
        if (!DeviceUtil.isOnline((IDevice)device) || Arch.UNKNOWN.equals((Object)device.getArch())) {
            return;
        }
        this.devicesList.add(device);
        OnDemandInstall onDemand = new OnDemandInstall(device);
        onDemand.setBlocking(false);
        onDemand.install(OnDemandInstall.getNullIProgressMonitor());
        this.execRefresh();
    }

    public void onDisconnected(IDevice device) {
        this.devicesList.remove(device);
        this.execRefresh();
        SWTUtil.asyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                ConnectionExplorer.setPathText("");
                ConnectionExplorer.statusLineManager.setMessage("");
            }
        });
    }

    public void onChanged(IDevice device, int changeMask) {
        switch (changeMask) {
            case 1: {
                this.onConnected(device);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                this.execRefresh();
            }
        }
    }

    private void execRefresh() {
        this.exec(new Runnable(){

            @Override
            public void run() {
                if (!ConnectionExplorerPanel.this.treeViewer.getTree().isDisposed()) {
                    ConnectionExplorerPanel.this.treeViewer.refresh();
                    ConnectionExplorerPanel.this.tableViewer.refresh();
                    ConnectionExplorerPanel.this.notifyListeners();
                } else {
                    SmartDevelopmentBridge.removeDebugBridgeChangeListener((IDebugBridgeChangeListener)ConnectionExplorerPanel.this);
                    SmartDevelopmentBridge.removeDeviceChangeListener((IDeviceChangeListener)ConnectionExplorerPanel.this);
                }
            }
        });
    }

    public List<IDevice> getDeviceList() {
        return this.devicesList;
    }

    private void exec(Runnable runnable) {
        Tree tree = this.treeViewer.getTree();
        if (!tree.isDisposed()) {
            try {
                Display display = tree.getDisplay();
                display.asyncExec(runnable);
            }
            catch (SWTException sWTException) {
                SmartDevelopmentBridge.removeDebugBridgeChangeListener((IDebugBridgeChangeListener)this);
                SmartDevelopmentBridge.removeDeviceChangeListener((IDeviceChangeListener)this);
            }
        }
    }

    private void notifyListeners() {
        Tree tree = this.treeViewer.getTree();
        FileEntry entry = null;
        if (tree.getSelectionCount() > 0) {
            entry = this.getSingleFileEntry();
        }
        if (entry != null) {
            this.currentDevice = entry.getDevice();
        } else {
            IDevice[] devices = SmartDevelopmentBridge.getBridge().getDevices();
            if (devices.length == 1) {
                this.currentDevice = devices[0];
                entry = devices[0].getRoot();
                TreeItem[] treeItemArray = tree.getItems();
                int n = treeItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem item = treeItemArray[n2];
                    if (item.getText().equals(ConnectionExplorerLabelProvider.getDeviceSerialWithName(entry))) {
                        tree.setSelection(item);
                        tree.setFocus();
                    }
                    ++n2;
                }
            } else {
                this.currentDevice = null;
            }
        }
        ConnectionPlugin.getDefault().setCurrentDevice(this.currentDevice);
        ConnectionPlugin.getDefault().notifySelectionListeners(entry);
        this.setActionEnabled();
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    public int getActionState() {
        int length = this.getSelectionCount();
        int state = 0;
        this.bSubLog = false;
        if (length == 1) {
            FileEntry entry = this.getSingleFileEntry();
            if (entry != null) {
                if (entry.getDevice().isRemote()) {
                    state = 256;
                }
                if (entry.isRoot()) {
                    if (entry.getDevice().getState() == DeviceState.SUSPENDED || entry.getDevice().getState() == DeviceState.LOCKED) {
                        return state;
                    }
                    state = state | 0x80 | 0x40 | 0x20 | 8 | 1 | 0x10 | 0x200;
                    this.bSubLog = true;
                } else {
                    state = !entry.isDirectory() ? state | 0x20 | 8 | 4 | 2 | 1 : state | 0x80 | 0x40 | 0x20 | 8 | 4 | 2 | 1 | 0x10 | 0x200;
                }
            }
        } else if (length > 1) {
            state = state | 0x20 | 2 | 0x10;
        }
        return state;
    }

    private boolean getEnabled(int mode, int state) {
        int result = mode & state;
        return result != 0;
    }

    private void setActionEnabled() {
        int mode = this.getActionState();
        this.subNewMenu.setVisible(this.getEnabled(mode, 128));
        boolean bPush = this.getEnabled(mode, 64);
        this.actionPush.setEnabled(bPush);
        this.actionDevicePush.setEnabled(bPush);
        boolean bPull = this.getEnabled(mode, 32);
        this.actionPull.setEnabled(bPull);
        this.actionDevicePull.setEnabled(bPull);
        this.actionRename.setEnabled(this.getEnabled(mode, 4));
        this.actionRefresh.setEnabled(this.getEnabled(mode, 8));
        this.actionCollapseAll.setEnabled(this.getEnabled(mode, 16));
        this.actionDelete.setEnabled(this.getEnabled(mode, 2));
        this.actionDisconnect.setEnabled(this.getEnabled(mode, 256));
        this.actionOpenShell.setEnabled(this.getEnabled(mode, 512));
        this.actionProperty.setEnabled(this.getEnabled(mode, 1));
        this.subLogMenu.setVisible(this.bSubLog);
    }

    private FileEntry getSingleFileEntry() {
        Focus focus = this.getFocus();
        if (focus == Focus.TREE) {
            Tree tree = this.treeViewer.getTree();
            if (tree.getSelectionCount() != 0) {
                TreeItem[] items = tree.getSelection();
                return (FileEntry)items[0].getData();
            }
            return null;
        }
        if (focus == Focus.TABLE) {
            Table table = this.tableViewer.getTable();
            if (table.getSelectionCount() != 0) {
                TableItem[] items = table.getSelection();
                return (FileEntry)items[0].getData();
            }
            return null;
        }
        return null;
    }

    private FileEntry[] getMultiFileEntry() {
        Focus focus = this.getFocus();
        if (focus == Focus.TREE) {
            Tree tree = this.treeViewer.getTree();
            if (tree.getSelectionCount() != 0) {
                TreeItem[] items = tree.getSelection();
                int length = items.length;
                FileEntry[] fileEntry = new FileEntry[length];
                int i = 0;
                while (i < length) {
                    fileEntry[i] = (FileEntry)items[i].getData();
                    ++i;
                }
                return fileEntry;
            }
            return null;
        }
        if (focus == Focus.TABLE) {
            Table table = this.tableViewer.getTable();
            if (table.getSelectionCount() != 0) {
                TableItem[] items = table.getSelection();
                int length = items.length;
                FileEntry[] fileEntry = new FileEntry[length];
                int i = 0;
                while (i < length) {
                    fileEntry[i] = (FileEntry)items[i].getData();
                    ++i;
                }
                return fileEntry;
            }
            return null;
        }
        return null;
    }

    private int getSelectionCount() {
        int selectionCount = 0;
        Focus focus = this.getFocus();
        if (focus == Focus.TABLE) {
            selectionCount = this.tableViewer.getTable().getSelectionCount();
        } else if (focus == Focus.TREE) {
            selectionCount = this.treeViewer.getTree().getSelectionCount();
        }
        return selectionCount;
    }

    private Focus getFocus() {
        int tableSelectionCount = this.tableViewer.getTable().getSelectionCount();
        int treeSelectionCount = this.treeViewer.getTree().getSelectionCount();
        if (this.tableViewer.getTable().isFocusControl() && tableSelectionCount != 0) {
            return Focus.TABLE;
        }
        if (this.treeViewer.getTree().isFocusControl() && treeSelectionCount != 0) {
            return Focus.TREE;
        }
        if (tableSelectionCount != 0) {
            return Focus.TABLE;
        }
        if (treeSelectionCount != 0) {
            return Focus.TREE;
        }
        return Focus.NONE;
    }

    @Override
    public void selectionChanged(final FileEntry selectedEntry) {
        if (selectedEntry == null) {
            return;
        }
        if (!selectedEntry.isRoot()) {
            return;
        }
        final Tree tree = this.treeViewer.getTree();
        this.exec(new Runnable(){

            @Override
            public void run() {
                if (!tree.isDisposed()) {
                    TreeItem[] treeItemArray = tree.getItems();
                    int n = treeItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TreeItem item = treeItemArray[n2];
                        if (item.getText().equals(selectedEntry.getName())) {
                            tree.setSelection(item);
                        }
                        ++n2;
                    }
                } else {
                    ConnectionPlugin.getDefault().removeSelectionListener(ConnectionExplorerPanel.this);
                }
            }
        });
    }

    private boolean isSingleEntry() {
        return this.getSelectionCount() == 1;
    }

    public void doActionForEntry(IActionForEntry action) {
        if (action.doCheckEnable()) {
            action.doAction();
        }
    }

    public void expandTreeAtPath(String path) {
        TreeItem[] rootTreeItems;
        String[] pathNames = this.getPathNamesFromPath(path);
        Tree tree = this.treeViewer.getTree();
        TreeItem[] treeItemArray = rootTreeItems = tree.getItems();
        int n = rootTreeItems.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem rootTreeItem = treeItemArray[n2];
            String currentDeviceName = ConnectionExplorerLabelProvider.getDeviceSerialWithName(this.currentDevice.getRoot());
            if (rootTreeItem.getText().equals(currentDeviceName)) {
                this.treeViewer.expandToLevel(rootTreeItem.getData(), 1);
                TreeItem[] treeItems = rootTreeItem.getItems();
                int i = 1;
                while (i < pathNames.length) {
                    TreeItem[] treeItemArray2 = treeItems;
                    int n3 = treeItems.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        TreeItem treeItem = treeItemArray2[n4];
                        if (treeItem.getText().equals(pathNames[i])) {
                            tree.setSelection(treeItem);
                            Object content = treeItem.getData();
                            this.tableViewer.setInput(content);
                            this.treeViewer.expandToLevel(content, 1);
                            treeItems = treeItem.getItems();
                            break;
                        }
                        ++n4;
                    }
                    ++i;
                }
            }
            ++n2;
        }
    }

    public String[] getPathNamesFromPath(String path) {
        String[] pathNames = null;
        pathNames = path.split(PATH_SEPARATOR);
        return pathNames;
    }

    public void showHorizontalViewMode() {
        if (this.isSingleViewMode) {
            this.changeMultiViewMode();
        }
        this.sash_form.removeControlListener(this.controlListener);
        this.sash_form.setOrientation(256);
    }

    public void showVerticalViewMode() {
        if (this.isSingleViewMode) {
            this.changeMultiViewMode();
        }
        this.sash_form.removeControlListener(this.controlListener);
        this.sash_form.setOrientation(512);
    }

    public void showAutoViewMode() {
        if (this.isSingleViewMode) {
            this.changeMultiViewMode();
        }
        this.sash_form.addControlListener(this.controlListener);
    }

    public void showSingleViewMode() {
        if (this.isSingleViewMode) {
            return;
        }
        this.treeViewer.removeFilter((ViewerFilter)this.viewFilter);
        int[] nArray = new int[2];
        nArray[0] = 1;
        this.sash_form.setWeights(nArray);
        this.tableViewerComposite.setVisible(false);
        this.isSingleViewMode = true;
    }

    public void changeMultiViewMode() {
        this.treeViewer.addFilter((ViewerFilter)this.viewFilter);
        this.sash_form.setWeights(new int[]{1, 1});
        this.tableViewerComposite.setVisible(true);
        this.tableViewerComposite.getParent().layout();
        this.isSingleViewMode = false;
    }

    static class FileNameValidator
    implements IInputValidator {
        FileNameValidator() {
        }

        public String isValid(String fileName) {
            int os = 1024;
            int validCheck = FilenameUtil.isVaildName((String)fileName, (int)os);
            if (validCheck != 0) {
                switch (validCheck) {
                    case 1: {
                        return String.valueOf(ConnectionUIMessages.Explorer_Message_Invalid_Character) + FilenameUtil.getInvalidCharacters((int)os);
                    }
                    case 2: {
                        return "";
                    }
                }
            }
            return null;
        }
    }

    private static enum Focus {
        TREE,
        TABLE,
        NONE;

    }

    private static interface IActionForEntry {
        public boolean doCheckEnable();

        public void doAction();
    }

    private class RefreshViewThread
    extends Thread {
        FileEntry entry;

        RefreshViewThread(FileEntry entry) {
            this.entry = entry;
        }

        @Override
        public void run() {
            ConnectionExplorerPanel.this.treeViewer.refresh((Object)this.entry, true);
            ConnectionExplorerPanel.this.tableViewer.refresh((Object)this.entry, true);
        }
    }
}

