/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.connection.log;

import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.ViewPart;
import org.tizen.common.connection.ConnectionPlugin;
import org.tizen.common.connection.log.EncodingChar;
import org.tizen.common.connection.log.LogColors;
import org.tizen.common.connection.log.LogPanel;
import org.tizen.common.connection.log.LogTab;
import org.tizen.common.connection.log.LogViewPartListener;
import org.tizen.common.connection.log.Region;
import org.tizen.sdblib.util.LogLevel;

public final class LogView
extends ViewPart {
    public static final String ID = "org.tizen.common.connection.log.LogView";
    private LogPanel logPanel;
    private Composite parent;
    private Action addAction;
    private Action removeAction;
    private Action editAction;
    private Action scrollLockAction;
    private Action exportAction;
    private Action clearAction;
    private Action encodingAction;
    private Action[] viewActions;
    private Action[] levelFilterActions;
    private final String[] logLevelEnableIcons = new String[]{"icons/log/elcl18/verbose.png", "icons/log/elcl18/debug.png", "icons/log/elcl18/info.png", "icons/log/elcl18/warning.png", "icons/log/elcl18/error.png", "icons/log/elcl18/fatal.png"};
    private final String[] logLevelDisableIcons = new String[]{"icons/log/dlcl18/verbose.png", "icons/log/dlcl18/debug.png", "icons/log/dlcl18/info.png", "icons/log/dlcl18/warning.png", "icons/log/dlcl18/error.png", "icons/log/dlcl18/fatal.png"};
    private Clipboard clipboard;
    private LogColors colors;
    private LogTab currentLogTab;
    private Menu encodingListMenu;
    private static ArrayList<MenuItem> allEncodingMenuItems = new ArrayList();

    public MenuItem findMatchedMenuItem(EncodingChar selectedEncodingChar) {
        for (MenuItem menuItem : allEncodingMenuItems) {
            if (!((EncodingChar)((Object)menuItem.getData())).getName().equals(selectedEncodingChar.getName())) continue;
            return menuItem;
        }
        return null;
    }

    public void uncheckAllMenuItem() {
        for (MenuItem menuItem : allEncodingMenuItems) {
            menuItem.setSelection(false);
        }
    }

    public void createPartControl(Composite p) {
        this.parent = p;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.parent, "org.tizen.ide.common.log_context");
        Display d = this.parent.getDisplay();
        this.colors = new LogColors(d);
        this.addAction = new Action("Add Tab"){

            public void run() {
                LogView.this.logPanel.addTab();
            }
        };
        this.addAction.setToolTipText("Add LogTab");
        this.addAction.setImageDescriptor(ConnectionPlugin.getImageDescriptorFromPlugin("icons/log/elcl18/add_log.png"));
        this.addAction.setDisabledImageDescriptor(ConnectionPlugin.getImageDescriptorFromPlugin("icons/log/dlcl18/add_log.png"));
        this.removeAction = new Action("Remove Tab"){

            public void run() {
                LogView.this.logPanel.removeTab();
            }
        };
        this.removeAction.setToolTipText("Remove LogTab");
        this.removeAction.setImageDescriptor(ConnectionPlugin.getImageDescriptorFromPlugin("icons/log/elcl18/remove_log.png"));
        this.removeAction.setDisabledImageDescriptor(ConnectionPlugin.getImageDescriptorFromPlugin("icons/log/dlcl18/remove_log.png"));
        this.editAction = new Action("Edit Tab"){

            public void run() {
                LogView.this.logPanel.editTab();
            }
        };
        this.editAction.setToolTipText("Edit LogTab");
        this.editAction.setImageDescriptor(ConnectionPlugin.getImageDescriptorFromPlugin("icons/log/elcl18/edit_log.png"));
        this.editAction.setDisabledImageDescriptor(ConnectionPlugin.getImageDescriptorFromPlugin("icons/log/dlcl18/edit_log.png"));
        this.scrollLockAction = new Action("Scroll Lock"){

            public void run() {
                LogView.this.scrollLockAction.setChecked(LogView.this.scrollLockAction.isChecked());
                LogView.this.logPanel.setScrollLock(LogView.this.scrollLockAction.isChecked());
            }
        };
        this.scrollLockAction.setToolTipText("Scroll Lock");
        this.scrollLockAction.setChecked(false);
        this.scrollLockAction.setImageDescriptor(ConnectionPlugin.getImageDescriptorFromPlugin("icons/log/elcl18/scroll_lock.png"));
        this.scrollLockAction.setDisabledImageDescriptor(ConnectionPlugin.getImageDescriptorFromPlugin("icons/log/dlcl18/scroll_lock.png"));
        this.exportAction = new Action("Export the log"){

            public void run() {
                LogView.this.logPanel.save();
            }
        };
        this.exportAction.setToolTipText("Export the log");
        this.exportAction.setImageDescriptor(ConnectionPlugin.getImageDescriptorFromPlugin("icons/log/elcl18/export_log.png"));
        this.exportAction.setDisabledImageDescriptor(ConnectionPlugin.getImageDescriptorFromPlugin("icons/log/dlcl18/export_log.png"));
        this.clearAction = new Action("Clear the log"){

            public void run() {
                LogView.this.logPanel.clear();
            }
        };
        this.clearAction.setToolTipText("Clear the log");
        this.clearAction.setImageDescriptor(ConnectionPlugin.getImageDescriptorFromPlugin("icons/log/elcl18/clear_log.png"));
        this.clearAction.setDisabledImageDescriptor(ConnectionPlugin.getImageDescriptorFromPlugin("icons/log/elcl18/clear_log.png"));
        this.encodingAction = new Action("Encoding", 4){

            public void run() {
            }
        };
        this.encodingAction.setToolTipText("Convert the log");
        this.encodingAction.setMenuCreator(new IMenuCreator(){

            public void dispose() {
            }

            public Menu getMenu(Control parent) {
                return null;
            }

            public Menu getMenu(Menu parent) {
                LogView.this.encodingListMenu = new Menu(parent);
                LogView.this.encodingListMenu.addMenuListener(new MenuListener(){

                    public void menuShown(MenuEvent e) {
                        LogTab selectedLogTab = LogView.this.logPanel.getSelectionLogTab();
                        if (selectedLogTab != null && (LogView.this.currentLogTab == null || LogView.this.currentLogTab != selectedLogTab)) {
                            LogView.this.uncheckAllMenuItem();
                            MenuItem matchedMenuItem = LogView.this.findMatchedMenuItem(selectedLogTab.getEncoding());
                            if (matchedMenuItem != null) {
                                matchedMenuItem.setSelection(true);
                            }
                            LogView.this.currentLogTab = selectedLogTab;
                        }
                    }

                    public void menuHidden(MenuEvent e) {
                    }
                });
                MenuItem autoEncodingItem = new MenuItem(LogView.this.encodingListMenu, 32);
                autoEncodingItem.setText("Auto");
                autoEncodingItem.setData((Object)EncodingChar.AUTO);
                allEncodingMenuItems.add(autoEncodingItem);
                autoEncodingItem.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        MenuItem menuItem = (MenuItem)e.getSource();
                        LogView.this.setMenuItemtoLogTab(menuItem, LogView.this.currentLogTab);
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                MenuItem manualEncodingItem = new MenuItem(LogView.this.encodingListMenu, 64);
                manualEncodingItem.setText("Manual");
                Menu encodingListManualMenu = new Menu(LogView.this.encodingListMenu);
                manualEncodingItem.setMenu(encodingListManualMenu);
                Region[] regions = Region.values();
                MenuItem[] encodingRegionMenuItems = new MenuItem[regions.length];
                Menu[] encodingRegionMenus = new Menu[regions.length];
                int i = 0;
                while (i < regions.length) {
                    encodingRegionMenuItems[i] = new MenuItem(encodingListManualMenu, 64);
                    encodingRegionMenuItems[i].setText(regions[i].getName());
                    encodingRegionMenus[i] = new Menu(encodingListManualMenu);
                    encodingRegionMenuItems[i].setMenu(encodingRegionMenus[i]);
                    ++i;
                }
                EncodingChar[] encodingCharArray = EncodingChar.values();
                int n = encodingCharArray.length;
                int n2 = 0;
                while (n2 < n) {
                    EncodingChar encodingChar = encodingCharArray[n2];
                    if (encodingChar != EncodingChar.AUTO) {
                        int i2 = 0;
                        while (i2 < regions.length) {
                            if (encodingChar.getRegion().equals((Object)regions[i2])) {
                                MenuItem encodingItem = new MenuItem(encodingRegionMenus[i2], 32);
                                encodingItem.setText(String.valueOf(encodingChar.getNation()) + " (" + encodingChar.getName() + ")");
                                encodingItem.setData((Object)encodingChar);
                                allEncodingMenuItems.add(encodingItem);
                                encodingItem.addSelectionListener(new SelectionListener(){

                                    public void widgetSelected(SelectionEvent e) {
                                        MenuItem menuItem = (MenuItem)e.getSource();
                                        LogView.this.setMenuItemtoLogTab(menuItem, LogView.this.currentLogTab);
                                    }

                                    public void widgetDefaultSelected(SelectionEvent e) {
                                    }
                                });
                                break;
                            }
                            ++i2;
                        }
                    }
                    ++n2;
                }
                return LogView.this.encodingListMenu;
            }
        });
        LogLevel[] levels = LogLevel.values();
        this.levelFilterActions = new Action[this.logLevelEnableIcons.length];
        int i = 0;
        while (i < this.levelFilterActions.length) {
            String name = levels[i].getName();
            this.levelFilterActions[i] = new Action(name, 2){

                public void run() {
                    int i = 0;
                    while (i < LogView.this.levelFilterActions.length) {
                        Action a = LogView.this.levelFilterActions[i];
                        if (a == this && LogView.this.logPanel.getSelectionLogTab() != null) {
                            if (a.isChecked()) {
                                a.setChecked(a.isChecked());
                            }
                            LogView.this.logPanel.changeLogLevelAndFilterMessages(i, a.isChecked());
                        }
                        ++i;
                    }
                }
            };
            this.levelFilterActions[i].setChecked(false);
            this.levelFilterActions[i].setToolTipText(name);
            this.levelFilterActions[i].setImageDescriptor(ConnectionPlugin.getImageDescriptorFromPlugin(this.logLevelEnableIcons[i]));
            this.levelFilterActions[i].setDisabledImageDescriptor(ConnectionPlugin.getImageDescriptorFromPlugin(this.logLevelDisableIcons[i]));
            ++i;
        }
        IActionBars actionBars = this.getViewSite().getActionBars();
        this.logPanel = new LogPanel(this.colors, actionBars);
        this.viewActions = new Action[]{this.addAction, this.removeAction, this.editAction, this.scrollLockAction, this.exportAction, this.clearAction, this.encodingAction};
        this.logPanel.setActions(this.levelFilterActions, this.viewActions);
        this.placeActions();
        this.logPanel.setActionsState(0, null);
        this.logPanel.createControl(this.parent);
        this.clipboard = new Clipboard(d);
        actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)new Action("Copy"){

            public void run() {
                LogView.this.logPanel.copy(LogView.this.clipboard);
            }
        });
        actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)new Action("Select All"){

            public void run() {
                LogView.this.logPanel.selectAll();
            }
        });
        this.getSite().getWorkbenchWindow().getPartService().addPartListener((IPartListener2)new LogViewPartListener(this.logPanel));
    }

    public void setMenuItemtoLogTab(MenuItem menuItem, LogTab logTab) {
        if (menuItem == null || logTab == null) {
            return;
        }
        EncodingChar selectedEncoding = logTab.getEncoding();
        if (menuItem.getData() == selectedEncoding) {
            return;
        }
        MenuItem selectedMenuItem = this.findMatchedMenuItem(selectedEncoding);
        if (selectedMenuItem != null) {
            selectedMenuItem.setSelection(false);
        }
        menuItem.setSelection(true);
        logTab.setEncoding((EncodingChar)((Object)menuItem.getData()));
        logTab.restart();
    }

    public void dispose() {
        if (this.clipboard != null && !this.clipboard.isDisposed()) {
            this.clipboard.dispose();
        }
        this.logPanel.stopAllTabItems();
        this.colors.dispose();
        super.dispose();
    }

    public void setFocus() {
        if (this.parent != null) {
            this.parent.setFocus();
        }
    }

    private void placeActions() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IMenuManager menuManager = actionBars.getMenuManager();
        menuManager.add((IAction)this.addAction);
        menuManager.add((IAction)this.removeAction);
        menuManager.add((IAction)this.editAction);
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.exportAction);
        menuManager.add((IAction)this.clearAction);
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.encodingAction);
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        toolBarManager.add((IContributionItem)new Separator());
        Action[] actionArray = this.levelFilterActions;
        int n = this.levelFilterActions.length;
        int n2 = 0;
        while (n2 < n) {
            Action filterActions = actionArray[n2];
            toolBarManager.add((IAction)filterActions);
            ++n2;
        }
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)this.addAction);
        toolBarManager.add((IAction)this.removeAction);
        toolBarManager.add((IAction)this.editAction);
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)this.scrollLockAction);
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)this.exportAction);
        toolBarManager.add((IAction)this.clearAction);
        toolBarManager.add((IContributionItem)new Separator());
    }

    public LogPanel getPanel() {
        return this.logPanel;
    }
}

