/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sign.signer;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import org.apache.xml.security.Init;
import org.apache.xml.security.exceptions.Base64DecodingException;
import org.apache.xml.security.utils.Base64;
import org.tizen.common.file.FileHandler;
import org.tizen.common.sign.model.ReferenceCache;
import org.tizen.common.sign.signer.AbstractResourceParser;
import org.tizen.common.util.Assert;

public class ReferenceCacheParser
extends AbstractResourceParser {
    public static final String FILENAME = ".manifest.tmp";
    private final String regExp = "^(.+)__DEL__(.+)$";
    protected final List<ReferenceCache> caches = new ArrayList<ReferenceCache>();

    public ReferenceCacheParser(FileHandler fileHandler) {
        super(fileHandler);
        Init.init();
    }

    @Override
    public void read(InputStreamReader isr) throws IOException {
        Assert.notNull((Object)isr);
        BufferedReader cacheReader = new BufferedReader(isr);
        ArrayList<ReferenceCache> list = new ArrayList<ReferenceCache>();
        String line = null;
        while ((line = cacheReader.readLine()) != null) {
            ReferenceCache parsedCache = this.parseCache(line);
            this.validate(parsedCache, line);
            list.add(parsedCache);
        }
        this.caches.clear();
        this.caches.addAll(list);
        this.read = true;
    }

    @Override
    public void write(OutputStreamWriter osw) throws IOException {
        Assert.notNull((Object)osw);
        BufferedWriter cacheWriter = new BufferedWriter(osw);
        for (ReferenceCache cache : this.caches) {
            cacheWriter.append(cache.getUri());
            cacheWriter.append("__DEL__");
            cacheWriter.append(Base64.encode((byte[])cache.getDigestValue()));
            cacheWriter.newLine();
        }
        cacheWriter.flush();
    }

    public void update(ReferenceCache cache) {
        Assert.notNull((Object)cache);
        Assert.hasText((String)cache.getUri());
        byte[] digestValue = cache.getDigestValue();
        Assert.notNull((Object)digestValue);
        Assert.hasText((String)new String(digestValue));
        for (ReferenceCache inCache : this.caches) {
            if (!inCache.getUri().equals(cache.getUri())) continue;
            int indexOf = this.caches.indexOf(inCache);
            this.caches.set(indexOf, cache);
            return;
        }
        this.caches.add(cache);
    }

    public void remove(String uri) {
        Assert.notNull((Object)uri);
        ReferenceCache cache = this.getCache(uri);
        if (cache != null) {
            this.caches.remove(cache);
        }
    }

    public int getSize() {
        return this.caches.size();
    }

    public ReferenceCache[] getCaches() {
        return this.caches.toArray(new ReferenceCache[0]);
    }

    public ReferenceCache getCache(String uri) {
        for (ReferenceCache cache : this.caches) {
            if (!cache.getUri().equals(uri)) continue;
            return cache;
        }
        return null;
    }

    protected ReferenceCache parseCache(String line) throws IOException {
        try {
            Matcher matcher = this.getMatcher(line);
            if (matcher.matches()) {
                String uri = matcher.group(1);
                String digestString = matcher.group(2);
                return new ReferenceCache(uri, Base64.decode((String)digestString));
            }
            return null;
        }
        catch (Base64DecodingException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    protected boolean validate(ReferenceCache cache, String line) throws IOException {
        if (cache == null) {
            throw new IOException("Failed to parse a reference cache resource: " + line);
        }
        if (Arrays.equals(cache.getDigestValue(), "".getBytes())) {
            throw new IOException("DigestValue is not correct: " + line);
        }
        return true;
    }

    @Override
    public String getResourceName() {
        return FILENAME;
    }

    @Override
    protected String getRegExp() {
        return "^(.+)__DEL__(.+)$";
    }
}

