/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.lv.manager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.tizen.common.lv.manager.LVLocaleManager;
import org.tizen.common.lv.model.LVLocaleVO;
import org.tizen.common.lv.model.LVStringVO;

public class LVStringManager {
    private IProject project;
    private Map<LVLocaleVO, List<LVStringVO>> localizedStringMap = new HashMap<LVLocaleVO, List<LVStringVO>>();

    public LVStringManager() {
    }

    public LVStringManager(IProject project) {
        this();
        this.project = project;
        this.localizedStringMap.put(LVLocaleManager.defaultLocale, new ArrayList());
    }

    public IProject getProject() {
        return this.project;
    }

    public List<LVStringVO> getDefaultList() {
        return this.localizedStringMap.get(LVLocaleManager.defaultLocale);
    }

    public List<LVStringVO> getList(LVLocaleVO locale) {
        if (!this.localizedStringMap.containsKey(locale)) {
            this.localizedStringMap.put(locale, new ArrayList());
        }
        return this.localizedStringMap.get(locale);
    }

    public List<LVStringVO> getList(String id) {
        ArrayList<LVStringVO> list = new ArrayList<LVStringVO>();
        Set<LVLocaleVO> localeSet = this.localizedStringMap.keySet();
        for (LVLocaleVO locale : localeSet) {
            for (LVStringVO svo : this.localizedStringMap.get(locale)) {
                if (!id.equals(svo.getId())) continue;
                list.add(svo);
            }
        }
        return list;
    }

    public boolean add(LVStringVO targetSVO) {
        boolean result = false;
        boolean hasDuplicated = false;
        if (this.localizedStringMap.containsKey(targetSVO.getLocale())) {
            List<LVStringVO> svoList = this.localizedStringMap.get(targetSVO.getLocale());
            for (LVStringVO svo : svoList) {
                if (!targetSVO.getId().equals(svo.getId())) continue;
                hasDuplicated = true;
                if (svo.getValue().equals(targetSVO.getValue())) break;
                svo.setValue(targetSVO.getValue());
                break;
            }
            if (!hasDuplicated) {
                svoList.add(targetSVO);
                result = true;
            }
        } else {
            ArrayList<LVStringVO> list = new ArrayList<LVStringVO>();
            list.add(targetSVO);
            this.localizedStringMap.put(targetSVO.getLocale(), list);
            result = true;
        }
        return result;
    }

    public boolean update(LVStringVO before, LVStringVO after) {
        boolean result = false;
        if (this.delete(before.getLocale(), before.getId()) && this.add(after)) {
            result = true;
        }
        return result;
    }

    public void delete(LVLocaleVO targetLocale) {
        if (this.localizedStringMap.containsKey(targetLocale)) {
            List<LVStringVO> list = this.localizedStringMap.get(targetLocale);
            list.clear();
            this.localizedStringMap.remove(targetLocale);
        }
    }

    public void delete(String id) {
        for (LVLocaleVO locale : this.localizedStringMap.keySet()) {
            this.delete(locale, id);
        }
    }

    private boolean delete(LVLocaleVO locale, String id) {
        boolean result = false;
        if (this.localizedStringMap.containsKey(locale)) {
            List<LVStringVO> svoList = this.localizedStringMap.get(locale);
            Iterator<LVStringVO> iter = svoList.iterator();
            while (iter.hasNext()) {
                LVStringVO svo = iter.next();
                if (!svo.getId().equals(id)) continue;
                iter.remove();
                result = true;
                break;
            }
        }
        return result;
    }

    public void clear() {
        this.project = null;
        this.localizedStringMap.clear();
    }
}

