/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.lv.model;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.swt.graphics.Image;
import org.tizen.common.lv.LvPlugin;
import org.tizen.common.util.ImageUtil;

public class LVLocaleVO {
    private String languageTag;
    private String language;
    private String region;
    private Image flag;

    public LVLocaleVO() {
        this.languageTag = "default";
        this.language = "";
        this.region = "";
        this.flag = null;
    }

    public LVLocaleVO(String languageTag, String language, String region) {
        this.languageTag = languageTag;
        this.language = language;
        this.region = region;
        try {
            String[] langTags = languageTag.split("-");
            String flag = langTags.length == 2 ? String.format("icons/flags/%s/flag.png", langTags[1]) : String.format("icons/flags/lang/%s.png", langTags[0]);
            this.flag = ImageUtil.getImage((Plugin)LvPlugin.getDefault(), (String)flag);
        }
        catch (Exception exception) {
            this.flag = null;
        }
    }

    public String getLanguageTag() {
        return this.languageTag;
    }

    public void setLanguageTag(String languageTag) {
        this.languageTag = languageTag;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public Image getFlag() {
        return this.flag;
    }

    public void setFlag(Image flag) {
        this.flag = flag;
    }

    public String getDetail() {
        if ("".equals(this.language) && "".equals(this.region)) {
            return "default localized contents";
        }
        return String.format("%s [%s]", this.language, this.region);
    }

    public boolean equals(LVLocaleVO lvo) {
        boolean result = false;
        result = this.languageTag.equals(lvo.getLanguageTag());
        return result;
    }
}

