/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.lv.ui.helper;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.tizen.common.lv.model.LVStringVO;
import org.tizen.common.lv.ui.LVLocalizationTab;
import org.tizen.common.lv.ui.helper.LVDefaultStringListener;

public class LVStringEditingSupport
extends EditingSupport {
    private TableViewer viewer = null;
    private int index = 0;
    private TextCellEditor textEditor = null;
    private LVDefaultStringListener listener = null;

    public LVStringEditingSupport(TableViewer viewer, int index, LVDefaultStringListener listener) {
        super((ColumnViewer)viewer);
        this.viewer = viewer;
        this.index = index;
        this.textEditor = new TextCellEditor((Composite)viewer.getTable());
        this.listener = listener;
    }

    protected boolean canEdit(Object arg0) {
        boolean canEdit = true;
        if (this.index == 0) {
            canEdit = false;
        }
        return canEdit;
    }

    protected CellEditor getCellEditor(Object arg0) {
        return this.textEditor;
    }

    protected Object getValue(Object element) {
        LVStringVO svo = this.castLVStringVO(element);
        String value = "";
        if (svo != null) {
            switch (this.index) {
                case 0: {
                    if (LVLocalizationTab.KEY_MODE) {
                        value = svo.getLocale().getLanguageTag();
                        break;
                    }
                    value = svo.getId();
                    break;
                }
                case 1: {
                    value = svo.getValue();
                }
            }
        }
        return value;
    }

    protected void setValue(Object element, Object value) {
        LVStringVO svo = this.castLVStringVO(element);
        if (svo != null) {
            switch (this.index) {
                case 0: {
                    if (!LVLocalizationTab.KEY_MODE) break;
                    svo.setId((String)value);
                    break;
                }
                case 1: {
                    String val = (String)value;
                    this.listener.stringValueChanged(svo, val);
                }
            }
        }
        this.viewer.update(element, null);
    }

    private LVStringVO castLVStringVO(Object element) {
        LVStringVO svo = null;
        if (element instanceof LVStringVO) {
            svo = (LVStringVO)element;
        }
        return svo;
    }
}

