/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.sdblib.service;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.tizen.sdb.command.CrashReport;
import org.tizen.sdblib.ICrashReportServiceListener;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.IDeviceChangeListener;
import org.tizen.sdblib.SdbHelper;
import org.tizen.sdblib.SdbResponse;
import org.tizen.sdblib.SmartDevelopmentBridge;
import org.tizen.sdblib.daemon.AbstractServer;
import org.tizen.sdblib.exception.ServerException;
import org.tizen.sdblib.util.DeviceUtil;
import org.tizen.sdblib.util.IOUtil;
import org.tizen.sdblib.util.Log;
import org.tizen.sdblib.util.ThreadUtil;

public class CrashReportService
extends AbstractServer
implements IDeviceChangeListener {
    protected static CrashReportService crService = null;
    protected final LinkedHashSet<ICrashReportServiceListener> listeners = new LinkedHashSet();
    protected Selector selector = null;

    private CrashReportService() {
        super("CS Report Service");
    }

    public static CrashReportService getDefault() {
        if (crService == null) {
            crService = new CrashReportService();
        }
        return crService;
    }

    protected void initReportChannel() {
        IDevice[] devices;
        IDevice[] iDeviceArray = devices = SmartDevelopmentBridge.getBridge().getDevices();
        int n = devices.length;
        int n2 = 0;
        while (n2 < n) {
            IDevice device = iDeviceArray[n2];
            if (DeviceUtil.isOnline(device)) {
                this.registerReportChannel(device);
            }
            ++n2;
        }
    }

    protected void registerReportChannel(IDevice device) {
        if (SmartDevelopmentBridge.getBridge() != null && !SmartDevelopmentBridge.getBridge().isTims()) {
            this.registerReportChannelForPrev(device);
            return;
        }
        CrashReport reporter = new CrashReport(device.getSerialNumber());
        SocketChannel channel = null;
        try {
            channel = reporter.openChannel();
        }
        catch (IOException e1) {
            Log.e("sdb", "failed to open a socket channel:" + e1);
            return;
        }
        if (channel == null) {
            Log.e("sdb", "failed to open a socket channel");
            return;
        }
        Log.i("sdb", "registering CS Report Service");
        Attachment att = new Attachment(reporter, device);
        try {
            this.selector.wakeup();
            channel.register(this.selector, 1, att);
            Log.i("sdb", "registered CS Report Service");
        }
        catch (IOException iOException) {
            IOUtil.tryClose(channel);
        }
    }

    private void registerReportChannelForPrev(IDevice device) {
        SocketChannel channel = null;
        try {
            channel = SmartDevelopmentBridge.getBridge().openChannel();
            SdbHelper.initializeDevice(channel, device.getSerialNumber());
            byte[] request = SdbHelper.formSdbRequest("cs:");
            SdbHelper.write(channel, request);
            SdbResponse resp = SdbHelper.readSdbResponse(channel);
            if (!resp.okay) {
                Log.e("sdb", "got unhappy response from sdb cs req: " + resp.message);
                IOUtil.tryClose(channel);
                return;
            }
            Log.i("sdb", "registering CS Report Service");
            this.selector.wakeup();
            channel.register(this.selector, 1, device);
            Log.i("sdb", "registered CS Report Service");
        }
        catch (IOException e) {
            e.printStackTrace();
            Log.e("sdb", "failed to open a socket channel");
            IOUtil.tryClose(channel);
        }
    }

    private void read(SelectionKey key) {
        if (SmartDevelopmentBridge.getBridge() != null && !SmartDevelopmentBridge.getBridge().isTims()) {
            this.readForPrev(key);
            return;
        }
        Attachment att = (Attachment)key.attachment();
        boolean success = false;
        try {
            success = att.reporter().read();
        }
        catch (IOException e) {
            Log.e("sdb", e.getMessage());
            key.cancel();
            IOUtil.tryClose(key.channel());
            return;
        }
        if (success) {
            this.notifyAllListeners(att.device(), att.reporter().getPath());
        } else {
            key.cancel();
            IOUtil.tryClose(key.channel());
        }
    }

    private void readForPrev(SelectionKey key) {
        SocketChannel sc = (SocketChannel)key.channel();
        try {
            ByteBuffer reply = ByteBuffer.allocate(124);
            int len = sc.read(reply);
            Log.i("sdb", "read byte :" + len);
            if (len > 0) {
                reply.flip();
                this.notifyAllListeners((IDevice)key.attachment(), SdbHelper.UTF_CHARSET.decode(reply).toString());
            } else if (len < 0) {
                key.cancel();
                IOUtil.tryClose(sc);
            }
        }
        catch (IOException e) {
            key.cancel();
            Log.e("sdb", "read failed :" + e);
            IOUtil.tryClose(sc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyAllListeners(IDevice device, String path) {
        Log.i("sdb", "cs file is created and notify from " + device.getSerialNumber());
        Collection temp = null;
        CrashReportService crashReportService = this;
        synchronized (crashReportService) {
            temp = (Collection)this.listeners.clone();
        }
        for (ICrashReportServiceListener listener : temp) {
            try {
                listener.fileCreated(device, path);
            }
            catch (Exception e) {
                Log.e("sdb", "unexpected error occurred :" + e);
            }
        }
    }

    public synchronized void addCrashReportServiceListener(ICrashReportServiceListener listener) {
        this.listeners.add(listener);
    }

    public synchronized void removeCrashReportServiceListener(ICrashReportServiceListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void onConnected(IDevice device) {
        if (DeviceUtil.isOnline(device)) {
            Log.i("sdb", "welcome to new connection :" + device.getSerialNumber());
            this.registerReportChannel(device);
        }
    }

    @Override
    public void onDisconnected(IDevice device) {
        Log.i("sdb", "bye!:" + device.getSerialNumber());
    }

    @Override
    public void onChanged(IDevice device, int changeMask) {
        if (changeMask == 1) {
            this.onConnected(device);
        }
    }

    @Override
    protected void initialize() throws ServerException {
        try {
            Log.i("sdb", "starting CS Report Service");
            this.selector = Selector.open();
            SmartDevelopmentBridge.addDeviceChangeListener(this);
            this.initReportChannel();
        }
        catch (IOException e) {
            throw new ServerException(e);
        }
    }

    @Override
    protected void process() throws Exception {
        Log.d("crashreport", "Wait any response");
        if (this.selector.select() <= 0) {
            ThreadUtil.trySleep(50L);
            return;
        }
        Iterator<SelectionKey> iter = this.selector.selectedKeys().iterator();
        while (iter.hasNext()) {
            SelectionKey key = iter.next();
            Log.d("crashreport", "Iteration: " + key.interestOps());
            if (key.isConnectable()) {
                SocketChannel sc = (SocketChannel)key.channel();
                if (sc.isConnectionPending()) {
                    sc.finishConnect();
                }
            } else if (key.isReadable()) {
                this.read(key);
            }
            iter.remove();
        }
    }

    @Override
    protected void terminate() {
        SmartDevelopmentBridge.removeDeviceChangeListener(this);
        IOUtil.tryClose(this.selector);
    }

    class Attachment {
        CrashReport reporter = null;
        IDevice device = null;

        public Attachment(CrashReport reporter, IDevice device) {
            this.reporter = reporter;
            this.device = device;
        }

        public IDevice device() {
            return this.device;
        }

        public CrashReport reporter() {
            return this.reporter;
        }
    }
}

