/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.connection.logview.controller;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import org.tizen.common.connection.logview.controller.ImageButton;
import org.tizen.common.connection.logview.resources.ImageKind;

public class DeviceCheckBox
extends ImageButton {
    private final Label textLabel;

    public DeviceCheckBox() {
        this("");
    }

    public DeviceCheckBox(String text) {
        super(ImageKind.CHECK_NOR, ImageKind.CHECK_NOR_HOVER, ImageKind.CHECK_NOR_FOCUSED, ImageKind.CHECK_SEL, ImageKind.CHECK_SEL_HOVER, ImageKind.CHECK_SEL_FOCUSED);
        this.textLabel = new Label(text);
        this.pane.add((Node)this.textLabel, 1, 0);
        this.pane.setHgap(5.0);
        this.stateProperty.addListener((ChangeListener)new ChangeListener<ImageButton.BUTTON_STATE>(){

            public void changed(ObservableValue<? extends ImageButton.BUTTON_STATE> arg0, ImageButton.BUTTON_STATE arg1, ImageButton.BUTTON_STATE arg2) {
                switch (arg2) {
                    case NORMAL: 
                    case SELECT_NORMAL: {
                        DeviceCheckBox.this.textLabel.setStyle("-fx-text-fill: #464646");
                        break;
                    }
                    case HOVER: 
                    case PRESS: 
                    case SELECT_HOVER: 
                    case SELECT_PRESS: {
                        DeviceCheckBox.this.textLabel.setStyle("-fx-text-fill: #000000");
                        break;
                    }
                }
            }
        });
    }

    public void setSpacing(double spacing) {
        this.pane.setHgap(spacing);
    }

    public void setText(String text) {
        this.textLabel.setText(text);
    }

    public String getText() {
        return this.textLabel.getText();
    }

    public void setToolTip(String text) {
        this.textLabel.setTooltip(new Tooltip(text));
    }

    public void setPrefHeight(int height) {
        this.pane.setPrefHeight((double)height);
    }
}

