/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.connection.sdblib.dnd;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.sdblib.service.FileEntry;

public class FileEntryTransfer
extends ByteArrayTransfer {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static FileEntryTransfer instance = new FileEntryTransfer();
    private static final String TYPE_NAME = "sdb-transfer-format";
    private static final int TYPE_ID = FileEntryTransfer.registerType((String)"sdb-transfer-format");

    private FileEntryTransfer() {
    }

    public static FileEntryTransfer getInstance() {
        return instance;
    }

    protected int[] getTypeIds() {
        return new int[]{TYPE_ID};
    }

    protected String[] getTypeNames() {
        return new String[]{TYPE_NAME};
    }

    public byte[] toByteArray(FileEntry[] entries) {
        byte[] bytes;
        block17: {
            ByteArrayOutputStream byteOut = null;
            FilterOutputStream out = null;
            bytes = null;
            try {
                try {
                    byteOut = new ByteArrayOutputStream();
                    out = new DataOutputStream(byteOut);
                    ((DataOutputStream)out).writeInt(entries.length);
                    int i = 0;
                    while (i < entries.length) {
                        FileEntry data = entries[i];
                        try {
                            ((DataOutputStream)out).writeUTF(data.getFullPath());
                        }
                        catch (IOException e1) {
                            this.logger.error("Failed to write", (Throwable)e1);
                        }
                        ++i;
                    }
                    bytes = byteOut.toByteArray();
                }
                catch (IOException e) {
                    this.logger.error("Failed to write", (Throwable)e);
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
        return bytes;
    }

    /*
     * Loose catch block
     */
    public String[] fromByteArray(byte[] bytes) {
        String[] stringArray;
        FilterInputStream in;
        block12: {
            in = null;
            in = new DataInputStream(new ByteArrayInputStream(bytes));
            int n = ((DataInputStream)in).readInt();
            String[] paths = new String[n];
            int i = 0;
            while (i < n) {
                String path;
                paths[i] = path = ((DataInputStream)in).readUTF();
                ++i;
            }
            stringArray = paths;
            if (in == null) break block12;
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        return stringArray;
        catch (IOException e) {
            block13: {
                try {
                    this.logger.error("Failed to read an int", (Throwable)e);
                    if (in == null) break block13;
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            return null;
        }
    }
}

