/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.multiChoice;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.mihalis.opal.multiChoice.MultiChoiceSelectionListener;
import org.mihalis.opal.utils.SimpleSelectionAdapter;

public class MultiChoice<T>
extends Composite {
    private Label text;
    private Button arrow;
    private Shell popup;
    private Listener listener;
    private Listener filter;
    private int numberOfColumns = 2;
    private List<T> elements;
    private Set<T> selection;
    private List<Button> checkboxes;
    private boolean hasFocus;
    private MultiChoiceSelectionListener<T> selectionListener;
    private T lastModified;
    private Color foreground;
    private Color background;
    private Font font;
    private String separator;

    public MultiChoice(Composite parent, int style) {
        this(parent, style, null);
    }

    public MultiChoice(Composite parent, int style, List<T> elements) {
        super(parent, style);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        this.setLayout((Layout)gridLayout);
        this.text = new Label((Composite)this, 2060);
        this.text.setBackground(this.getDisplay().getSystemColor(25));
        this.text.setLayoutData((Object)new GridData(4, 4, true, false));
        this.arrow = new Button((Composite)this, 131076);
        this.arrow.setLayoutData((Object)new GridData(4, 4, false, false));
        this.listener = new Listener(){

            public void handleEvent(Event event) {
                if (MultiChoice.this.popup == event.widget) {
                    MultiChoice.this.popupEvent(event);
                    return;
                }
                if (MultiChoice.this.arrow == event.widget) {
                    MultiChoice.this.buttonEvent(event);
                    return;
                }
                if (MultiChoice.this == event.widget) {
                    MultiChoice.this.multiChoiceEvent(event);
                    return;
                }
                if (MultiChoice.this.getShell() == event.widget) {
                    MultiChoice.this.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (MultiChoice.this.isDisposed()) {
                                return;
                            }
                            MultiChoice.this.handleFocus(16);
                        }
                    });
                }
            }
        };
        int[] multiChoiceEvent = new int[]{12, 10, 11};
        int i = 0;
        while (i < multiChoiceEvent.length) {
            this.addListener(multiChoiceEvent[i], this.listener);
            ++i;
        }
        int[] buttonEvents = new int[]{13, 15};
        int i2 = 0;
        while (i2 < buttonEvents.length) {
            this.arrow.addListener(buttonEvents[i2], this.listener);
            ++i2;
        }
        this.filter = new Listener(){

            public void handleEvent(Event event) {
                Shell shell = ((Control)event.widget).getShell();
                if (shell == MultiChoice.this.getShell()) {
                    MultiChoice.this.handleFocus(16);
                }
            }
        };
        this.selection = new LinkedHashSet<T>();
        this.elements = elements;
        this.separator = ",";
        this.createPopup();
        this.setLabel();
    }

    public void add(T value) {
        this.checkWidget();
        if (value == null) {
            SWT.error((int)4);
        }
        if (this.elements == null) {
            this.elements = new ArrayList<T>();
        }
        this.elements.add(value);
        this.refresh();
    }

    public void add(T value, int index) {
        this.checkWidget();
        this.checkNullElement();
        if (value == null) {
            SWT.error((int)4);
        }
        this.checkRange(index);
        this.elements.add(index, value);
        this.refresh();
    }

    public void addAll(List<T> values) {
        this.checkWidget();
        if (values == null) {
            SWT.error((int)4);
        }
        if (this.elements == null) {
            this.elements = new ArrayList<T>();
        }
        this.elements.addAll(values);
        this.refresh();
    }

    public void addAll(T[] values) {
        this.checkWidget();
        if (values == null) {
            SWT.error((int)4);
        }
        if (this.elements == null) {
            this.elements = new ArrayList<T>();
        }
        T[] TArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            T value = TArray[n2];
            this.elements.add(value);
            ++n2;
        }
        this.refresh();
    }

    public T getItem(int index) {
        this.checkWidget();
        this.checkNullElement();
        this.checkRange(index);
        return this.elements.get(index);
    }

    public int getItemCount() {
        this.checkWidget();
        if (this.elements == null) {
            return 0;
        }
        return this.elements.size();
    }

    public List<T> getItems() {
        this.checkWidget();
        if (this.elements == null) {
            return null;
        }
        return new ArrayList<T>(this.elements);
    }

    public void removeAt(int index) {
        this.checkWidget();
        this.checkNullElement();
        this.checkRange(index);
        T removedElement = this.elements.remove(index);
        this.selection.remove(removedElement);
        this.refresh();
    }

    public void remove(T object) {
        if (object == null) {
            SWT.error((int)4);
        }
        this.checkWidget();
        this.checkNullElement();
        this.elements.remove(object);
        this.selection.remove(object);
        this.refresh();
    }

    public void removeAll() {
        this.checkWidget();
        this.checkNullElement();
        if (this.elements != null) {
            this.elements.clear();
        }
        this.selection.clear();
        this.refresh();
    }

    public void setSelection(Set<T> selection) {
        this.checkWidget();
        this.checkNullElement();
        if (selection == null) {
            SWT.error((int)4);
        }
        this.selection = selection;
        this.updateSelection();
    }

    public void selectAll() {
        this.checkWidget();
        this.checkNullElement();
        this.selection.addAll(this.elements);
        this.updateSelection();
    }

    public void selectAt(int index) {
        this.checkWidget();
        this.checkNullElement();
        this.checkRange(index);
        this.selection.add(this.elements.get(index));
        this.updateSelection();
    }

    public void select(T value) {
        this.checkWidget();
        this.checkNullElement();
        if (!this.elements.contains(value)) {
            throw new IllegalArgumentException("Value not present in the widget");
        }
        this.selection.add(value);
        this.updateSelection();
    }

    public void setSelectedIndex(int[] index) {
        this.checkWidget();
        this.checkNullElement();
        int[] nArray = index;
        int n = index.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            this.checkRange(i);
            this.selection.add(this.elements.get(i));
            ++n2;
        }
        this.updateSelection();
    }

    public int[] getSelectedIndex() {
        this.checkWidget();
        this.checkNullElement();
        ArrayList<Integer> selectedIndex = new ArrayList<Integer>();
        int i = 0;
        while (i < this.elements.size()) {
            if (this.selection.contains(this.elements.get(i))) {
                selectedIndex.add(i);
            }
            ++i;
        }
        int[] returned = new int[selectedIndex.size()];
        int i2 = 0;
        while (i2 < selectedIndex.size()) {
            returned[i2] = (Integer)selectedIndex.get(i2);
            ++i2;
        }
        return returned;
    }

    public List<T> getSelection() {
        this.checkWidget();
        this.checkNullElement();
        return new ArrayList<T>(this.selection);
    }

    public void deselectAt(int index) {
        this.checkWidget();
        this.checkNullElement();
        if (index < 0 || index >= this.elements.size()) {
            SWT.error((int)6);
        }
        this.selection.remove(index);
        this.updateSelection();
    }

    public void deselect(T value) {
        this.checkWidget();
        this.checkNullElement();
        this.selection.remove(value);
        this.updateSelection();
    }

    public void deselectAll() {
        this.checkWidget();
        this.checkNullElement();
        this.selection.clear();
        this.updateSelection();
    }

    public int getNumberOfColumns() {
        this.checkWidget();
        return this.numberOfColumns;
    }

    public void setNumberOfColumns(int numberOfColumns) {
        this.checkWidget();
        this.numberOfColumns = numberOfColumns;
        this.popup.dispose();
        this.popup = null;
        this.createPopup();
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public Color getForeground() {
        return this.foreground;
    }

    public void setForeground(Color foreground) {
        this.foreground = foreground;
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color background) {
        this.background = background;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void refresh() {
        this.checkWidget();
        this.popup.dispose();
        this.popup = null;
        this.createPopup();
        this.updateSelection();
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        int height = 0;
        GC gc = new GC((Drawable)this.text);
        int spacer = gc.stringExtent((String)" ").x;
        int textWidth = gc.stringExtent((String)this.text.getText()).x;
        gc.dispose();
        Point textSize = this.text.computeSize(-1, -1, changed);
        Point arrowSize = this.arrow.computeSize(-1, -1, changed);
        int borderWidth = this.getBorderWidth();
        height = Math.max(textSize.y, arrowSize.y);
        width = textWidth + 2 * spacer + arrowSize.x + 2 * borderWidth;
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        return new Point(width + 2 * borderWidth, height + 2 * borderWidth);
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        this.arrow.setEnabled(enabled);
        this.text.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    public void setToolTipText(String txt) {
        this.checkWidget();
        this.text.setToolTipText(txt);
    }

    public SelectionListener getSelectionListener() {
        this.checkWidget();
        return this.selectionListener;
    }

    public void setSelectionListener(MultiChoiceSelectionListener<T> selectionListener) {
        this.checkWidget();
        this.selectionListener = selectionListener;
        this.refresh();
    }

    public void updateSelection() {
        this.checkWidget();
        if (this.isDisposed()) {
            return;
        }
        if (this.popup == null || this.popup.isDisposed()) {
            return;
        }
        int i = 0;
        while (i < this.checkboxes.size()) {
            Button currentButton = this.checkboxes.get(i);
            if (!currentButton.isDisposed()) {
                Object content = currentButton.getData();
                currentButton.setSelection(this.selection.contains(content));
            }
            ++i;
        }
        this.setLabel();
    }

    T getLastModified() {
        return this.lastModified;
    }

    Shell getPopup() {
        return this.popup;
    }

    private void createPopup() {
        this.popup = new Shell(this.getShell(), 16392);
        this.popup.setLayout((Layout)new GridLayout(this.numberOfColumns, true));
        int[] popupEvents = new int[]{21, 9, 27, 12};
        int i = 0;
        while (i < popupEvents.length) {
            this.popup.addListener(popupEvents[i], this.listener);
            ++i;
        }
        if (this.elements == null) {
            return;
        }
        this.checkboxes = new ArrayList<Button>(this.elements.size());
        for (final T o : this.elements) {
            final Button checkBoxButton = new Button((Composite)this.popup, 32);
            if (this.font != null) {
                checkBoxButton.setFont(this.font);
            }
            if (this.foreground != null) {
                checkBoxButton.setForeground(this.foreground);
            }
            if (this.background != null) {
                checkBoxButton.setBackground(this.background);
            }
            checkBoxButton.setData(o);
            checkBoxButton.setLayoutData((Object)new GridData(1, 2, false, false));
            checkBoxButton.setText(o.toString());
            checkBoxButton.addSelectionListener((SelectionListener)new SimpleSelectionAdapter(){

                @Override
                public void handle(SelectionEvent e) {
                    if (checkBoxButton.getSelection()) {
                        MultiChoice.this.selection.add(o);
                    } else {
                        MultiChoice.this.selection.remove(o);
                    }
                    MultiChoice.this.lastModified = o;
                    MultiChoice.this.setLabel();
                }
            });
            if (this.selectionListener != null) {
                checkBoxButton.addSelectionListener(this.selectionListener);
            }
            checkBoxButton.setSelection(this.selection.contains(o));
            this.checkboxes.add(checkBoxButton);
        }
        this.popup.layout();
    }

    private void setLabel() {
        if (this.checkboxes == null) {
            this.text.setText("");
            return;
        }
        ArrayList<String> values = new ArrayList<String>();
        for (Button current : this.checkboxes) {
            if (!current.getSelection()) continue;
            values.add(current.getText());
        }
        StringBuffer sb = new StringBuffer();
        Iterator it = values.iterator();
        while (it.hasNext()) {
            sb.append((String)it.next());
            if (!it.hasNext()) continue;
            sb.append(this.separator);
        }
        this.text.setText(sb.toString());
    }

    private void handleFocus(int type) {
        if (this.isDisposed()) {
            return;
        }
        switch (type) {
            case 15: {
                if (this.hasFocus) {
                    return;
                }
                this.hasFocus = true;
                Shell shell = this.getShell();
                shell.removeListener(27, this.listener);
                shell.addListener(27, this.listener);
                Display display = this.getDisplay();
                display.removeFilter(15, this.filter);
                display.addFilter(15, this.filter);
                Event e = new Event();
                this.notifyListeners(15, e);
                break;
            }
            case 16: {
                if (!this.hasFocus) {
                    return;
                }
                Control focusControl = this.getDisplay().getFocusControl();
                if (focusControl == this.arrow) {
                    return;
                }
                this.hasFocus = false;
                Shell shell = this.getShell();
                shell.removeListener(27, this.listener);
                Display display = this.getDisplay();
                display.removeFilter(15, this.filter);
                Event e = new Event();
                this.notifyListeners(16, e);
                break;
            }
        }
    }

    private void multiChoiceEvent(Event event) {
        switch (event.type) {
            case 12: {
                if (this.popup != null && !this.popup.isDisposed()) {
                    this.popup.dispose();
                }
                Shell shell = this.getShell();
                shell.removeListener(27, this.listener);
                Display display = this.getDisplay();
                display.removeFilter(15, this.filter);
                this.popup = null;
                this.arrow = null;
                break;
            }
            case 10: {
                this.dropDown(false);
                break;
            }
            case 11: {
                if (!this.isDropped()) break;
                this.dropDown(false);
                break;
            }
        }
    }

    private void buttonEvent(Event event) {
        switch (event.type) {
            case 15: {
                this.handleFocus(15);
                break;
            }
            case 13: {
                this.dropDown(!this.isDropped());
                break;
            }
        }
    }

    private boolean isDropped() {
        return !this.popup.isDisposed() && this.popup.getVisible();
    }

    private void popupEvent(Event event) {
        switch (event.type) {
            case 9: {
                Rectangle listRect = this.popup.getBounds();
                Color black = this.getDisplay().getSystemColor(2);
                event.gc.setForeground(black);
                event.gc.drawRectangle(0, 0, listRect.width - 1, listRect.height - 1);
                break;
            }
            case 21: {
                event.doit = false;
                this.dropDown(false);
                break;
            }
            case 27: {
                this.dropDown(false);
                break;
            }
            case 12: {
                if (this.checkboxes != null) {
                    this.checkboxes.clear();
                }
                this.checkboxes = null;
                break;
            }
        }
    }

    private void dropDown(boolean drop) {
        if (drop == this.isDropped()) {
            return;
        }
        if (!drop) {
            this.popup.setVisible(false);
            if (!this.isDisposed()) {
                this.text.setFocus();
            }
            return;
        }
        if (this.getShell() != this.popup.getParent()) {
            this.popup.dispose();
            this.popup = null;
            this.createPopup();
        }
        Point arrowRect = this.arrow.toDisplay(this.arrow.getSize().x - 5, this.arrow.getSize().y + this.arrow.getBorderWidth() - 3);
        int x = arrowRect.x;
        int y = arrowRect.y;
        Rectangle displayRect = this.getMonitor().getClientArea();
        Rectangle parentRect = this.getDisplay().map((Control)this.getParent(), null, this.getBounds());
        this.popup.pack();
        int width = this.popup.getBounds().width;
        int height = this.popup.getBounds().height;
        if (y + height > displayRect.y + displayRect.height) {
            y = parentRect.y - height;
        }
        if (x + width > displayRect.x + displayRect.width) {
            x = displayRect.x + displayRect.width - width;
        }
        this.popup.setLocation(x, y);
        this.popup.setVisible(true);
        this.popup.setFocus();
    }

    private void checkNullElement() {
        if (this.elements == null) {
            throw new NullPointerException("There is no element associated to this widget");
        }
    }

    private void checkRange(int index) throws NullPointerException {
        this.checkNullElement();
        if (index < 0 || index >= this.elements.size()) {
            SWT.error((int)6);
        }
    }
}

