/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.opalDialog;

import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.mihalis.opal.opalDialog.Dialog;
import org.mihalis.opal.opalDialog.DialogArea;
import org.mihalis.opal.utils.ResourceManager;

public class FooterArea
extends DialogArea {
    private Image icon;
    private String footerText;
    private List<String> buttonLabels;
    private int defaultButtonIndex;
    private int timer = -1;
    private int timerIndexButton = -1;
    private int selectedButtonIndex = -1;
    private String collapsedLabelText;
    private String expandedLabelText = ResourceManager.getLabel("FewerDetails");
    private boolean expanded;
    private String detailText;
    private boolean details;
    private Button disabledButton;
    private String checkBoxLabel;
    private boolean checkBoxValue;
    private Label expandedPanel;
    private Composite composite;

    public FooterArea(Dialog parent) {
        super(parent);
        this.collapsedLabelText = ResourceManager.getLabel("MoreDetails");
    }

    public FooterArea addCheckBox(String label, boolean selection) {
        this.checkBoxLabel = label;
        this.checkBoxValue = selection;
        this.setInitialised(true);
        return this;
    }

    @Override
    void render() {
        int numberOfColumns;
        if (!this.isInitialised()) {
            return;
        }
        this.createSeparator();
        this.composite = new Composite((Composite)this.parent.shell, 0);
        this.composite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.composite.setBackground(this.getGreyColor());
        int n = numberOfColumns = this.buttonLabels == null ? 0 : this.buttonLabels.size();
        if (this.details) {
            numberOfColumns += 2;
        }
        GridLayout gridLayout = new GridLayout(numberOfColumns, false);
        gridLayout.marginWidth = 10;
        gridLayout.marginHeight = 10;
        this.composite.setLayout((Layout)gridLayout);
        if (this.details) {
            this.createDetails(numberOfColumns);
        }
        if (this.buttonLabels != null) {
            this.createButtons();
        }
        if (this.details && this.parent.getMessageArea().getException() == null && this.expanded) {
            this.createExpandedPanel(numberOfColumns);
        }
        if (this.checkBoxLabel != null) {
            this.createCheckBox(numberOfColumns);
        }
        if (this.footerText != null) {
            this.createFooter();
        }
    }

    private void createButtons() {
        Button defaultButton = null;
        int i = 0;
        while (i < this.buttonLabels.size()) {
            Button button = new Button(this.composite, 8);
            button.setText(this.buttonLabels.get(i));
            GridData gd = new GridData(3, 2, i == 0, false);
            gd.minimumWidth = 70;
            gd.widthHint = 70;
            button.setLayoutData((Object)gd);
            if (i == this.defaultButtonIndex) {
                defaultButton = button;
            }
            final Integer integer = new Integer(i);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FooterArea.this.parent.shell.dispose();
                    FooterArea.this.selectedButtonIndex = integer;
                }
            });
            if (i == this.timerIndexButton && this.timer != -1) {
                this.disabledButton = button;
                button.setData((Object)button.getText());
                button.setText(String.valueOf(button.getText()) + " (" + this.timer + ")");
                button.setEnabled(false);
            }
            ++i;
        }
        if (this.timerIndexButton != -1 && this.timer != -1) {
            Display.getCurrent().timerExec(1000, new Runnable(){

                @Override
                public void run() {
                    FooterArea footerArea = FooterArea.this;
                    footerArea.timer = footerArea.timer - 1;
                    if (FooterArea.this.disabledButton.isDisposed()) {
                        return;
                    }
                    if (FooterArea.this.timer == 0) {
                        FooterArea.this.disabledButton.setText((String)FooterArea.this.disabledButton.getData());
                        FooterArea.this.disabledButton.setEnabled(true);
                    } else {
                        FooterArea.this.disabledButton.setText(FooterArea.this.disabledButton.getData() + " (" + FooterArea.this.timer + ")");
                        Display.getCurrent().timerExec(1000, (Runnable)this);
                    }
                }
            });
        }
        this.parent.shell.setDefaultButton(defaultButton);
    }

    private void createDetails(int numberOfColumns) {
        final Label icon = new Label(this.composite, 0);
        icon.setBackground(this.getGreyColor());
        icon.setImage(this.isExpanded() ? this.getFewerDetailsImage() : this.getMoreDetailsImage());
        icon.setLayoutData((Object)new GridData(2, 2, false, false));
        final Label label = new Label(this.composite, 0);
        label.setBackground(this.getGreyColor());
        label.setText(this.isExpanded() ? this.expandedLabelText : this.collapsedLabelText);
        label.setLayoutData((Object)new GridData(1, 2, false, false));
        final int numberOfColumnsParam = numberOfColumns;
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                if (FooterArea.this.parent.getMessageArea().getException() != null) {
                    if (label.getText().equals(FooterArea.this.expandedLabelText)) {
                        label.setText(FooterArea.this.collapsedLabelText);
                        icon.setImage(FooterArea.this.getMoreDetailsImage());
                        FooterArea.this.parent.getMessageArea().hideException();
                    } else {
                        label.setText(FooterArea.this.expandedLabelText);
                        icon.setImage(FooterArea.this.getFewerDetailsImage());
                        FooterArea.this.parent.getMessageArea().showException();
                    }
                } else if (label.getText().equals(FooterArea.this.expandedLabelText)) {
                    label.setText(FooterArea.this.collapsedLabelText);
                    icon.setImage(FooterArea.this.getMoreDetailsImage());
                    FooterArea.this.expandedPanel.dispose();
                    FooterArea.this.parent.pack();
                } else {
                    label.setText(FooterArea.this.expandedLabelText);
                    icon.setImage(FooterArea.this.getFewerDetailsImage());
                    FooterArea.this.createExpandedPanel(numberOfColumnsParam);
                    FooterArea.this.parent.pack();
                }
            }
        };
        label.addListener(4, listener);
        icon.addListener(4, listener);
    }

    private void createCheckBox(int numberOfColumns) {
        final Button button = new Button(this.composite, 32);
        button.setText(this.checkBoxLabel);
        button.setSelection(this.checkBoxValue);
        button.setBackground(this.getGreyColor());
        button.setLayoutData((Object)new GridData(1, 2, true, false, numberOfColumns, 1));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FooterArea.this.checkBoxValue = button.getSelection();
            }
        });
    }

    private void createFooter() {
        this.createSeparator();
        Composite informationComposite = new Composite((Composite)this.parent.shell, 0);
        informationComposite.setLayoutData((Object)new GridData(4, 4, false, false));
        informationComposite.setBackground(this.getGreyColor());
        informationComposite.setLayout((Layout)new GridLayout(this.icon == null ? 1 : 2, false));
        if (this.icon != null) {
            Label labelIcon = new Label(informationComposite, 0);
            labelIcon.setBackground(this.getGreyColor());
            labelIcon.setImage(this.icon);
            labelIcon.setLayoutData((Object)new GridData(2, 2, false, false));
        }
        Label labelText = new Label(informationComposite, 0);
        labelText.setBackground(this.getGreyColor());
        labelText.setText(this.footerText);
        labelText.setLayoutData((Object)new GridData(4, 2, true, false));
    }

    private void createExpandedPanel(int numberOfColumns) {
        this.expandedPanel = new Label(this.composite, 2048);
        this.expandedPanel.setText(this.detailText);
        this.expandedPanel.setBackground(this.getGreyColor());
        GridData gd = new GridData(4, 4, false, false, numberOfColumns, 1);
        gd.heightHint = 150;
        gd.minimumHeight = 150;
        this.expandedPanel.setLayoutData((Object)gd);
    }

    private void createSeparator() {
        Composite c = new Composite((Composite)this.parent.shell, 0);
        c.setLayoutData((Object)new GridData(4, 4, true, false));
        c.setBackground(this.getGreyColor());
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        c.setLayout((Layout)gridLayout);
        Label separator = new Label(c, 258);
        separator.setLayoutData((Object)new GridData(4, 4, true, false));
    }

    public Image getIcon() {
        return this.icon;
    }

    public FooterArea setIcon(Image icon) {
        this.icon = icon;
        this.setInitialised(true);
        return this;
    }

    public String getFooterText() {
        return this.footerText;
    }

    public FooterArea setFooterText(String text) {
        this.footerText = text;
        this.setInitialised(true);
        return this;
    }

    public List<String> getButtonLabels() {
        return this.buttonLabels;
    }

    public FooterArea setButtonLabels(List<String> buttonLabels) {
        this.buttonLabels = buttonLabels;
        this.setInitialised(true);
        return this;
    }

    public FooterArea setButtonLabels(String ... buttonLabels) {
        this.buttonLabels = Arrays.asList(buttonLabels);
        this.setInitialised(true);
        return this;
    }

    public int getDefaultButtonIndex() {
        return this.defaultButtonIndex;
    }

    public FooterArea setDefaultButtonIndex(int defaultButtonIndex) {
        this.defaultButtonIndex = defaultButtonIndex;
        this.setInitialised(true);
        return this;
    }

    public int getTimer() {
        return this.timer;
    }

    public FooterArea setTimer(int timer) {
        this.timer = timer;
        this.setInitialised(true);
        return this;
    }

    public int getTimerIndexButton() {
        return this.timerIndexButton;
    }

    public FooterArea setTimerIndexButton(int timerIndexButton) {
        this.timerIndexButton = timerIndexButton;
        this.setInitialised(true);
        return this;
    }

    int getSelectedButton() {
        return this.selectedButtonIndex;
    }

    public String getCollapsedLabelText() {
        return this.collapsedLabelText;
    }

    public FooterArea setCollapsedLabelText(String collapsedLabelText) {
        this.details = true;
        this.collapsedLabelText = collapsedLabelText;
        this.setInitialised(true);
        return this;
    }

    public String getExpandedLabelText() {
        return this.expandedLabelText;
    }

    public FooterArea setExpandedLabelText(String expandedLabelText) {
        this.details = true;
        this.expandedLabelText = expandedLabelText;
        this.setInitialised(true);
        return this;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public FooterArea setExpanded(boolean expanded) {
        this.details = true;
        this.expanded = expanded;
        this.setInitialised(true);
        return this;
    }

    public String getDetailText() {
        return this.detailText;
    }

    public FooterArea setDetailText(String detailText) {
        this.details = true;
        this.detailText = detailText;
        this.setInitialised(true);
        return this;
    }

    public boolean getCheckBoxValue() {
        return this.checkBoxValue;
    }
}

