/*
 * Decompiled with CFR 0.152.
 */
package zipeditor;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import zipeditor.Messages;
import zipeditor.model.Node;
import zipeditor.model.ZipModel;

public class ZipEditorPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.tizen.common.externals";
    private static ZipEditorPlugin plugin;
    public static final boolean DEBUG;
    private Map images;
    private Map fModelToFileNode = new HashMap();

    static {
        DEBUG = Boolean.valueOf(Platform.getDebugOption((String)"ZipEditor/debug"));
    }

    public ZipEditorPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        if (this.images != null) {
            Iterator it = this.images.values().iterator();
            while (it.hasNext()) {
                ((Image)it.next()).dispose();
            }
            this.images.clear();
            this.images = null;
        }
        this.fModelToFileNode.clear();
        this.fModelToFileNode = null;
        super.stop(context);
    }

    public static ZipEditorPlugin getDefault() {
        if (plugin == null) {
            plugin = new ZipEditorPlugin();
        }
        return plugin;
    }

    public void addFileMonitor(File file, Node node) {
        HashMap<File, Object[]> fileToNode = (HashMap<File, Object[]>)this.fModelToFileNode.get(node.getModel());
        if (fileToNode == null) {
            fileToNode = new HashMap<File, Object[]>();
            this.fModelToFileNode.put(node.getModel(), fileToNode);
        }
        fileToNode.put(file, new Object[]{node, new Long(System.currentTimeMillis())});
    }

    public void removeFileMonitors(ZipModel model) {
        Map fileToNode = (Map)this.fModelToFileNode.remove(model);
        if (fileToNode != null) {
            fileToNode.clear();
        }
    }

    public void checkFilesForModification(ZipModel model) {
        Map fileToNode = (Map)this.fModelToFileNode.get(model);
        if (fileToNode == null) {
            return;
        }
        for (File file : fileToNode.keySet()) {
            Object[] value = (Object[])fileToNode.get(file);
            long creationTime = (Long)value[1];
            if (file.lastModified() <= creationTime) continue;
            value[1] = new Long(file.lastModified());
            this.indicateModification(fileToNode, file, (Node)((Object)value[0]));
        }
    }

    private void indicateModification(Map fileToNode, File file, Node node) {
        Object[] objectArray = new Object[2];
        objectArray[0] = file.getName();
        Object object = objectArray[1] = node.getModel().getZipPath() != null ? node.getModel().getZipPath().getName() : "";
        if (MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.getString("ZipEditor.1"), (String)Messages.getFormattedString("ZipEditor.0", objectArray))) {
            node.updateContent(file);
        } else {
            node.reset();
            fileToNode.remove(file);
        }
    }

    public static IStatus log(Object message) {
        IStatus status = null;
        Object debugMessage = message;
        if (message instanceof IStatus) {
            status = (IStatus)message;
            debugMessage = ((IStatus)message).getMessage();
        } else {
            status = message instanceof Throwable ? ZipEditorPlugin.createErrorStatus(((Throwable)message).getMessage(), (Throwable)message) : ZipEditorPlugin.createErrorStatus(message != null ? message.toString() : null, null);
        }
        plugin.getLog().log(status);
        if (DEBUG) {
            if (debugMessage instanceof Throwable) {
                ((Throwable)debugMessage).printStackTrace();
            } else {
                System.out.println(debugMessage);
            }
        }
        return status;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return ZipEditorPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static Image getImage(ImageDescriptor descriptor) {
        return ZipEditorPlugin.doGetImage(descriptor);
    }

    public static Image getImage(String path) {
        return ZipEditorPlugin.doGetImage(path);
    }

    private static Image doGetImage(Object object) {
        Image image;
        HashMap<Object, Image> images = ZipEditorPlugin.plugin.images;
        if (images == null) {
            images = ZipEditorPlugin.plugin.images = new HashMap<Object, Image>();
        }
        if ((image = (Image)images.get(object)) == null) {
            ImageDescriptor descriptor = object instanceof ImageDescriptor ? (ImageDescriptor)object : ZipEditorPlugin.getImageDescriptor((String)object);
            image = descriptor != null ? descriptor.createImage() : ImageDescriptor.getMissingImageDescriptor().createImage();
            images.put(object, image);
        }
        return image;
    }

    public static IStatus createErrorStatus(String message, Throwable exception) {
        return new Status(4, PLUGIN_ID, 0, message != null ? message : exception.toString(), exception);
    }

    private static IStatus[] createErrorStatuses(Throwable exception) {
        StringWriter sw = new StringWriter();
        if (exception != null) {
            exception.printStackTrace(new PrintWriter(sw));
        }
        StringTokenizer st = new StringTokenizer(sw.toString(), "\r\n");
        IStatus[] status = new IStatus[st.countTokens()];
        int i = 0;
        while (i < status.length) {
            status[i] = ZipEditorPlugin.createErrorStatus(st.nextToken(), null);
            ++i;
        }
        return status;
    }

    public static void showErrorDialog(Shell shell, String message, Throwable exception, boolean logError) {
        if (logError) {
            ZipEditorPlugin.log(exception);
        }
        ErrorDialog.openError((Shell)shell, (String)Messages.getString("ZipEditor.8"), (String)message, (IStatus)new MultiStatus(PLUGIN_ID, 0, ZipEditorPlugin.createErrorStatuses(exception), Messages.getString("ZipEditorPlugin.0"), exception));
    }

    public static void showErrorDialog(Shell shell, String message, Throwable exception) {
        ZipEditorPlugin.showErrorDialog(shell, message, exception, true);
    }
}

