/*
 * Decompiled with CFR 0.152.
 */
package zipeditor.model;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.tools.bzip2.CBZip2InputStream;
import org.apache.tools.bzip2.CBZip2OutputStream;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;
import org.apache.tools.tar.TarOutputStream;
import org.apache.tools.tar.TarUtils;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import zipeditor.Messages;
import zipeditor.Utils;
import zipeditor.ZipEditorPlugin;
import zipeditor.model.Bzip2Node;
import zipeditor.model.GzipNode;
import zipeditor.model.IModelListener;
import zipeditor.model.Node;
import zipeditor.model.TarNode;
import zipeditor.model.ZipNode;

public class ZipModel {
    public static final int ZIP = 1;
    public static final int TAR = 2;
    public static final int GZ = 3;
    public static final int TARGZ = 4;
    public static final int BZ2 = 5;
    public static final int TARBZ2 = 6;
    public static final int EMPTY = 99;
    public static final int INIT_STARTED = 1;
    public static final int INIT_FINISHED = 2;
    public static final int INITIALIZING = 4;
    public static final int DIRTY = 8;
    private static final int TAR_MAGIC_OFFSET = 257;
    private Node root;
    private File zipPath;
    private int state;
    private int type;
    private File tempDir;
    private boolean readonly;
    private Boolean storeFolders;
    private ListenerList listenerList = new ListenerList();
    private IErrorReporter errorReporter;

    public static int typeFromName(String string) {
        if (string != null) {
            String lowerCase = string.toLowerCase();
            if (lowerCase.endsWith(".tgz") || lowerCase.endsWith(".tar.gz")) {
                return 4;
            }
            if (lowerCase.endsWith(".gz")) {
                return 3;
            }
            if (lowerCase.endsWith(".tar")) {
                return 2;
            }
            if (lowerCase.endsWith(".tbz") || lowerCase.endsWith(".tar.bz2")) {
                return 6;
            }
            if (lowerCase.endsWith(".bz2")) {
                return 5;
            }
        }
        return 1;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static int detectType(InputStream contents) {
        if (!contents.markSupported()) {
            contents = new BufferedInputStream(contents);
        }
        contents.mark(1000000);
        int count = contents.read();
        contents.reset();
        if (count == -1) {
            return 99;
        }
        ZipInputStream zip = new ZipInputStream(contents);
        if (zip.getNextEntry() != null) {
            contents.reset();
            return 1;
        }
        contents.reset();
        try {
            contents.skip(2L);
            CBZip2InputStream bzip = new CBZip2InputStream(contents);
            if (ZipModel.isTarArchive((InputStream)bzip)) {
                contents.reset();
                return 6;
            }
            contents.reset();
            return 5;
        }
        catch (IOException iOException) {
            contents.reset();
            try {
                GZIPInputStream gzip = new GZIPInputStream(contents);
                if (ZipModel.isTarArchive(gzip)) {
                    contents.reset();
                    return 4;
                }
                contents.reset();
                return 3;
            }
            catch (IOException iOException2) {
                try {
                    contents.reset();
                    return 2;
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
    }

    private static boolean isTarArchive(InputStream bzip) throws IOException {
        byte[] tarEntryHeader = new byte[265];
        bzip.read(tarEntryHeader);
        String magic = String.valueOf(TarUtils.parseName((byte[])tarEntryHeader, (int)257, (int)8));
        return "ustar".equals(magic) || "ustar  ".equals(magic);
    }

    public ZipModel(File path, InputStream inputStream, boolean readonly) {
        this(path, inputStream, readonly, null);
    }

    public ZipModel(File path, final InputStream inputStream, boolean readonly, IErrorReporter errorReporter) {
        this.zipPath = path;
        this.readonly = readonly;
        this.errorReporter = errorReporter;
        this.state |= 4;
        if (path != null && path.length() >= 10000000L) {
            Thread initThread = new Thread(Messages.getFormattedString("ZipModel.0", path.getName())){

                @Override
                public void run() {
                    ZipModel.this.initialize(inputStream);
                }
            };
            initThread.start();
        } else {
            this.initialize(inputStream);
        }
    }

    public void logError(Object message) {
        IStatus status = ZipEditorPlugin.log(message);
        if (this.errorReporter != null) {
            this.errorReporter.reportError(status);
        }
    }

    private void initialize(InputStream inputStream) {
        long time = System.currentTimeMillis();
        InputStream zipStream = inputStream;
        try {
            try {
                zipStream = this.detectStream(inputStream);
                this.root = this.getRoot(zipStream);
                this.readStream(zipStream);
            }
            catch (IOException iOException) {
                if (zipStream != null) {
                    try {
                        zipStream.close();
                    }
                    catch (IOException e) {
                        this.logError(e);
                    }
                }
                this.state &= 0xFFFFFFFB;
                this.state |= 2;
                this.notifyListeners();
                this.state &= 0xFFFFFFFD;
                if (ZipEditorPlugin.DEBUG) {
                    System.out.println(this.zipPath + " initialized in " + (System.currentTimeMillis() - time) + "ms");
                }
            }
        }
        finally {
            if (zipStream != null) {
                try {
                    zipStream.close();
                }
                catch (IOException e) {
                    this.logError(e);
                }
            }
            this.state &= 0xFFFFFFFB;
            this.state |= 2;
            this.notifyListeners();
            this.state &= 0xFFFFFFFD;
            if (ZipEditorPlugin.DEBUG) {
                System.out.println(this.zipPath + " initialized in " + (System.currentTimeMillis() - time) + "ms");
            }
        }
    }

    private Node getRoot(InputStream zipStream) throws IOException {
        if (zipStream instanceof ZipInputStream) {
            return new ZipNode(this, "", true);
        }
        if (zipStream instanceof TarInputStream) {
            return new TarNode(this, "", true);
        }
        if (zipStream instanceof CBZip2InputStream) {
            return new Bzip2Node(this, "", true);
        }
        return new GzipNode(this, "", true);
    }

    private void readStream(InputStream zipStream) {
        boolean isNoEntry;
        ZipEntry zipEntry = null;
        TarEntry tarEntry = null;
        this.state |= 1;
        boolean bl = isNoEntry = zipStream instanceof GZIPInputStream || zipStream instanceof CBZip2InputStream;
        while (true) {
            Node existingNode;
            boolean isFolder;
            block21: {
                if (!this.isInitializing()) {
                    this.state |= 8;
                    break;
                }
                try {
                    if (zipStream instanceof ZipInputStream) {
                        zipEntry = ((ZipInputStream)zipStream).getNextEntry();
                        break block21;
                    }
                    if (!(zipStream instanceof TarInputStream)) break block21;
                    tarEntry = ((TarInputStream)zipStream).getNextEntry();
                }
                catch (Exception e) {
                    this.logError(e);
                    break;
                }
            }
            if (!isNoEntry && zipEntry == null && tarEntry == null || isNoEntry && this.root.children != null) {
                this.state &= 0xFFFFFFF7;
                break;
            }
            String entryName = zipEntry != null ? zipEntry.getName() : (tarEntry != null ? tarEntry.getName() : (this.zipPath.getName().endsWith(".gz") ? this.zipPath.getName().substring(0, this.zipPath.getName().length() - 3) : (this.zipPath.getName().endsWith(".bz2") ? this.zipPath.getName().substring(0, this.zipPath.getName().length() - 4) : this.zipPath.getName())));
            String[] names = this.splitName(entryName);
            Node node = null;
            int n = names.length - 1;
            int i = 0;
            while (i < n) {
                String pathSeg;
                Node parent = node != null ? node : this.root;
                if ((node = parent.getChildByName(pathSeg = names[i], false)) == null) {
                    node = parent.create(this, pathSeg, true);
                    parent.add(node, null);
                    node.time = -1L;
                }
                ++i;
            }
            boolean bl2 = isFolder = entryName.endsWith("/") || entryName.endsWith("\\") || zipEntry != null && zipEntry.isDirectory() || tarEntry != null && tarEntry.isDirectory();
            if (isFolder && this.storeFolders == null) {
                this.storeFolders = Boolean.TRUE;
            }
            if (node == null) {
                node = this.root;
            }
            Node node2 = existingNode = n == -1 ? null : node.getChildByName(names[n], false);
            if (existingNode != null) {
                existingNode.update(zipEntry != null ? zipEntry : tarEntry);
            } else {
                String name;
                String string = name = n >= 0 ? names[n] : "/";
                Node newChild = zipEntry != null ? new ZipNode(this, zipEntry, name, isFolder) : (tarEntry != null ? new TarNode(this, tarEntry, name, isFolder) : (zipStream instanceof CBZip2InputStream ? new Bzip2Node(this, name, isFolder) : new GzipNode(this, name, isFolder)));
                node.add(newChild, null);
                long entrySize = 0L;
                if (this.zipPath == null || isNoEntry) {
                    byte[] buf = new byte[8000];
                    ByteArrayOutputStream out = null;
                    try {
                        int count = 0;
                        while ((count = zipStream.read(buf)) != -1) {
                            if (out == null) {
                                out = new ByteArrayOutputStream();
                            }
                            out.write(buf, 0, count);
                            if (!isNoEntry) continue;
                            entrySize += (long)count;
                        }
                    }
                    catch (Exception e) {
                        this.logError(e);
                    }
                    if (out != null) {
                        newChild.setContent(out.toByteArray());
                    }
                }
                if (zipStream instanceof ZipInputStream) {
                    try {
                        ((ZipInputStream)zipStream).closeEntry();
                    }
                    catch (Exception e) {
                        this.logError(e);
                    }
                }
                newChild.setSize(zipEntry != null ? zipEntry.getSize() : (tarEntry != null ? tarEntry.getSize() : entrySize));
            }
            this.state &= 0xFFFFFFFE;
        }
    }

    private InputStream detectStream(InputStream contents) throws IOException {
        BufferedInputStream in = new BufferedInputStream(contents);
        this.type = ZipModel.detectType(in);
        switch (this.type) {
            default: {
                return in;
            }
            case 1: {
                return new ZipInputStream(in);
            }
            case 2: {
                return new TarInputStream((InputStream)in);
            }
            case 3: {
                return new GZIPInputStream(in);
            }
            case 4: {
                return new TarInputStream((InputStream)new GZIPInputStream(in));
            }
            case 5: {
                in.skip(2L);
                return new CBZip2InputStream((InputStream)in);
            }
            case 6: 
        }
        in.skip(2L);
        return new TarInputStream((InputStream)new CBZip2InputStream((InputStream)in));
    }

    public InputStream save(int type, IProgressMonitor monitor) throws IOException {
        File tmpFile;
        block14: {
            tmpFile = new File(this.root.getModel().getTempDir(), Integer.toString((int)System.currentTimeMillis()));
            OutputStream out = new FileOutputStream(tmpFile);
            try {
                try {
                    switch (type) {
                        case 3: {
                            out = new GZIPOutputStream(out);
                            break;
                        }
                        case 2: {
                            out = new TarOutputStream(out);
                            break;
                        }
                        case 4: {
                            out = new TarOutputStream((OutputStream)new GZIPOutputStream(out));
                            break;
                        }
                        case 1: {
                            out = new ZipOutputStream(out);
                            break;
                        }
                        case 6: {
                            out.write(new byte[]{66, 90});
                            out = new TarOutputStream((OutputStream)new CBZip2OutputStream(out));
                            break;
                        }
                        case 5: {
                            out.write(new byte[]{66, 90});
                            out = new CBZip2OutputStream(out);
                        }
                    }
                    if (out instanceof TarOutputStream) {
                        ((TarOutputStream)out).setLongFileMode(2);
                    }
                    this.saveNodes(out, this.root, type, this.isStoreFolders(), monitor);
                }
                catch (Exception e) {
                    this.logError(e);
                    out.close();
                    break block14;
                }
            }
            catch (Throwable throwable) {
                out.close();
                throw throwable;
            }
            out.close();
        }
        return new FileInputStream(tmpFile);
    }

    private void saveNodes(OutputStream out, Node node, int type, boolean storeFolders, IProgressMonitor monitor) throws IOException {
        if (out == null) {
            return;
        }
        Node[] children = node.getChildren();
        int i = 0;
        while (i < children.length) {
            block16: {
                TarEntry tarEntry;
                String entryName;
                Node child;
                block15: {
                    if (monitor.isCanceled()) break;
                    child = children[i];
                    entryName = String.valueOf(child.getPath()) + child.getName();
                    if (!child.isFolder()) break block15;
                    this.saveNodes(out, child, type, storeFolders, monitor);
                    if (!storeFolders) break block16;
                    entryName = child.getPath();
                }
                ZipEntry zipEntry = type == 1 ? new ZipEntry(entryName) : null;
                Object object = tarEntry = type == 2 || type == 4 || type == 6 ? new TarEntry(entryName) : null;
                if (zipEntry != null) {
                    zipEntry.setTime(child.getTime());
                    if (child instanceof ZipNode) {
                        zipEntry.setComment(((ZipNode)child).getComment());
                    }
                } else if (tarEntry != null) {
                    tarEntry.setModTime(child.getTime());
                    tarEntry.setSize(child.getSize());
                    if (child instanceof TarNode) {
                        TarNode tarNode = (TarNode)child;
                        tarEntry.setGroupId(tarNode.getGroupId());
                        tarEntry.setGroupName(tarNode.getGroupName());
                        tarEntry.setUserId(tarNode.getUserId());
                        tarEntry.setUserName(tarNode.getUserName());
                        tarEntry.setGroupId(tarNode.getGroupId());
                        tarEntry.setMode(tarNode.getMode());
                    } else {
                        tarEntry.setMode(33188);
                    }
                }
                if (out instanceof ZipOutputStream) {
                    ((ZipOutputStream)out).putNextEntry(zipEntry);
                } else if (out instanceof TarOutputStream) {
                    ((TarOutputStream)out).putNextEntry(tarEntry);
                }
                Utils.readAndWrite(child.getContent(), out, false);
                if (tarEntry != null) {
                    ((TarOutputStream)out).closeEntry();
                }
                monitor.worked(1);
            }
            ++i;
        }
    }

    public Node createFolderNode(Node parent, String name) {
        Node newNode = null;
        String[] names = this.splitName(name);
        int i = 0;
        while (i < names.length) {
            newNode = parent.getChildByName(names[i], false);
            if (newNode == null) {
                newNode = parent.create(this, names[i], true);
                parent.add(newNode, null);
            }
            parent = newNode;
            ++i;
        }
        return newNode;
    }

    private String[] splitName(String name) {
        ArrayList<String> list = new ArrayList<String>();
        while (name != null && name.length() > 0) {
            int index = name.indexOf(47);
            if (index == -1) {
                index = name.indexOf(92);
            }
            if (index != -1) {
                list.add(name.substring(0, index));
                name = name.substring(index + 1);
                continue;
            }
            list.add(name);
            name = new String();
        }
        return list.toArray(new String[list.size()]);
    }

    public void addModelListener(IModelListener listener) {
        this.listenerList.add((Object)listener);
    }

    public void removeModelListener(IModelListener listener) {
        this.listenerList.remove((Object)listener);
    }

    protected void notifyListeners() {
        Object[] listeners = this.listenerList.getListeners();
        IModelListener.ModelChangeEvent event = new IModelListener.ModelChangeEvent(this);
        int i = 0;
        while (i < listeners.length) {
            ((IModelListener)listeners[i]).modelChanged(event);
            ++i;
        }
    }

    public void dispose() {
        this.state &= 0xFFFFFFFB;
        this.deleteTempDir(this.tempDir);
        this.tempDir = null;
        ZipEditorPlugin.getDefault().removeFileMonitors(this);
        if (ZipEditorPlugin.DEBUG) {
            System.out.println(this.zipPath + " disposed");
        }
    }

    private void deleteTempDir(final File tmpDir) {
        if (this.deleteFile(tmpDir)) {
            return;
        }
        Job job = new Job("Deleting temporary directory"){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask("Waiting for accessing tasks to be finished", -1);
                do {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {}
                } while (!monitor.isCanceled() && !ZipModel.this.deleteFile(tmpDir));
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        job.schedule();
    }

    boolean deleteFile(File file) {
        boolean success;
        File[] files;
        if (file == null) {
            return true;
        }
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            int i = 0;
            while (i < files.length) {
                this.deleteFile(files[i]);
                ++i;
            }
        }
        if (!(success = file.delete())) {
            System.out.println("Couldn't delete " + file);
        }
        return success;
    }

    public File getTempDir() {
        if (this.tempDir == null) {
            File sysTmpDir = new File(System.getProperty("java.io.tmpdir"));
            this.tempDir = new File(sysTmpDir, "zip" + (int)System.currentTimeMillis());
            this.tempDir.mkdirs();
        }
        return this.tempDir;
    }

    public Node getRoot() {
        return this.root;
    }

    public int getType() {
        return this.type;
    }

    int getState() {
        return this.state;
    }

    public boolean isInitializing() {
        return (this.state & 4) > 0;
    }

    public boolean isDirty() {
        return (this.state & 8) > 0;
    }

    public void setDirty(boolean dirty) {
        if (dirty) {
            if (!this.isInitializing()) {
                this.state |= 8;
            }
        } else {
            this.state &= 0xFFFFFFF7;
        }
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public File getZipPath() {
        return this.zipPath;
    }

    public Node findNode(String path) {
        String[] names = this.splitName(path);
        Node node = this.root;
        int i = 0;
        while (i < names.length && node != null) {
            node = node.getChildByName(names[i], false);
            ++i;
        }
        return node;
    }

    public boolean isStoreFolders() {
        return this.storeFolders != null ? this.storeFolders.booleanValue() : ZipEditorPlugin.getDefault().getPreferenceStore().getBoolean("storeFoldersInArchives");
    }

    public void setStoreFolders(boolean store) {
        this.storeFolders = store ? Boolean.TRUE : Boolean.FALSE;
    }

    public static interface IErrorReporter {
        public void reportError(IStatus var1);
    }
}

