/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.rest.run;

import com.google.gson.annotations.Expose;
import java.util.LinkedHashMap;
import java.util.Map;
import org.tizen.common.rest.RestPlugin;

public class MaxSizeHashMap<K, V>
extends LinkedHashMap<K, V> {
    @Expose(serialize=false, deserialize=false)
    private static final long serialVersionUID = 8412794369571934913L;
    @Expose(serialize=false, deserialize=false)
    private final int maxSize;

    public MaxSizeHashMap() {
        this(RestPlugin.getDefault().getPreferenceStore().getInt("PREF_KEY_RUN_HISTORY_SIZE"));
    }

    public MaxSizeHashMap(int maxSize) {
        this.maxSize = maxSize;
    }

    public MaxSizeHashMap(int maxSize, int initialCapacity) {
        super(initialCapacity);
        this.maxSize = maxSize;
    }

    public MaxSizeHashMap(int maxSize, Map<? extends K, ? extends V> m) {
        super(m);
        this.maxSize = maxSize;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return this.size() > this.maxSize;
    }

    public int getMaxSize() {
        return this.maxSize;
    }
}

