/*
 * Command line interface
 *
 * Copyright (c) 2000 - 2011 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Contact: 
 * BonYong Lee <bonyong.lee@samsung.com>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 * - S-Core Co., Ltd
 *
 */
package org.tizen.cli.exec;

public class LaunchOptionConstants
{
    private LaunchOptionConstants() {}

    /**
     * <p>
     *Description for failed operation
     * 
     * This is printed when widget ID is empty
     * </p>
     */
    public static final String DESC_FAILED_CANNOT_FIND_WIDGET_ID = "Can't find application ID";

    /**
     * <p>
     *Description for failed operation
     * 
     * This is printed when device is not connected
     * </p>
     */
    public static final String DESC_FAILED_CANNOT_FIND_CONNECTED_DEVICE = "Can't find connected device";

    /**
     * <p>
     *Description for failed operation
     * 
     * This is printed when device is not connected
     * </p>
     */
    public static final String DESC_FAILED_CANNOT_FIND_SELECTED_DEVICE = "Can't find selected device";

    /**
     * <p>
     *Description for failed operation
     * 
     * This is printed when mode setting operation failed
     * </p>
     */
    public static final String DESC_FAILED_MODE_SETTING = "Development mode setting failed";

    
    /**
     * <p>
     * Description for target widget id
     * 
     * This is printed out in usage
     * </p>
     * 
     * @see #OPT_WIDGETID
     */
    public static final String DESC_WIDGETID = "Application id (user-written id in config.xml)";

    /**
     * <p>
     * Option for target widget file
     * </p>
     */
    public static final String OPT_WIDGETFILE = "widget";

    /**
     * <p>
     * Description for target widget file
     * 
     * This is printed out in usage
     * </p>
     * 
     * @see #OPT_WIDGETFILE
     */
    public static final String DESC_WIDGETFILE = "Widget file (*.wgt)";

    /**
     * <p>
     * Option for target widget id
     * </p>
     */
    public static final String OPT_WIDGETID = "id";

    /**
     * <p>
     * Option for project name
     * </p>
     */
    public static final String OPT_NAME = "name";

    /**
     * <p>
     * Description for project name
     * 
     * This is printed out in usage
     * </p>
     * 
     * @see #OPT_WIDGETFILE
     */
    public static final String DESC_NAME = "Project name";

    /**
     * <p>
     * Option for project name
     * </p>
     */
    public static final String OPT_PATH = "path";

    /**
     * <p>
     * Description for project name
     * 
     * This is printed out in usage
     * </p>
     * 
     * @see #OPT_WIDGETFILE
     */
    public static final String DESC_PATH = "Project path";

    
    /**
     * <p>
     * Option for include file pattern
     * </p>
     */
    public static final String OPT_INCLUDE = "include";
    
    /**
     * <p>
     * Description for include file pattern option
     * 
     * It is printed out in usage
     * </p>
     */
    public static final String DESC_INCLUDE = "File name pattern to include";
    
    /**
     * <p>
     * Option for exclude file pattern
     * </p>
     */
    public static final String OPT_EXCLUDE = "exclude";
    
    /**
     * <p>
     * Description for exclude file pattern option
     * 
     * It is printed out in usage
     * </p>
     */
    public static final String DESC_EXCLUDE = "File name pattern to exclude";
    
    /**
     * <p>
     * Option for no check of validation
     * </p>
     */
    public static final String OPT_NOCHECK = "nocheck";
    
    /**
     * <p>
     * Description for no check option
     * 
     * It is printed out in usage
     * </p>
     */
    public static final String DESC_NOCHECK = "Skip validation check";
    
    /**
     * <p>
     * Option for over-writing of output file
     * </p>
     */
    public static final String OPT_OVERWRITE = "overwrite";
    
    /**
     * <p>
     * Description for overwrite option
     * 
     * It is printed out in usage
     * </p>
     */
    public static final String DESC_OVERWRITE = "Overwrite output file if it exists";
    
    /**
     *  <p>
     *  Option for develop mode
     *  </p>
     */
    public static final String OPT_DEVELOP = "develop";
    
    /**
     * <p>
     * Description for develop mode of profile
     * </p> 
     */
    public static final String DESC_DEVELOP_PROFILE = "Add the profile information for development automatically";
}
