/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.builder.core;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.FactoryWithArgument;
import org.tizen.common.builder.BuildResult;
import org.tizen.common.builder.IBuildListener;
import org.tizen.common.builder.IBuilder;
import org.tizen.common.builder.exception.BuildException;
import org.tizen.common.file.FileHandler;
import org.tizen.common.file.Filter;
import org.tizen.common.file.IResource;
import org.tizen.common.file.Resource;
import org.tizen.common.file.SimpleFileFilter;
import org.tizen.common.file.StandardFileHandler;
import org.tizen.common.file.filter.WildCardFilterFactory;

public abstract class AbstractBuilder
implements IBuilder {
    protected final Logger logger = LoggerFactory.getLogger(AbstractBuilder.class);
    protected SimpleFileFilter filter = new SimpleFileFilter(true);
    protected FactoryWithArgument<Filter, String> filterFactory = new WildCardFilterFactory();
    protected FileHandler fileHandler = new StandardFileHandler();
    private IBuildListener buildListener = null;

    public AbstractBuilder() {
    }

    public AbstractBuilder(IBuildListener buildListener) {
        this.buildListener = buildListener;
    }

    public AbstractBuilder(String outputDir) {
        this.fileHandler.setCurrentWorkingDirectory(outputDir);
    }

    public AbstractBuilder(String output, IBuildListener buildListener) {
        this(output);
        this.buildListener = buildListener;
    }

    public AbstractBuilder(FileHandler fh) {
        this.fileHandler = fh;
    }

    public AbstractBuilder(FileHandler fh, IBuildListener buildListener) {
        this(fh);
        this.buildListener = buildListener;
    }

    @Override
    public boolean canBuild(IResource resource) {
        if (resource == null) {
            return false;
        }
        FileHandler fh = resource.getFileHandler();
        String path = resource.getPath();
        path = path.replace("\\", "/");
        try {
            if (!fh.is(path, FileHandler.Attribute.EXISTS)) {
                return false;
            }
        }
        catch (IOException e) {
            this.logger.warn("Failed to check file path", (Throwable)e);
            return false;
        }
        if (!this.filter.accept(null, path)) {
            this.logger.debug("Ignore {}", (Object)path);
            return false;
        }
        return true;
    }

    @Override
    public BuildResult build(IResource resource) throws BuildException {
        if (this.buildListener != null) {
            this.buildListener.preBuild(resource);
        }
        BuildResult result = this.doBuild(resource);
        if (this.buildListener != null) {
            if (BuildResult.Status.SUCCESS.equals((Object)result.getResult())) {
                this.buildListener.buildSuccess(result);
            } else if (BuildResult.Status.WARNING.equals((Object)result.getResult())) {
                this.buildListener.buildWarning(result);
            } else if (BuildResult.Status.ERROR.equals((Object)result.getResult())) {
                this.buildListener.buildError(result);
            }
            this.buildListener.postBuild(resource);
        }
        return result;
    }

    public void setExcludes(String ... excludes) {
        this.filter.clearExcludes();
        if (excludes != null) {
            String[] stringArray = excludes;
            int n = excludes.length;
            int n2 = 0;
            while (n2 < n) {
                String exclude = stringArray[n2];
                this.filter.addExcludes(new Filter[]{(Filter)this.filterFactory.create((Object)exclude)});
                ++n2;
            }
        }
    }

    @Override
    public FileHandler getOutputFileHandler() {
        return this.fileHandler;
    }

    public IResource addOutputResource(BuildResult result, IResource resource, String outputPath, byte[] byteArray) throws IOException {
        Resource outResource = new Resource(this.getOutputFileHandler(), outputPath);
        outResource.setContents(byteArray);
        result.addDependency(resource, (IResource)outResource);
        result.setResult(BuildResult.Status.SUCCESS);
        return outResource;
    }

    protected abstract BuildResult doBuild(IResource var1) throws BuildException;

    public void addListener(IBuildListener listener) {
        this.buildListener = listener;
    }
}

